/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.Text;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/grazie/text/CommentProblemFilter;", "Lcom/intellij/grazie/text/ProblemFilter;", "<init>", "()V", "tokenizer", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "getTokenizer", "()Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "shouldIgnore", "", "problem", "Lcom/intellij/grazie/text/TextProblem;", "textAround", "", "text", "range", "Lcom/intellij/openapi/util/TextRange;", "isInFirstSentence", "isAboutIdentifierParts", "Lcom/intellij/grazie/text/TextContent;", "isTodoComment", "file", "Lcom/intellij/psi/PsiFile;", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nCommentProblemFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentProblemFilter.kt\ncom/intellij/grazie/text/CommentProblemFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,64:1\n1755#2,3:65\n12567#3,2:68\n*S KotlinDebug\n*F\n+ 1 CommentProblemFilter.kt\ncom/intellij/grazie/text/CommentProblemFilter\n*L\n52#1:65,3\n61#1:68,2\n*E\n"})
public final class CommentProblemFilter
extends ProblemFilter {
    private final StandardSentenceTokenizer getTokenizer() {
        return StandardSentenceTokenizer.Companion.getDefault();
    }

    @Override
    public boolean shouldIgnore(@NotNull TextProblem problem) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"getText(...)");
        TextContent text2 = textContent;
        TextContent.TextDomain domain = text2.getDomain();
        if (domain == TextContent.TextDomain.COMMENTS || domain == TextContent.TextDomain.DOCUMENTATION) {
            PsiFile psiFile = text2.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            if (this.isTodoComment(psiFile, text2)) {
                return true;
            }
            String string2 = problem.getRule().getGlobalId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getGlobalId(...)");
            if (StringsKt.startsWith$default((String)string2, (String)"LanguageTool.", (boolean)false, (int)2, null) && this.isAboutIdentifierParts(problem, text2)) {
                return true;
            }
            if (this.isInFirstSentence(problem) && problem.fitsGroup(new RuleGroup(stringArray = new String[]{"INCOMPLETE_SENTENCE"}))) {
                return true;
            }
        }
        if (domain == TextContent.TextDomain.COMMENTS) {
            stringArray = new String[]{"UNDECORATED_SENTENCE_SEPARATION"};
            if (problem.fitsGroup(new RuleGroup(stringArray))) {
                return true;
            }
            if (Text.isSingleSentence(text2) && problem.fitsGroup(RuleGroup.UNDECORATED_SINGLE_SENTENCE)) {
                return true;
            }
        }
        return false;
    }

    private final CharSequence textAround(CharSequence text2, TextRange range) {
        return text2.subSequence(RangesKt.coerceAtLeast((int)(range.getStartOffset() - 20), (int)0), RangesKt.coerceAtMost((int)(range.getEndOffset() + 20), (int)text2.length()));
    }

    private final boolean isInFirstSentence(TextProblem problem) {
        StandardSentenceTokenizer standardSentenceTokenizer = this.getTokenizer();
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"getText(...)");
        CharSequence charSequence = textContent;
        int n = 0;
        int n2 = problem.getHighlightRanges().get(0).getStartOffset();
        return standardSentenceTokenizer.tokenize(((Object)charSequence.subSequence(n, n2)).toString()).size() <= 1;
    }

    private final boolean isAboutIdentifierParts(TextProblem problem, TextContent text2) {
        boolean bl;
        block3: {
            List<TextRange> list = problem.getHighlightRanges();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
            List<TextRange> ranges = list;
            Iterable $this$any$iv = ranges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TextRange it = (TextRange)element$iv;
                    boolean bl2 = false;
                    if (!(StringsKt.endsWith$default((CharSequence)text2.subSequence(0, it.getStartOffset()), (char)'_', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)text2.subSequence(it.getEndOffset(), text2.length()), (char)'_', (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isTodoComment(PsiFile file, TextContent text2) {
        boolean bl;
        block2: {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (DumbService.Companion.getInstance(project).isDumb()) {
                return false;
            }
            TodoItem[] todos = (TodoItem[])CachedValuesManager.getProjectPsiDependentCache((PsiElement)((PsiElement)file), arg_0 -> CommentProblemFilter.isTodoComment$lambda$2(CommentProblemFilter::isTodoComment$lambda$1, arg_0));
            Intrinsics.checkNotNull((Object)todos);
            TodoItem[] $this$any$iv = todos;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                TodoItem element$iv;
                TodoItem it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!text2.intersectsRange(it.getTextRange())) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private static final TodoItem[] isTodoComment$lambda$1(PsiFile it) {
        return PsiTodoSearchHelper.getInstance((Project)it.getProject()).findTodoItems(it);
    }

    private static final TodoItem[] isTodoComment$lambda$2(Function1 $tmp0, Object p0) {
        return (TodoItem[])$tmp0.invoke(p0);
    }
}

