/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.CoreGridHelper;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.base.BaseGridHelperKt;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.Version;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J:\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0016JJ\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0016J\u001c\u0010\u001d\u001a\u00020\u00182\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/base/BaseGridHelper;", "Lcom/intellij/database/datagrid/CoreGridHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "setFilterText", "", "grid", "Lcom/intellij/database/datagrid/CoreGrid;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "text", "", "caretPosition", "", "getCellLanguage", "Lcom/intellij/lang/Language;", "row", "Lcom/intellij/database/datagrid/ModelIndex;", "column", "canMutateColumns", "", "createCellCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "project", "Lcom/intellij/openapi/project/Project;", "isMixedTypeColumns", "isSortingApplicable", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nBaseGridHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseGridHelper.kt\ncom/intellij/database/dialects/base/BaseGridHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public abstract class BaseGridHelper
implements CoreGridHelper {
    @NotNull
    private final Dbms dbms;

    public BaseGridHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
    }

    @NotNull
    protected final Dbms getDbms() {
        return this.dbms;
    }

    public void setFilterText(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull String text2, int caretPosition) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        grid.setFilterText(text2, caretPosition);
    }

    @Nullable
    public Language getCellLanguage(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        Domain domain;
        block5: {
            GridColumn c2;
            block4: {
                Intrinsics.checkNotNullParameter(grid, (String)"grid");
                Intrinsics.checkNotNullParameter(row, (String)"row");
                Intrinsics.checkNotNullParameter(column2, (String)"column");
                GridColumn gridColumn = (GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column2);
                if (gridColumn == null) {
                    return null;
                }
                c2 = gridColumn;
                DbDataSource dbDataSource = DataGridUtilCore.getDatabaseSystem(grid);
                Version version = dbDataSource != null ? dbDataSource.getVersion() : null;
                DomainRegistry domainRegistry = BaseDomainRegistry.get(this.dbms, version);
                Intrinsics.checkNotNullExpressionValue((Object)domainRegistry, (String)"get(...)");
                DomainRegistry registry = domainRegistry;
                domain = registry.getDomain((ColumnDescriptor)c2);
                if (domain == null) break block4;
                Domain it = domain;
                boolean bl = false;
                Language language = BaseGridHelperKt.access$getCellLanguage(it);
                domain = language;
                if (language != null) break block5;
            }
            domain = BaseGridHelperKt.access$getLanguageByTypeName(c2.getTypeName());
        }
        return domain;
    }

    public boolean canMutateColumns(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return false;
    }

    @Nullable
    public PsiCodeFragment createCellCodeFragment(@NotNull String text2, @NotNull Project project, @NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return null;
    }

    public boolean isMixedTypeColumns(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return false;
    }

    public boolean isSortingApplicable() {
        return true;
    }
}

