/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.NameCache;
import com.intellij.database.dialects.h2.introspector.H2IntroQueries;
import com.intellij.database.dialects.h2.introspector.H2IntrospectorKt;
import com.intellij.database.dialects.h2.model.H2Aggregate;
import com.intellij.database.dialects.h2.model.H2Argument;
import com.intellij.database.dialects.h2.model.H2Check;
import com.intellij.database.dialects.h2.model.H2Constant;
import com.intellij.database.dialects.h2.model.H2Constraint;
import com.intellij.database.dialects.h2.model.H2Database;
import com.intellij.database.dialects.h2.model.H2Domain;
import com.intellij.database.dialects.h2.model.H2ForeignKey;
import com.intellij.database.dialects.h2.model.H2Index;
import com.intellij.database.dialects.h2.model.H2Key;
import com.intellij.database.dialects.h2.model.H2LikeRoutine;
import com.intellij.database.dialects.h2.model.H2LikeTable;
import com.intellij.database.dialects.h2.model.H2Role;
import com.intellij.database.dialects.h2.model.H2Root;
import com.intellij.database.dialects.h2.model.H2Routine;
import com.intellij.database.dialects.h2.model.H2Schema;
import com.intellij.database.dialects.h2.model.H2Sequence;
import com.intellij.database.dialects.h2.model.H2Synonym;
import com.intellij.database.dialects.h2.model.H2Table;
import com.intellij.database.dialects.h2.model.H2TableColumn;
import com.intellij.database.dialects.h2.model.H2Trigger;
import com.intellij.database.dialects.h2.model.H2User;
import com.intellij.database.dialects.h2.model.H2View;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.references.BasicInlineObjectReference;
import com.intellij.database.model.properties.references.BasicKeyByIndexReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.h2.H2Dialect;
import com.intellij.sql.dialects.h2.H2Lexer;
import com.intellij.sql.dialects.h2.psi.H2OnUpdateClause;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlColumnGeneratedClause;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.StringKt;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0004./01B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ&\u0010\u000b\u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030\fR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001H\u0014J4\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u00030\u000eR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J4\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u00040\u0013R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0004H\u0014J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0014\u0010\u0019\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0017H\u0002J\u000e\u0010!\u001a\u0004\u0018\u00010\u001d*\u00020\"H\u0002J\"\u0010#\u001a\u00020\u001b2\b\u0010$\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0017H\u0002R\u0014\u0010%\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010'R\u0014\u0010(\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010'R\u0014\u0010)\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/h2/model/H2Root;", "Lcom/intellij/database/dialects/h2/model/H2Database;", "Lcom/intellij/database/dialects/h2/model/H2Schema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "schema", "maskDefaultPrecision", "", "default", "maskDefaultScale", "getIntervalDasType", "Lcom/intellij/database/types/DasType;", "primary", "Lcom/intellij/database/dialects/h2/introspector/H2Introspector$Interval;", "secondary", "precision", "scale", "toIntervalKind", "", "getDasType", "typeName", "isV2", "", "()Z", "isNewSchema", "defaultVarDataMaxLength", "getDefaultVarDataMaxLength", "()I", "typeSystem", "Lcom/intellij/database/types/DasTypeSystemBase;", "Factory", "H2DatabaseBaseDatabaseRetriever", "H2SchemaAbstractSchemaRetriever", "Interval", "intellij.database.dialects.h2"})
public final class H2Introspector
extends BaseMultiDatabaseIntrospector<H2Root, H2Database, H2Schema> {
    @NotNull
    private final DasTypeSystemBase typeSystem;

    public H2Introspector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.H2;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"H2");
        super(context, nature, dbms, modelFactory);
        this.typeSystem = DasTypeSystems.getTypeSystem(this.dbms);
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?, ?> createDatabaseLister() {
        return new BaseMultiDatabaseIntrospector.DatabaseLister<H2IntroQueries.DbInfo, H2Database>(this){
            final /* synthetic */ H2Introspector this$0;
            {
                this.this$0 = $receiver;
            }

            protected List<H2IntroQueries.DbInfo> listDatabases(DBTransaction tran) {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                return H2IntroQueries.INSTANCE.retrieveDatabases(tran, H2Introspector.access$isNewSchema(this.this$0));
            }

            protected H2Database applyDatabase(ModNamingFamily<?> databases, H2IntroQueries.DbInfo db) {
                Intrinsics.checkNotNullParameter(databases, (String)"databases");
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                return (H2Database)this.renew(databases, db.catalog_name);
            }
        };
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<H2Database> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull H2Database database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new H2DatabaseBaseDatabaseRetriever(transaction, database);
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractSchemaRetriever<H2Schema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull H2Schema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new H2SchemaAbstractSchemaRetriever(transaction, schema);
    }

    private final int maskDefaultPrecision(int $this$maskDefaultPrecision, int n) {
        return $this$maskDefaultPrecision != n ? $this$maskDefaultPrecision : -1;
    }

    private final int maskDefaultScale(int $this$maskDefaultScale, int n) {
        return $this$maskDefaultScale != n ? $this$maskDefaultScale : 0;
    }

    private final DasType getIntervalDasType(Interval primary, Interval secondary, int precision, int scale) {
        StringBuilder stringBuilder;
        int actualScale = (primary == Interval.SECOND || secondary == Interval.SECOND) && scale != 6 ? scale : 0;
        int actualPrecision = precision != 2 || actualScale != 0 && secondary == null ? precision : 0;
        StringBuilder $this$getIntervalDasType_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getIntervalDasType_u24lambda_u240.append("INTERVAL " + primary.name());
        if (actualPrecision != 0) {
            $this$getIntervalDasType_u24lambda_u240.append("(" + actualPrecision);
            if (actualScale != 0 && secondary == null) {
                $this$getIntervalDasType_u24lambda_u240.append(", " + actualScale);
            }
            $this$getIntervalDasType_u24lambda_u240.append(")");
        }
        if (secondary != null) {
            $this$getIntervalDasType_u24lambda_u240.append(" TO " + secondary.name());
            if (actualScale != 0) {
                $this$getIntervalDasType_u24lambda_u240.append("(" + actualScale + ")");
            }
        }
        String spec = stringBuilder.toString();
        DataType dataType = DataTypeFactory.of(spec);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        DataType dataType2 = dataType;
        return this.typeSystem.createDasType(dataType2);
    }

    private final Interval toIntervalKind(String $this$toIntervalKind) {
        Interval interval;
        try {
            interval = Interval.valueOf($this$toIntervalKind);
        }
        catch (Exception e) {
            interval = null;
        }
        return interval;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final DasType getDasType(String typeName, int precision, int scale) {
        var4_4 = typeName;
        if (var4_4 == null || var4_4.length() == 0) {
            return DasTypeSystemBase.UNKNOWN;
        }
        if (StringsKt.startsWith$default((String)typeName, (String)"INTERVAL", (boolean)false, (int)2, null)) {
            var5_6 = new char[]{' '};
            components = StringsKt.split$default((CharSequence)typeName, (char[])var5_6, (boolean)false, (int)0, (int)6, null);
            v0 /* !! */  = (String)CollectionsKt.getOrNull((List)components, (int)1);
            if (v0 /* !! */  == null || (v0 /* !! */  = this.toIntervalKind(v0 /* !! */ )) == null) {
                return DasTypeSystemBase.UNKNOWN;
            }
            primaryKind /* !! */  = v0 /* !! */ ;
            v1 = (String)CollectionsKt.getOrNull((List)components, (int)3);
            secondaryKind = v1 != null ? this.toIntervalKind(v1) : null;
            return this.getIntervalDasType((Interval)primaryKind /* !! */ , secondaryKind, precision, scale);
        }
        primaryKind = new int[]{1, 4, 197};
        timestampDefaultPrecision = this.getServerVersion().isOrGreater(primaryKind) != false ? 6 : 10;
        actualPrecision = 0;
        actualScale = 0;
        suffix = "";
        actualTypeName = typeName;
        var9_13 = typeName;
        if (var9_13 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var9_13.hashCode()) {
            case 2041757: {
                if (var9_13.equals("BLOB")) {
                    tmp = 1;
                }
                break;
            }
            case 1746995876: {
                if (var9_13.equals("VARCHAR_IGNORECASE")) {
                    tmp = 2;
                }
                break;
            }
            case -2034720975: {
                if (var9_13.equals("DECIMAL")) {
                    tmp = 3;
                }
                break;
            }
            case 2067286: {
                if (var9_13.equals("CHAR")) {
                    tmp = 1;
                }
                break;
            }
            case 2286824: {
                if (var9_13.equals("JSON")) {
                    tmp = 2;
                }
                break;
            }
            case 812904440: {
                if (var9_13.equals("TIME WITH TIME ZONE")) {
                    tmp = 4;
                }
                break;
            }
            case 1770063567: {
                if (var9_13.equals("DOUBLE PRECISION")) {
                    tmp = 5;
                }
                break;
            }
            case 1696795441: {
                if (var9_13.equals("BINARY VARYING")) {
                    tmp = 2;
                }
                break;
            }
            case 1810802684: {
                if (var9_13.equals("JAVA_OBJECT")) {
                    tmp = 2;
                }
                break;
            }
            case -1468976733: {
                if (var9_13.equals("BINARY LARGE OBJECT")) {
                    tmp = 1;
                }
                break;
            }
            case -1967338833: {
                if (var9_13.equals("TIMESTAMP WITH TIME ZONE")) {
                    tmp = 6;
                }
                break;
            }
            case -1453246218: {
                if (var9_13.equals("TIMESTAMP")) {
                    tmp = 7;
                }
                break;
            }
            case 55823113: {
                if (var9_13.equals("CHARACTER")) {
                    tmp = 8;
                }
                break;
            }
            case 2022338513: {
                if (var9_13.equals("DOUBLE")) {
                    tmp = 5;
                }
                break;
            }
            case -594415409: {
                if (var9_13.equals("TINYINT")) {
                    tmp = 5;
                }
                break;
            }
            case -1618932450: {
                if (var9_13.equals("INTEGER")) {
                    tmp = 5;
                }
                break;
            }
            case -1981034679: {
                if (var9_13.equals("NUMBER")) {
                    tmp = 3;
                }
                break;
            }
            case -1282431251: {
                if (var9_13.equals("NUMERIC")) {
                    tmp = 3;
                }
                break;
            }
            case 67554: {
                if (var9_13.equals("DEC")) {
                    tmp = 3;
                }
                break;
            }
            case 2407815: {
                if (var9_13.equals("NULL")) {
                    tmp = 5;
                }
                break;
            }
            case 2071548: {
                if (var9_13.equals("CLOB")) {
                    tmp = 1;
                }
                break;
            }
            case 1345372058: {
                if (var9_13.equals("DECFLOAT")) {
                    tmp = 9;
                }
                break;
            }
            case 2575053: {
                if (var9_13.equals("TIME")) {
                    tmp = 10;
                }
                break;
            }
            case 1959128815: {
                if (var9_13.equals("BIGINT")) {
                    tmp = 5;
                }
                break;
            }
            case 2012648347: {
                if (var9_13.equals("CHARACTER LARGE OBJECT")) {
                    tmp = 1;
                }
                break;
            }
            case 782694408: {
                if (var9_13.equals("BOOLEAN")) {
                    tmp = 5;
                }
                break;
            }
            case -1344909767: {
                if (var9_13.equals("CHARACTER VARYING")) {
                    tmp = 2;
                }
                break;
            }
            case 2090926: {
                if (var9_13.equals("DATE")) {
                    tmp = 5;
                }
                break;
            }
            case -1718637701: {
                if (var9_13.equals("DATETIME")) {
                    tmp = 7;
                }
                break;
            }
            case 176095624: {
                if (var9_13.equals("SMALLINT")) {
                    tmp = 5;
                }
                break;
            }
            case 2511262: {
                if (var9_13.equals("REAL")) {
                    tmp = 5;
                }
                break;
            }
            case 954596061: {
                if (var9_13.equals("VARCHAR")) {
                    tmp = 1;
                }
                break;
            }
        }
        switch (tmp) {
            case 3: {
                if (this.isV2()) {
                    actualScale = this.maskDefaultScale(scale, 0);
                    actualPrecision = actualScale != 0 ? precision : this.maskDefaultPrecision(precision, 100000);
                    break;
                }
                actualScale = this.maskDefaultScale(scale, 32767);
                actualPrecision = actualScale != 0 ? precision : this.maskDefaultPrecision(precision, 65535);
                break;
            }
            case 9: {
                actualPrecision = this.maskDefaultPrecision(precision, 100000);
                break;
            }
            case 10: {
                actualPrecision = this.maskDefaultPrecision(this.isV2() != false ? precision : scale, 0);
                break;
            }
            case 7: {
                actualPrecision = this.maskDefaultPrecision(this.isV2() != false ? precision : scale, timestampDefaultPrecision);
                break;
            }
            case 6: {
                actualPrecision = this.maskDefaultPrecision(this.isV2() != false ? precision : scale, timestampDefaultPrecision);
                actualTypeName = "TIMESTAMP";
                suffix = "WITH TIME ZONE";
                break;
            }
            case 4: {
                actualPrecision = this.maskDefaultPrecision(this.isV2() != false ? precision : scale, 0);
                actualTypeName = "TIME";
                suffix = "WITH TIME ZONE";
                break;
            }
            case 5: {
                actualPrecision = -1;
                break;
            }
            case 2: {
                actualPrecision = this.maskDefaultPrecision(precision, this.getDefaultVarDataMaxLength());
                break;
            }
            case 8: {
                actualPrecision = this.maskDefaultPrecision(precision, 1);
                break;
            }
            case 1: {
                actualPrecision = this.maskDefaultPrecision(precision, 0x7FFFFFFF);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                actualPrecision = this.maskDefaultPrecision(precision, 0);
            }
        }
        v2 = DataTypeFactory.of(null, actualTypeName, actualPrecision, actualScale, null, suffix, false, false);
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"of(...)");
        dataType = v2;
        return this.typeSystem.createDasType(dataType);
    }

    private final boolean isV2() {
        int[] nArray = new int[]{2};
        return this.getServerVersion().isOrGreater(nArray);
    }

    private final boolean isNewSchema() {
        Object object;
        return this.isV2() && !Intrinsics.areEqual((object = this.getDbConnection()) != null && (object = object.getConnectionPoint()) != null && (object = object.getConnectionProperties()) != null ? ((Properties)object).getProperty("OLD_INFORMATION_SCHEMA") : null, (Object)"true");
    }

    private final int getDefaultVarDataMaxLength() {
        int[] nArray = new int[]{2, 2};
        return this.getServerVersion().isOrGreater(nArray) ? 1000000000 : 0x100000;
    }

    public static final /* synthetic */ int access$maskDefaultPrecision(H2Introspector $this, int $receiver, int n) {
        return $this.maskDefaultPrecision($receiver, n);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "createIntrospector", "Lcom/intellij/database/dialects/h2/introspector/H2Introspector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.h2"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{1, 4, 196};
            return version.isOrGreater(nArray);
        }

        @Override
        @NotNull
        public H2Introspector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new H2Introspector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.h2"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$H2DatabaseBaseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/h2/model/H2Database;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/h2/model/H2Root;", "Lcom/intellij/database/dialects/h2/model/H2Schema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/h2/introspector/H2Introspector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/h2/model/H2Database;)V", "retrieveSchemas", "", "retrieveAuxiliaryObjects", "retrieveUsers", "db", "retrieveRoles", "retrieveCollations", "intellij.database.dialects.h2"})
    @SourceDebugExtension(value={"SMAP\nH2Introspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H2Introspector.kt\ncom/intellij/database/dialects/h2/introspector/H2Introspector$H2DatabaseBaseDatabaseRetriever\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ModelFun.kt\ncom/intellij/database/model/ModelFun\n*L\n1#1,1022:1\n178#2,5:1023\n183#2,3:1047\n178#2,5:1050\n183#2,3:1074\n178#2,5:1077\n183#2,3:1102\n503#3:1028\n484#3,18:1029\n503#3:1055\n484#3,18:1056\n503#3:1082\n484#3,2:1083\n487#3,15:1087\n1863#4,2:1085\n1863#4:1107\n1864#4:1110\n434#5,2:1105\n436#5,2:1108\n438#5,3:1111\n*S KotlinDebug\n*F\n+ 1 H2Introspector.kt\ncom/intellij/database/dialects/h2/introspector/H2Introspector$H2DatabaseBaseDatabaseRetriever\n*L\n97#1:1023,5\n97#1:1047,3\n111#1:1050,5\n111#1:1074,3\n124#1:1077,5\n124#1:1102,3\n98#1:1028\n98#1:1029,18\n112#1:1055\n112#1:1056,18\n125#1:1082\n125#1:1083,2\n125#1:1087,15\n126#1:1085,2\n77#1:1107\n77#1:1110\n77#1:1105,2\n77#1:1108,2\n77#1:1111,3\n*E\n"})
    private final class H2DatabaseBaseDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<H2Database> {
        public H2DatabaseBaseDatabaseRetriever(@NotNull DBTransaction transaction, H2Database database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)H2Introspector.this, transaction, (BasicModMateDatabase)database);
        }

        @Override
        public void retrieveSchemas() {
            super.retrieveSchemas();
            List<H2IntroQueries.SchemaInfo> schemaInfos = H2IntroQueries.INSTANCE.retrieveSchemas(this.getTransaction(), H2Introspector.this.isNewSchema());
            this.inDatabase(arg_0 -> H2DatabaseBaseDatabaseRetriever.retrieveSchemas$lambda$2(schemaInfos, arg_0));
        }

        @Override
        public void retrieveAuxiliaryObjects() {
            super.retrieveAuxiliaryObjects();
            this.inDatabase(arg_0 -> H2DatabaseBaseDatabaseRetriever.retrieveAuxiliaryObjects$lambda$3(this, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveUsers(H2Database db) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.USER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"USER");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = db.getUsers();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily users = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processUsers(this.getTransaction(), h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.UserInfo, Unit>)((Function1)arg_0 -> H2DatabaseBaseDatabaseRetriever.retrieveUsers$lambda$7$lambda$6$lambda$5(users, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoles(H2Database db) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.ROLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROLE");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = db.getRoles();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily roles = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processRoles(this.getTransaction(), h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.RoleInfo, Unit>)((Function1)arg_0 -> H2DatabaseBaseDatabaseRetriever.retrieveRoles$lambda$11$lambda$10$lambda$9(roles, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveCollations(H2Database db) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.COLLATION;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLLATION");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = db.getCollations();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily collations = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                Iterable $this$forEach$iv = H2IntroQueries.INSTANCE.retrieveCollations(this.getTransaction(), h2Introspector.isNewSchema());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    collations.createOrGet(it);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl4 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveSchemas$lambda$2(List $schemaInfos, H2Database db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            NamingFamily namingFamily = db.getSchemas();
            Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
            NamingFamily $this$applySchemasImpl$iv = namingFamily;
            boolean $i$f$applySchemasImpl = false;
            $this$applySchemasImpl$iv.markChildrenAsSyncPending();
            Iterable $this$forEach$iv$iv = $schemaInfos;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                void info2;
                Object element$iv$iv;
                Object sc$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                H2IntroQueries.SchemaInfo schemaInfo = (H2IntroQueries.SchemaInfo)sc$iv;
                NamingFamily $this$retrieveSchemas_u24lambda_u242_u24lambda_u241 = $this$applySchemasImpl$iv;
                boolean bl2 = false;
                Object e = db.getSchemas().createOrGet(info2.schema_name);
                H2Schema $this$retrieveSchemas_u24lambda_u242_u24lambda_u241_u24lambda_u240 = (H2Schema)e;
                boolean bl3 = false;
                $this$retrieveSchemas_u24lambda_u242_u24lambda_u241_u24lambda_u240.setComment(info2.remarks);
                $this$retrieveSchemas_u24lambda_u242_u24lambda_u241_u24lambda_u240.setCurrent(info2.is_default);
            }
            $this$applySchemasImpl$iv.removeSyncPendingChildren();
            $this$applySchemasImpl$iv.sort();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveAuxiliaryObjects$lambda$3(H2DatabaseBaseDatabaseRetriever this$0, H2Database db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            this$0.retrieveUsers(db);
            this$0.retrieveRoles(db);
            this$0.retrieveCollations(db);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveUsers$lambda$7$lambda$6$lambda$5(ModNamingFamily $users, H2IntroQueries.UserInfo info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            Object e = $users.createOrGet(info2.name);
            H2User $this$retrieveUsers_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244 = (H2User)e;
            boolean bl = false;
            $this$retrieveUsers_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244.setAdmin(info2.is_admin);
            $this$retrieveUsers_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244.setComment(info2.remarks);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoles$lambda$11$lambda$10$lambda$9(ModNamingFamily $roles, H2IntroQueries.RoleInfo info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            Object e = $roles.createOrGet(info2.name);
            H2Role $this$retrieveRoles_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = (H2Role)e;
            boolean bl = false;
            $this$retrieveRoles_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248.setComment(info2.remarks);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\f\u0010\u001a\u001a\u00020\u001b*\u00020\rH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH\u0002JC\u0010&\u001a\n (*\u0004\u0018\u0001H'H'\"\b\b\u0000\u0010'*\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H'0+2\u0006\u0010,\u001a\u00020\r2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0\u000eH\u0002\u00a2\u0006\u0002\u0010.J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\u000e2\u0006\u0010%\u001a\u00020\rH\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\rH\u0002J\f\u00103\u001a\u000204*\u000205H\u0002J\u0010\u00106\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J \u00107\u001a\u00020\u00192\b\u00108\u001a\u0004\u0018\u0001092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;H\u0002J\u0010\u0010=\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010>\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\"\u0010?\u001a\u00020\u00192\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\b\b\u0002\u0010D\u001a\u00020\u0016H\u0002J\f\u0010E\u001a\u000204*\u00020CH\u0002J\u001a\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020\u00162\u0006\u0010I\u001a\u000204H\u0002J\u001a\u0010J\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020\u00162\u0006\u0010I\u001a\u000204H\u0002J\u0014\u0010N\u001a\u00020O*\u0002042\u0006\u0010P\u001a\u00020\u0016H\u0002J\u0014\u0010S\u001a\u00020O*\u0002042\u0006\u0010P\u001a\u00020\u0016H\u0002J\u0010\u0010T\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010U\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u000e\u0010V\u001a\u0004\u0018\u00010\r*\u00020WH\u0002J\u000e\u0010X\u001a\u0004\u0018\u00010\r*\u00020WH\u0002J\u0010\u0010Y\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010Z\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010[\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\\\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010]\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0002H\u0002R6\u0010\u000b\u001a*\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\fj\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0011`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010K\u001a\u00020G*\u0002048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010MR\u0018\u0010Q\u001a\u00020G*\u0002048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010M\u00a8\u0006^"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$H2SchemaAbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/h2/model/H2Schema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/h2/model/H2Root;", "Lcom/intellij/database/dialects/h2/model/H2Database;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/h2/introspector/H2Introspector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/h2/model/H2Schema;)V", "enumValues", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "arrayElementTypes", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ArrayElementInfo;", "rowFields", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RowFieldInfo;", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "retrieveMainContent", "", "toCompositeText", "Lcom/intellij/database/script/SimpleCompositeText;", "retrieveEnumValues", "retrieveArrayTypes", "retrieveRowFields", "retrieveDomains", "retrieveDomainChecks", "retrieveTables", "retrieveColumns", "retrieveConstraints", "removeParens", "s", "renewConstraint", "C", "kotlin.jvm.PlatformType", "Lcom/intellij/database/dialects/h2/model/H2Constraint;", "family", "Lcom/intellij/database/model/families/ModNamingFamily;", "constraintName", "colNames", "(Lcom/intellij/database/model/families/ModNamingFamily;Ljava/lang/String;Ljava/util/List;)Lcom/intellij/database/dialects/h2/model/H2Constraint;", "parseColumnList", "getCascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "code", "getDasType", "Lcom/intellij/database/types/DasType;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TypedObjectInfo;", "retrieveIndexes", "applyIndexColumns", "index", "Lcom/intellij/database/dialects/h2/model/H2Index;", "columns", "", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$IndexColumnInfo;", "retrieveTriggers", "retrieveSequences", "processSequenceLike", "sequence", "Lcom/intellij/database/dialects/h2/model/H2Sequence;", "info", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SequenceLikeInfo;", "isIdentity", "dasType", "sequenceUnlimitedMinimumDefault", "Ljava/math/BigInteger;", "isAsc", "type", "sequenceUnlimitedMaximumDefault", "lowerBound", "getLowerBound", "(Lcom/intellij/database/types/DasType;)Ljava/math/BigInteger;", "decimalLowerBound", "", "exclusive", "upperBound", "getUpperBound", "decimalUpperBound", "retrieveRoutines", "retrieveRoutinesV2", "javaMethodName", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineInfoV2;", "javaClassName", "retrieveConstants", "retrieveSynonyms", "retrieveSourcesV2", "retrieveViewSources", "retrieveTriggerSources", "intellij.database.dialects.h2"})
    @SourceDebugExtension(value={"SMAP\nH2Introspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H2Introspector.kt\ncom/intellij/database/dialects/h2/introspector/H2Introspector$H2SchemaAbstractSchemaRetriever\n+ 2 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/NameCache\n*L\n1#1,1022:1\n503#2:1023\n484#2,18:1024\n503#2:1042\n484#2,18:1043\n503#2:1061\n484#2,18:1062\n503#2:1085\n484#2,18:1086\n503#2:1125\n484#2,18:1126\n503#2:1158\n484#2,18:1159\n503#2:1200\n484#2,18:1201\n503#2:1245\n484#2,18:1246\n503#2:1291\n484#2,18:1292\n503#2:1344\n484#2,18:1345\n503#2:1374\n484#2,18:1375\n503#2:1407\n484#2,18:1408\n503#2:1449\n484#2,18:1450\n503#2:1482\n484#2,2:1483\n487#2,15:1489\n503#2:1527\n484#2,2:1528\n487#2,15:1532\n503#2:1558\n484#2,18:1559\n503#2:1585\n484#2,18:1586\n178#3,5:1080\n183#3,3:1104\n303#3,4:1111\n307#3:1119\n198#3,5:1120\n204#3,5:1144\n308#3:1149\n195#3,8:1150\n204#3,5:1177\n303#3,4:1186\n307#3:1194\n198#3,5:1195\n204#3,5:1219\n308#3:1224\n303#3,4:1231\n307#3:1239\n198#3,5:1240\n204#3,5:1264\n308#3:1269\n303#3,4:1277\n307#3:1285\n198#3,5:1286\n204#3,5:1310\n308#3:1315\n303#3,4:1330\n307#3:1338\n198#3,5:1339\n204#3,5:1363\n308#3:1368\n178#3,5:1369\n183#3,3:1393\n195#3,8:1399\n204#3,5:1426\n303#3,4:1435\n307#3:1443\n198#3,5:1444\n204#3,5:1468\n308#3:1473\n195#3,8:1474\n204#3,5:1504\n303#3,4:1513\n307#3:1521\n198#3,5:1522\n204#3,5:1547\n308#3:1552\n178#3,5:1553\n183#3,3:1577\n178#3,5:1580\n183#3,3:1604\n1557#4:1107\n1628#4,3:1108\n1557#4:1182\n1628#4,3:1183\n1368#4:1225\n1454#4,5:1226\n1872#4,3:1270\n1557#4:1273\n1628#4,3:1274\n1557#4:1316\n1628#4,3:1317\n1619#4:1320\n1863#4:1321\n1864#4:1324\n1620#4:1325\n1557#4:1326\n1628#4,3:1327\n1797#4,3:1396\n1557#4:1431\n1628#4,3:1432\n1863#4,2:1485\n1863#4,2:1487\n1557#4:1509\n1628#4,3:1510\n1863#4,2:1530\n295#4,2:1619\n37#5:1115\n36#5,3:1116\n37#5:1190\n36#5,3:1191\n37#5:1235\n36#5,3:1236\n37#5:1281\n36#5,3:1282\n37#5:1334\n36#5,3:1335\n37#5:1439\n36#5,3:1440\n37#5:1517\n36#5,3:1518\n1#6:1322\n1#6:1323\n409#7,6:1607\n409#7,6:1613\n409#7,6:1621\n409#7,6:1627\n409#7,6:1633\n409#7,6:1639\n409#7,6:1645\n*S KotlinDebug\n*F\n+ 1 H2Introspector.kt\ncom/intellij/database/dialects/h2/introspector/H2Introspector$H2SchemaAbstractSchemaRetriever\n*L\n184#1:1023\n184#1:1024,18\n193#1:1042\n193#1:1043,18\n202#1:1061\n202#1:1062,18\n212#1:1085\n212#1:1086,18\n229#1:1125\n229#1:1126,18\n245#1:1158\n245#1:1159,18\n265#1:1200\n265#1:1201,18\n322#1:1245\n322#1:1246,18\n529#1:1291\n529#1:1292,18\n570#1:1344\n570#1:1345,18\n588#1:1374\n588#1:1375,18\n685#1:1407\n685#1:1408,18\n717#1:1449\n717#1:1450,18\n737#1:1482\n737#1:1483,2\n737#1:1489,15\n773#1:1527\n773#1:1528,2\n773#1:1532,15\n802#1:1558\n802#1:1559,18\n820#1:1585\n820#1:1586,18\n211#1:1080,5\n211#1:1104,3\n228#1:1111,4\n228#1:1119\n228#1:1120,5\n228#1:1144,5\n228#1:1149\n244#1:1150,8\n244#1:1177,5\n264#1:1186,4\n264#1:1194\n264#1:1195,5\n264#1:1219,5\n264#1:1224\n321#1:1231,4\n321#1:1239\n321#1:1240,5\n321#1:1264,5\n321#1:1269\n528#1:1277,4\n528#1:1285\n528#1:1286,5\n528#1:1310,5\n528#1:1315\n569#1:1330,4\n569#1:1338\n569#1:1339,5\n569#1:1363,5\n569#1:1368\n587#1:1369,5\n587#1:1393,3\n684#1:1399,8\n684#1:1426,5\n716#1:1435,4\n716#1:1443\n716#1:1444,5\n716#1:1468,5\n716#1:1473\n736#1:1474,8\n736#1:1504,5\n772#1:1513,4\n772#1:1521\n772#1:1522,5\n772#1:1547,5\n772#1:1552\n801#1:1553,5\n801#1:1577,3\n819#1:1580,5\n819#1:1604,3\n228#1:1107\n228#1:1108,3\n264#1:1182\n264#1:1183,3\n320#1:1225\n320#1:1226,5\n512#1:1270,3\n528#1:1273\n528#1:1274,3\n560#1:1316\n560#1:1317,3\n561#1:1320\n561#1:1321\n561#1:1324\n561#1:1325\n569#1:1326\n569#1:1327,3\n671#1:1396,3\n716#1:1431\n716#1:1432,3\n738#1:1485,2\n739#1:1487,2\n772#1:1509\n772#1:1510,3\n782#1:1530,2\n294#1:1619,2\n228#1:1115\n228#1:1116,3\n264#1:1190\n264#1:1191,3\n321#1:1235\n321#1:1236,3\n528#1:1281\n528#1:1282,3\n569#1:1334\n569#1:1335,3\n716#1:1439\n716#1:1440,3\n772#1:1517\n772#1:1518,3\n561#1:1323\n232#1:1607,6\n268#1:1613,6\n326#1:1621,6\n532#1:1627,6\n542#1:1633,6\n547#1:1639,6\n572#1:1645,6\n*E\n"})
    private final class H2SchemaAbstractSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<H2Schema> {
        @NotNull
        private final HashMap<String, List<String>> enumValues;
        @NotNull
        private final HashMap<String, H2IntroQueries.ArrayElementInfo> arrayElementTypes;
        @NotNull
        private final MultiMap<String, H2IntroQueries.RowFieldInfo> rowFields;

        public H2SchemaAbstractSchemaRetriever(@NotNull DBTransaction transaction, H2Schema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseNativeIntrospector)H2Introspector.this, transaction, (BasicModSchema)schema);
            this.enumValues = new HashMap();
            this.arrayElementTypes = new HashMap();
            this.rowFields = new MultiMap();
        }

        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull H2Schema schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return true;
        }

        @Override
        protected void retrieveMainContent() {
            this.inSchema(arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveMainContent$lambda$1(H2Introspector.this, this, arg_0));
        }

        private final SimpleCompositeText toCompositeText(String $this$toCompositeText) {
            return BaseIntrospectionFunctions.toCompositeText(((Object)StringsKt.trim((CharSequence)$this$toCompositeText)).toString(), CompositeText.Kind.DECOMPILED_TEXT);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveEnumValues(H2Schema schema) {
            H2Introspector.this.reportRetrieving("enum values", "introspection.retrieve.enums");
            BaseNativeIntrospector this_$iv = H2Introspector.this;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                H2IntroQueries.INSTANCE.processEnumValues(this.getTransaction(), schema, (Function1<? super H2IntroQueries.EnumValueInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveEnumValues$lambda$3$lambda$2(this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveArrayTypes(H2Schema schema) {
            void this_$iv;
            H2Introspector.this.reportRetrieving("array types", "introspection.retrieve.array.types");
            BaseNativeIntrospector baseNativeIntrospector = H2Introspector.this;
            H2Introspector h2Introspector = H2Introspector.this;
            boolean $i$f$continueOnDbError = false;
            void var5_5 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                H2IntroQueries.INSTANCE.processArrayElements(this.getTransaction(), schema, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.ArrayElementInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveArrayTypes$lambda$5$lambda$4(this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRowFields(H2Schema schema) {
            void this_$iv;
            H2Introspector.this.reportRetrieving("row fields", "introspection.retrieve.row.fields");
            BaseNativeIntrospector baseNativeIntrospector = H2Introspector.this;
            H2Introspector h2Introspector = H2Introspector.this;
            boolean $i$f$continueOnDbError = false;
            void var5_5 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                H2IntroQueries.INSTANCE.processRowFields(this.getTransaction(), schema, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.RowFieldInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveRowFields$lambda$7$lambda$6(this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDomains(H2Schema schema) {
            void $this$modifyAndCleanup_u24default$iv;
            H2Introspector.this.reportRetrieving("domains", "introspection.retrieve.domains");
            ModFamily modFamily = schema.getDomains();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily domains = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processDomains(this.getTransaction(), schema, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.DomainInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveDomains$lambda$11$lambda$10$lambda$9(domains, this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDomainChecks(H2Schema schema) {
            void families$iv;
            void $this$mapTo$iv$iv;
            H2Introspector.this.reportRetrieving("domain checks", "introspection.retrieve.domain.checks");
            ModNamingFamily<? extends H2Domain> modNamingFamily = schema.getDomains();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getDomains(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                H2Domain h2Domain = (H2Domain)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getChecks());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                NameCache domainCache = new NameCache();
                H2IntroQueries.INSTANCE.processDomainChecks(this.getTransaction(), schema, (Function1<? super H2IntroQueries.DomainCheckInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveDomainChecks$lambda$17$lambda$16$lambda$15(domainCache, schema, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTables(H2Schema schema) {
            void families$iv;
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily[] modFamilyArray = new ModFamily[]{schema.getTables(), schema.getViews()};
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processTables(this.getTransaction(), schema, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.TableInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveTables$lambda$21$lambda$20$lambda$19(schema, this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (void f$iv : families$iv) {
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumns(H2Schema schema) {
            void families$iv;
            H2View it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            H2Introspector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends H2Table> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                H2Table h2Table = (H2Table)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getColumns());
            }
            Collection collection2 = (List)destination$iv$iv;
            ModNamingFamily<? extends H2View> modNamingFamily2 = schema.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getViews(...)");
            $this$map$iv = modNamingFamily2;
            collection = collection2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (H2View)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(it.getColumns());
            }
            $this$map$iv = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
            object = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                NameCache tableCache = new NameCache();
                H2IntroQueries.INSTANCE.processColumns(this.getTransaction(), schema, ((H2Introspector)object).isNewSchema(), (Function1<? super H2IntroQueries.ColumnInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveColumns$lambda$30$lambda$29$lambda$28(tableCache, schema, this, (H2Introspector)object, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveConstraints(H2Schema schema) {
            void $this$flatMapTo$iv$iv;
            H2Introspector.this.reportRetrieving("constraints", "introspection.retrieve.constraints");
            ModNamingFamily<? extends H2Table> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$flatMap$iv = modNamingFamily;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                H2Table t = (H2Table)element$iv$iv;
                boolean bl = false;
                Object[] objectArray = new ModNamingFamily[]{t.getKeys(), t.getForeignKeys(), t.getChecks()};
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List involvingFamilies = (List)destination$iv$iv;
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Collection $this$toTypedArray$iv$iv = involvingFamilies;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                NameCache tableCache = new NameCache();
                HashMap constraintMap = new HashMap();
                H2IntroQueries.INSTANCE.processConstraints(this.getTransaction(), schema, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.ConstraintInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveConstraints$lambda$45$lambda$44$lambda$37(tableCache, this, h2Introspector, constraintMap, schema, arg_0)));
                H2IntroQueries.INSTANCE.processForeignKeys(this.getTransaction(), schema, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.ForeignKeyInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveConstraints$lambda$45$lambda$44$lambda$41(h2Introspector, constraintMap, this, arg_0)));
                if (h2Introspector.isNewSchema()) {
                    H2IntroQueries.INSTANCE.processCheckConstraints(this.getTransaction(), schema, (Function1<? super H2IntroQueries.CheckInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveConstraints$lambda$45$lambda$44$lambda$42(constraintMap, arg_0)));
                    MultiMap keyColumnNames = new MultiMap();
                    H2IntroQueries.INSTANCE.processKeyColumnsV2(this.getTransaction(), schema, (Function1<? super H2IntroQueries.ForeignKeyColumnInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveConstraints$lambda$45$lambda$44$lambda$43(constraintMap, keyColumnNames, arg_0)));
                    for (Map.Entry entry : keyColumnNames.entrySet()) {
                        Intrinsics.checkNotNull((Object)entry);
                        H2Constraint key2 = (H2Constraint)entry.getKey();
                        Collection names = (Collection)entry.getValue();
                        Intrinsics.checkNotNull((Object)names);
                        key2.setColNames(CollectionsKt.toList((Iterable)names));
                    }
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final String removeParens(String s) {
            String string;
            if (StringsKt.startsWith$default((CharSequence)s, (char)'(', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)s, (char)')', (boolean)false, (int)2, null)) {
                String string2 = s.substring(1, StringsKt.getLastIndex((CharSequence)s));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = s;
            }
            return string;
        }

        private final <C extends H2Constraint> C renewConstraint(ModNamingFamily<C> family, String constraintName, List<String> colNames) {
            H2Constraint h2Constraint;
            if (((CharSequence)constraintName).length() > 0) {
                h2Constraint = (H2Constraint)family.createOrGet(constraintName);
            } else {
                H2Constraint h2Constraint2 = (H2Constraint)family.find(arg_0 -> H2SchemaAbstractSchemaRetriever.renewConstraint$lambda$47(arg_0 -> H2SchemaAbstractSchemaRetriever.renewConstraint$lambda$46(colNames, arg_0), arg_0));
                if (h2Constraint2 != null) {
                    H2Constraint h2Constraint3;
                    H2Constraint $this$renewConstraint_u24lambda_u2448 = h2Constraint3 = h2Constraint2;
                    boolean bl = false;
                    ((BasicModMixinElement)$this$renewConstraint_u24lambda_u2448).setSyncPending(false);
                    h2Constraint = h2Constraint3;
                } else {
                    h2Constraint = (H2Constraint)family.createNewOne();
                }
            }
            return (C)h2Constraint;
        }

        private final List<String> parseColumnList(String s) {
            SmartList columnNames = new SmartList();
            H2Lexer lexer = new H2Lexer();
            lexer.start(s);
            IElementType tokenType = lexer.getTokenType();
            while (tokenType != null) {
                if (Intrinsics.areEqual((Object)tokenType, (Object)SqlTokens.SQL_IDENT) || tokenType instanceof SqlIdentifierKeywordTokenType || tokenType instanceof SqlKeywordTokenType) {
                    ((Collection)columnNames).add(lexer.getTokenText());
                }
                lexer.advance();
                tokenType = lexer.getTokenType();
            }
            return (List)columnNames;
        }

        private final CascadeRule getCascadeRule(String code) {
            return switch (code) {
                case "0", "CASCADE" -> CascadeRule.cascade;
                case "1", "RESTRICT" -> CascadeRule.restrict;
                case "2", "SET NULL" -> CascadeRule.set_null;
                case "4", "SET DEFAULT" -> CascadeRule.set_default;
                default -> CascadeRule.no_action;
            };
        }

        /*
         * WARNING - void declaration
         */
        private final DasType getDasType(H2IntroQueries.TypedObjectInfo $this$getDasType) {
            int actualPrecision;
            block40: {
                if ($this$getDasType.getColumn_type() != null) {
                    String string = $this$getDasType.getColumn_type();
                    Intrinsics.checkNotNull((Object)string);
                    SqlTypeElement sqlTypeElement = SqlPsiElementFactory.createDataTypeFromText(string, H2Dialect.INSTANCE, H2Introspector.this.getProject(), null, false);
                    Intrinsics.checkNotNull((Object)sqlTypeElement, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlTypeElement");
                    SqlTypeElement fragment = sqlTypeElement;
                    DasType dasType = fragment.getDasType();
                    Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                    return dasType;
                }
                if ($this$getDasType.getDomain_name() != null) {
                    String string = $this$getDasType.getDomain_schema();
                    String string2 = $this$getDasType.getDomain_name();
                    Intrinsics.checkNotNull((Object)string2);
                    DataType dataType = DataTypeFactory.of(string, string2, -1, 0, null, null, false, true);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    DataType dataType2 = dataType;
                    return H2Introspector.this.typeSystem.createDasType(dataType2);
                }
                actualPrecision = $this$getDasType.getPrecision() <= Integer.MAX_VALUE ? (int)$this$getDasType.getPrecision() : Integer.MAX_VALUE;
                String string = $this$getDasType.getType_name();
                if (string == null) break block40;
                int n = -1;
                switch (string.hashCode()) {
                    case 1353045189: {
                        if (string.equals("INTERVAL")) {
                            n = 1;
                        }
                        break;
                    }
                    case 2133249: {
                        if (string.equals("ENUM")) {
                            n = 2;
                        }
                        break;
                    }
                    case 62552633: {
                        if (string.equals("ARRAY")) {
                            n = 3;
                        }
                        break;
                    }
                    case 81338: {
                        if (string.equals("ROW")) {
                            n = 4;
                        }
                        break;
                    }
                    case -1666320270: {
                        if (string.equals("GEOMETRY")) {
                            n = 5;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        Object object;
                        if ($this$getDasType.getInterval_type() == null) {
                            return DasTypeSystemBase.UNKNOWN;
                        }
                        String string3 = $this$getDasType.getInterval_type();
                        Intrinsics.checkNotNull((Object)string3);
                        char[] cArray = new char[]{' '};
                        List components = StringsKt.split$default((CharSequence)string3, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                        String string4 = (String)CollectionsKt.getOrNull((List)components, (int)0);
                        if (string4 == null || (object = H2Introspector.this.toIntervalKind(string4)) == null) {
                            return DasTypeSystemBase.UNKNOWN;
                        }
                        Interval primaryKind = object;
                        object = (String)CollectionsKt.getOrNull((List)components, (int)2);
                        Interval secondaryKind = object != null ? H2Introspector.this.toIntervalKind((String)object) : null;
                        return H2Introspector.this.getIntervalDasType(primaryKind, secondaryKind, $this$getDasType.getInterval_precision(), actualPrecision);
                    }
                    case 5: {
                        StringBuilder primaryKind;
                        if ($this$getDasType.getGeometry_type() == null && $this$getDasType.getGeometry_srid() == null) {
                            DasTypeSystemBase dasTypeSystemBase = H2Introspector.this.typeSystem;
                            DataType dataType = DataTypeFactory.of("GEOMETRY");
                            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                            return dasTypeSystemBase.createDasType(dataType);
                        }
                        StringBuilder $this$getDasType_u24lambda_u2449 = primaryKind = new StringBuilder();
                        boolean bl = false;
                        String string5 = $this$getDasType.getGeometry_type();
                        if (string5 == null) {
                            string5 = "GEOMETRY";
                        }
                        $this$getDasType_u24lambda_u2449.append(string5);
                        if ($this$getDasType.getGeometry_srid() != null) {
                            $this$getDasType_u24lambda_u2449.append(", ").append($this$getDasType.getGeometry_srid());
                        }
                        String arg = primaryKind.toString();
                        String string6 = $this$getDasType.getType_name();
                        Intrinsics.checkNotNull((Object)string6);
                        DataType dataType = DataTypeFactory.ofArgs(null, string6, arg, false);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"ofArgs(...)");
                        DataType dataType3 = dataType;
                        return H2Introspector.this.typeSystem.createDasType(dataType3);
                    }
                    case 2: {
                        if ($this$getDasType.getDtd_identifier() == null) {
                            return DasTypeSystemBase.UNKNOWN;
                        }
                        String string7 = $this$getDasType.getDtd_identifier();
                        Intrinsics.checkNotNull((Object)string7);
                        List<String> list = this.enumValues.get(string7);
                        if (list == null) {
                            return DasTypeSystemBase.UNKNOWN;
                        }
                        List<String> enumValues = list;
                        String string8 = $this$getDasType.getType_name();
                        Intrinsics.checkNotNull((Object)string8);
                        DataType dataType = DataTypeFactory.ofValues(null, null, string8, enumValues, false);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"ofValues(...)");
                        DataType dataType4 = dataType;
                        return H2Introspector.this.typeSystem.createDasType(dataType4);
                    }
                    case 3: {
                        StringBuilder bl;
                        if ($this$getDasType.getDtd_identifier() == null) {
                            DasType dasType;
                            if (H2Introspector.this.isV2()) {
                                dasType = DasTypeSystemBase.UNKNOWN;
                            } else {
                                DasTypeSystemBase dasTypeSystemBase = H2Introspector.this.typeSystem;
                                String string9 = $this$getDasType.getType_name();
                                Intrinsics.checkNotNull((Object)string9);
                                DataType dataType = DataTypeFactory.of(string9);
                                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                                dasType = dasTypeSystemBase.createDasType(dataType);
                            }
                            return dasType;
                        }
                        String string10 = $this$getDasType.getDtd_identifier();
                        Intrinsics.checkNotNull((Object)string10);
                        Object object = this.arrayElementTypes.get(string10);
                        if (object == null || (object = this.getDasType((H2IntroQueries.TypedObjectInfo)object)) == null) {
                            return DasTypeSystemBase.UNKNOWN;
                        }
                        Object elementType = object;
                        DataType dataType = elementType.toDataType();
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
                        DataType elementDataType = dataType;
                        StringBuilder $this$getDasType_u24lambda_u2450 = bl = new StringBuilder();
                        boolean bl2 = false;
                        String string11 = elementDataType.suffix;
                        if (string11 == null) {
                            string11 = "";
                        }
                        $this$getDasType_u24lambda_u2450.append(string11);
                        if ($this$getDasType_u24lambda_u2450.length() > 0) {
                            $this$getDasType_u24lambda_u2450.append(' ');
                        }
                        $this$getDasType_u24lambda_u2450.append("ARRAY");
                        if ($this$getDasType.getMaximum_cardinality() != null) {
                            Integer n2 = $this$getDasType.getMaximum_cardinality();
                            int n3 = 65536;
                            if (n2 == null || n2 != n3) {
                                $this$getDasType_u24lambda_u2450.append("[" + $this$getDasType.getMaximum_cardinality() + "]");
                            }
                        }
                        String suffix = bl.toString();
                        DataType dataType5 = DataTypeFactory.withSuffix(elementType.toDataType(), suffix);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType5, (String)"withSuffix(...)");
                        DataType dataType6 = dataType5;
                        return H2Introspector.this.typeSystem.createDasType(dataType6);
                    }
                    case 4: {
                        if ($this$getDasType.getDtd_identifier() == null) {
                            return DasTypeSystemBase.UNKNOWN;
                        }
                        DdlBuilder ddlBuilder = new DdlBuilder().withDialect(DbImplUtilCore.getDatabaseDialect(H2Introspector.this.dbms)).quoteIdentifiers(false);
                        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"quoteIdentifiers(...)");
                        DdlBuilder argBuilder = ddlBuilder;
                        String string12 = $this$getDasType.getDtd_identifier();
                        Intrinsics.checkNotNull((Object)string12);
                        Collection collection = this.rowFields.get((Object)string12);
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                        Iterable $this$forEachIndexed$iv = collection;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$forEachIndexed$iv) {
                            void field;
                            int n4;
                            if ((n4 = index$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            H2IntroQueries.RowFieldInfo rowFieldInfo = (H2IntroQueries.RowFieldInfo)item$iv;
                            int i2 = n4;
                            boolean bl = false;
                            if (i2 > 0) {
                                argBuilder.plain(", ");
                            }
                            argBuilder.identifier(field.field_name);
                            argBuilder.plain(" ");
                            Intrinsics.checkNotNull((Object)field);
                            argBuilder.type(this.getDasType((H2IntroQueries.TypedObjectInfo)field).toDataType());
                        }
                        String string13 = $this$getDasType.getType_name();
                        Intrinsics.checkNotNull((Object)string13);
                        DataType dataType = DataTypeFactory.ofArgs(null, string13, argBuilder.getStatement(), false);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"ofArgs(...)");
                        DataType dataType7 = dataType;
                        return H2Introspector.this.typeSystem.createDasType(dataType7);
                    }
                }
            }
            return H2Introspector.this.getDasType($this$getDasType.getType_name(), actualPrecision, $this$getDasType.getScale());
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveIndexes(H2Schema schema) {
            void families$iv;
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            H2Introspector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends H2Table> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                H2Table h2Table = (H2Table)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getIndices());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                NameCache tableCache = new NameCache();
                H2IntroQueries.INSTANCE.processIndexes(this.getTransaction(), schema, ((H2Introspector)object).isNewSchema(), (Function1<? super H2IntroQueries.IndexInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveIndexes$lambda$60$lambda$59$lambda$55(tableCache, schema, arg_0)));
                NameCache indexCache = new NameCache();
                ArrayList indexColumns = new ArrayList();
                H2IntroQueries.INSTANCE.processIndexColumns(this.getTransaction(), schema, ((H2Introspector)object).isNewSchema(), (Function1<? super H2IntroQueries.IndexColumnInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveIndexes$lambda$60$lambda$59$lambda$58(tableCache, indexCache, indexColumns, this, schema, arg_0)));
                this.applyIndexColumns((H2Index)indexCache.getV(), indexColumns);
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void applyIndexColumns(H2Index index, List<H2IntroQueries.IndexColumnInfo> columns) {
            H2Index h2Index = index;
            if (h2Index != null) {
                void destination$iv;
                void $this$mapNotNullTo$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                H2Index h2Index2;
                H2Index $this$applyIndexColumns_u24lambda_u2464 = h2Index2 = h2Index;
                boolean bl = false;
                Iterable iterable = columns;
                H2Index h2Index3 = $this$applyIndexColumns_u24lambda_u2464;
                boolean $i$f$map22 = false;
                void var9_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    H2IntroQueries.IndexColumnInfo indexColumnInfo = (H2IntroQueries.IndexColumnInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.column_name);
                }
                h2Index3.setColNames((List)destination$iv$iv);
                $this$map$iv = columns;
                Collection $i$f$map22 = new LinkedHashSet();
                h2Index3 = $this$applyIndexColumns_u24lambda_u2464;
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv;
                    String string;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator.next();
                    boolean bl3 = false;
                    H2IntroQueries.IndexColumnInfo c2 = (H2IntroQueries.IndexColumnInfo)element$iv;
                    boolean bl4 = false;
                    String it = string = c2.column_name;
                    boolean bl5 = false;
                    if ((c2.is_desc ? string : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl6 = false;
                    destination$iv.add(it$iv);
                }
                h2Index3.setReverseColNames((Set)destination$iv);
            }
            columns.clear();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTriggers(H2Schema schema) {
            void families$iv;
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.TRIGGER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TRIGGER");
            H2Introspector.this.reportRetrieving(objectKind);
            NameCache tableCache = new NameCache();
            ModNamingFamily<? extends H2Table> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                H2Table h2Table = (H2Table)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getTriggers());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processTriggers(this.getTransaction(), schema, ((H2Introspector)object).isNewSchema(), (Function1<? super H2IntroQueries.TriggerInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveTriggers$lambda$70$lambda$69$lambda$68(tableCache, schema, this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveSequences(H2Schema schema) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.SEQUENCE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SEQUENCE");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = schema.getSequences();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily sequences = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                Ref.IntRef order = new Ref.IntRef();
                H2IntroQueries.INSTANCE.processSequences(this.getTransaction(), schema, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.SequenceInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveSequences$lambda$73$lambda$72$lambda$71(sequences, this, order, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        private final void processSequenceLike(H2Sequence sequence, H2IntroQueries.SequenceLikeInfo info2, boolean isIdentity) {
            SequenceIdentity sequenceIdentity;
            BigInteger bigInteger;
            BigInteger bigInteger2;
            BigInteger bigInteger3;
            BigInteger bigInteger4;
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            Long l = info2.getStart_value();
            if (l != null) {
                BigInteger bigInteger7 = BigInteger.valueOf(l);
                bigInteger6 = bigInteger7;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"valueOf(...)");
            } else {
                bigInteger6 = null;
            }
            BigInteger start2 = bigInteger6;
            Long l2 = info2.getLast_value();
            if (l2 != null) {
                BigInteger bigInteger8 = BigInteger.valueOf(l2);
                bigInteger5 = bigInteger8;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"valueOf(...)");
            } else {
                bigInteger5 = null;
            }
            BigInteger last = bigInteger5;
            Long l3 = info2.getNext_value();
            if (l3 != null) {
                BigInteger bigInteger9 = BigInteger.valueOf(l3);
                bigInteger4 = bigInteger9;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"valueOf(...)");
            } else {
                bigInteger4 = null;
            }
            BigInteger next = bigInteger4;
            Long l4 = info2.getMin_value();
            if (l4 != null) {
                BigInteger bigInteger10 = BigInteger.valueOf(l4);
                bigInteger3 = bigInteger10;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"valueOf(...)");
            } else {
                bigInteger3 = null;
            }
            BigInteger minimum = bigInteger3;
            Long l5 = info2.getMax_value();
            if (l5 != null) {
                BigInteger bigInteger11 = BigInteger.valueOf(l5);
                bigInteger2 = bigInteger11;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger11, (String)"valueOf(...)");
            } else {
                bigInteger2 = null;
            }
            BigInteger maximum = bigInteger2;
            Long l6 = info2.getIncrement();
            if (l6 != null) {
                BigInteger bigInteger12 = BigInteger.valueOf(l6);
                bigInteger = bigInteger12;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger12, (String)"valueOf(...)");
            } else {
                bigInteger = null;
            }
            BigInteger increment = bigInteger;
            boolean isAsc = BaseIntrospectionFunctions.isAscSequenceIncrement$default(increment, false, 1, null);
            H2Sequence h2Sequence = sequence;
            H2Introspector h2Introspector = H2Introspector.this;
            H2Sequence $this$processSequenceLike_u24lambda_u2474 = h2Sequence;
            boolean bl = false;
            $this$processSequenceLike_u24lambda_u2474.setStoredType(this.dasType(info2));
            $this$processSequenceLike_u24lambda_u2474.setStartValue(start2);
            if (!isIdentity) {
                sequenceIdentity = SequenceIdentity.UNKNOWN;
            } else {
                DasType dasType = $this$processSequenceLike_u24lambda_u2474.getStoredType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getStoredType(...)");
                BigInteger bigInteger13 = h2Introspector.isNewSchema() ? next : BaseIntrospectionFunctions.nextByLast(last, increment, start2);
                DasType dasType2 = $this$processSequenceLike_u24lambda_u2474.getStoredType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getStoredType(...)");
                sequenceIdentity = SequenceIdentity.of(BaseIntrospectionFunctions.nullize(minimum, this.sequenceUnlimitedMinimumDefault(isAsc, dasType)), bigInteger13, increment, BaseIntrospectionFunctions.nullize(maximum, this.sequenceUnlimitedMaximumDefault(isAsc, dasType2)));
            }
            $this$processSequenceLike_u24lambda_u2474.setSequenceIdentity(sequenceIdentity);
            $this$processSequenceLike_u24lambda_u2474.setCacheSize(info2.getCache());
            $this$processSequenceLike_u24lambda_u2474.setCycled(info2.is_cycle());
        }

        static /* synthetic */ void processSequenceLike$default(H2SchemaAbstractSchemaRetriever h2SchemaAbstractSchemaRetriever, H2Sequence h2Sequence, H2IntroQueries.SequenceLikeInfo sequenceLikeInfo, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            h2SchemaAbstractSchemaRetriever.processSequenceLike(h2Sequence, sequenceLikeInfo, bl);
        }

        /*
         * Unable to fully structure code
         */
        private final DasType dasType(H2IntroQueries.SequenceLikeInfo $this$dasType) {
            block17: {
                block16: {
                    if (!H2Introspector.access$isV2(H2Introspector.this)) {
                        v0 = H2Introspector.access$getTypeSystem$p(H2Introspector.this);
                        v1 = DataTypeFactory.of("BIGINT");
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"of(...)");
                        return v0.createDasType(v1);
                    }
                    size = -1;
                    typeName = null;
                    seq_type_name = $this$dasType.getSeq_type_name();
                    if (seq_type_name == null) break block16;
                    switch (seq_type_name.hashCode()) {
                        case -1282431251: {
                            if (seq_type_name.equals("NUMERIC")) break;
                            ** break;
                        }
                        case 176095624: {
                            if (!seq_type_name.equals("SMALLINT")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case 2511262: {
                            if (!seq_type_name.equals("REAL")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case 1959128815: {
                            if (!seq_type_name.equals("BIGINT")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case 1345372058: {
                            if (seq_type_name.equals("DECFLOAT")) break;
                            ** break;
                        }
                        case -594415409: {
                            if (!seq_type_name.equals("TINYINT")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case 1770063567: {
                            if (!seq_type_name.equals("DOUBLE PRECISION")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case -1618932450: {
                            if (!seq_type_name.equals("INTEGER")) ** break;
lbl39:
                            // 6 sources

                            typeName = seq_type_name;
                            break block17;
                        }
                    }
                    typeName = seq_type_name;
                    size = $this$dasType.getSeq_numeric_scale() == 0 ? H2Introspector.access$maskDefaultPrecision(H2Introspector.this, $this$dasType.getSeq_numeric_precision(), 19) : $this$dasType.getSeq_numeric_precision();
                    break block17;
                }
                typeName = "BIGINT";
            }
            v2 = DataTypeFactory.of(null, typeName, size, 0, null, null, false, false);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"of(...)");
            dataType = v2;
            return H2Introspector.access$getTypeSystem$p(H2Introspector.this).createDasType(dataType);
        }

        private final BigInteger sequenceUnlimitedMinimumDefault(boolean isAsc, DasType type) {
            return isAsc ? null : this.getLowerBound(type);
        }

        private final BigInteger sequenceUnlimitedMaximumDefault(boolean isAsc, DasType type) {
            return isAsc ? this.getUpperBound(type) : null;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final BigInteger getLowerBound(DasType $this$lowerBound) {
            BigInteger bigInteger;
            String string = StringUtil.toUpperCase((String)DasTypeUtilsKt.getTypeName($this$lowerBound));
            if (string != null) {
                int n = -1;
                switch (string.hashCode()) {
                    case -1282431251: {
                        if (!string.equals("NUMERIC")) break;
                        n = 1;
                        break;
                    }
                    case 2511262: {
                        if (!string.equals("REAL")) break;
                        n = 2;
                        break;
                    }
                    case -2034720975: {
                        if (!string.equals("DECIMAL")) break;
                        n = 1;
                        break;
                    }
                    case 1345372058: {
                        if (!string.equals("DECFLOAT")) break;
                        n = 3;
                        break;
                    }
                    case -594415409: {
                        if (!string.equals("TINYINT")) break;
                        n = 4;
                        break;
                    }
                    case 1770063567: {
                        if (!string.equals("DOUBLE PRECISION")) break;
                        n = 5;
                        break;
                    }
                }
                switch (n) {
                    case 4: {
                        BigInteger bigInteger2 = BigInteger.valueOf(-128);
                        bigInteger = bigInteger2;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 2: {
                        BigInteger bigInteger3 = BigInteger.valueOf(-16777216);
                        bigInteger = bigInteger3;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 5: {
                        BigInteger bigInteger4 = BigInteger.valueOf(-9007199254740992L);
                        bigInteger = bigInteger4;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 1: {
                        BigInteger bigInteger5 = BigInteger.valueOf(this.decimalLowerBound($this$lowerBound, true));
                        bigInteger = bigInteger5;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 3: {
                        BigInteger bigInteger6 = BigInteger.valueOf(this.decimalLowerBound($this$lowerBound, false));
                        bigInteger = bigInteger6;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"valueOf(...)");
                        return bigInteger;
                    }
                }
            }
            BigInteger bigInteger7 = DasTypeUtilsKt.getMinValue($this$lowerBound);
            bigInteger = bigInteger7;
            if (bigInteger7 != null) return bigInteger;
            BigInteger bigInteger8 = BigInteger.valueOf(Long.MIN_VALUE);
            bigInteger = bigInteger8;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"valueOf(...)");
            return bigInteger;
        }

        private final long decimalLowerBound(DasType $this$decimalLowerBound, boolean exclusive) {
            long upperBound = this.decimalUpperBound($this$decimalLowerBound, exclusive);
            return upperBound == Long.MAX_VALUE ? Long.MIN_VALUE : -upperBound;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final BigInteger getUpperBound(DasType $this$upperBound) {
            BigInteger bigInteger;
            String string = StringUtil.toUpperCase((String)DasTypeUtilsKt.getTypeName($this$upperBound));
            if (string != null) {
                int n = -1;
                switch (string.hashCode()) {
                    case -1282431251: {
                        if (!string.equals("NUMERIC")) break;
                        n = 1;
                        break;
                    }
                    case 2511262: {
                        if (!string.equals("REAL")) break;
                        n = 2;
                        break;
                    }
                    case -2034720975: {
                        if (!string.equals("DECIMAL")) break;
                        n = 1;
                        break;
                    }
                    case 1345372058: {
                        if (!string.equals("DECFLOAT")) break;
                        n = 3;
                        break;
                    }
                    case -594415409: {
                        if (!string.equals("TINYINT")) break;
                        n = 4;
                        break;
                    }
                    case 1770063567: {
                        if (!string.equals("DOUBLE PRECISION")) break;
                        n = 5;
                        break;
                    }
                }
                switch (n) {
                    case 4: {
                        BigInteger bigInteger2 = BigInteger.valueOf(127);
                        bigInteger = bigInteger2;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 2: {
                        BigInteger bigInteger3 = BigInteger.valueOf(0x1000000);
                        bigInteger = bigInteger3;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 5: {
                        BigInteger bigInteger4 = BigInteger.valueOf(0x20000000000000L);
                        bigInteger = bigInteger4;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 1: {
                        BigInteger bigInteger5 = BigInteger.valueOf(this.decimalUpperBound($this$upperBound, true));
                        bigInteger = bigInteger5;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 3: {
                        BigInteger bigInteger6 = BigInteger.valueOf(this.decimalUpperBound($this$upperBound, false));
                        bigInteger = bigInteger6;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"valueOf(...)");
                        return bigInteger;
                    }
                }
            }
            BigInteger bigInteger7 = DasTypeUtilsKt.getMaxValue($this$upperBound);
            bigInteger = bigInteger7;
            if (bigInteger7 != null) return bigInteger;
            BigInteger bigInteger8 = BigInteger.valueOf(Long.MAX_VALUE);
            bigInteger = bigInteger8;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"valueOf(...)");
            return bigInteger;
        }

        /*
         * WARNING - void declaration
         */
        private final long decimalUpperBound(DasType $this$decimalUpperBound, boolean exclusive) {
            long l;
            DataType dataType = $this$decimalUpperBound.toDataType();
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
            DataType dt = dataType;
            int p2 = dt.getPrecision() - dt.scale;
            boolean bl = 1 <= p2 ? p2 < 19 : false;
            if (bl) {
                void $this$fold$iv;
                Iterable iterable = (Iterable)new IntRange(1, p2);
                long initial$iv = 1L;
                boolean $i$f$fold = false;
                long accumulator$iv = initial$iv;
                Iterator iterator = $this$fold$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv = ((IntIterator)iterator).nextInt();
                    long res2 = accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = res2 * (long)10;
                }
                long result2 = accumulator$iv;
                if (exclusive) {
                    long l2 = result2;
                    result2 = l2 + -1L;
                }
                l = result2;
            } else {
                l = Long.MAX_VALUE;
            }
            return l;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutines(H2Schema schema) {
            void $this$mapTo$iv$iv;
            void families$iv;
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            H2Introspector.this.reportRetrieving(objectKind);
            HashMap aliasMap = new HashMap();
            ModNamingFamily<? extends H2Routine> modNamingFamily = schema.getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getRoutines(...)");
            ModNamingFamily<? extends H2Routine> routines = modNamingFamily;
            ModNamingFamily<? extends H2Aggregate> modNamingFamily2 = schema.getAggregates();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getAggregates(...)");
            ModNamingFamily<? extends H2Aggregate> aggregates = modNamingFamily2;
            ModFamily[] modFamilyArray = new ModFamily[]{routines, aggregates};
            Object object = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl4 = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processRoutines(this.getTransaction(), schema, (Function1<? super H2IntroQueries.RoutineInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveRoutines$lambda$82$lambda$81$lambda$80(aggregates, routines, aliasMap, this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            int n = ((void)families$iv).length;
            for (int j = 0; j < n; ++j) {
                void f$iv;
                f$iv = families$iv[j];
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
            Iterable $this$map$iv = routines;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                H2Routine bl4 = (H2Routine)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(it.getArguments());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            removeUnaffected$iv = true;
            $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl6 = false;
            BaseNativeIntrospector this_$iv2 = (BaseNativeIntrospector)object;
            $i$f$continueOnDbError2 = false;
            BaseNativeIntrospector bl2 = this_$iv2;
            Object whatsDoing$iv$iv2 = null;
            boolean $i$f$continueOnDbError3 = false;
            try {
                boolean bl7 = false;
                H2IntroQueries.INSTANCE.processRoutineArguments(this.getTransaction(), schema, (Function1<? super H2IntroQueries.RoutineArgumentInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveRoutines$lambda$87$lambda$86$lambda$85(aliasMap, this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl8 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutinesV2(H2Schema schema) {
            void $this$mapTo$iv$iv;
            void families$iv;
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            H2Introspector.this.reportRetrieving(objectKind);
            HashMap routineMap = new HashMap();
            ModNamingFamily<? extends H2Routine> modNamingFamily = schema.getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getRoutines(...)");
            ModNamingFamily<? extends H2Routine> routines = modNamingFamily;
            ModNamingFamily<? extends H2Aggregate> modNamingFamily2 = schema.getAggregates();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getAggregates(...)");
            ModNamingFamily<? extends H2Aggregate> aggregates = modNamingFamily2;
            ModFamily[] modFamilyArray = new ModFamily[]{routines, aggregates};
            Object object = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl6 = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                Map map2;
                H2LikeRoutine it;
                boolean bl2 = false;
                Iterable $this$forEach$iv = routines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (H2Routine)element$iv;
                    boolean bl3 = false;
                    map2 = routineMap;
                    String string = it.getSpecificName();
                    if (string == null) {
                        string = "";
                    }
                    map2.put(string, it);
                }
                $this$forEach$iv = aggregates;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (H2Aggregate)element$iv;
                    boolean bl4 = false;
                    map2 = routineMap;
                    String string = it.getSpecificName();
                    if (string == null) {
                        string = "";
                    }
                    map2.put(string, it);
                }
                H2IntroQueries.INSTANCE.processRoutinesV2(this.getTransaction(), schema, ((H2Introspector)object).isNewSchema(), (Function1<? super H2IntroQueries.RoutineInfoV2, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveRoutinesV2$lambda$95$lambda$94$lambda$93(aggregates, routines, routineMap, this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl5 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            int n = ((void)families$iv).length;
            for (int j = 0; j < n; ++j) {
                void f$iv;
                f$iv = families$iv[j];
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
            Iterable $this$map$iv = routines;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                H2Routine bl6 = (H2Routine)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl7 = false;
                collection.add(it.getArguments());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            removeUnaffected$iv = true;
            $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl8 = false;
            BaseNativeIntrospector this_$iv2 = (BaseNativeIntrospector)object;
            $i$f$continueOnDbError2 = false;
            BaseNativeIntrospector bl2 = this_$iv2;
            Object whatsDoing$iv$iv2 = null;
            boolean $i$f$continueOnDbError3 = false;
            try {
                boolean bl9 = false;
                H2IntroQueries.INSTANCE.processRoutineArgumentsV2(this.getTransaction(), schema, ((H2Introspector)object).isNewSchema(), (Function1<? super H2IntroQueries.RoutineArgumentInfoV2, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveRoutinesV2$lambda$101$lambda$100$lambda$98(routineMap, this, arg_0)));
                Iterable $this$forEach$iv = routines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    H2Routine it = (H2Routine)element$iv;
                    boolean bl10 = false;
                    BasicModArgument basicModArgument = (BasicModArgument)it.getReturnArgument();
                    if (basicModArgument == null) continue;
                    basicModArgument.resetSyncPending();
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl11 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final String javaMethodName(H2IntroQueries.RoutineInfoV2 $this$javaMethodName) {
            String string;
            if ($this$javaMethodName.external_name == null) {
                return null;
            }
            String string2 = $this$javaMethodName.external_name;
            Intrinsics.checkNotNull((Object)string2);
            int p2 = StringsKt.lastIndexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (p2 >= 0) {
                String string3;
                String string4 = $this$javaMethodName.external_name;
                Intrinsics.checkNotNull((Object)string4);
                String string5 = string4.substring(p2 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                String it = string3 = string5;
                boolean bl = false;
                string = !Intrinsics.areEqual((Object)it, (Object)"null") ? string3 : null;
            } else {
                string = null;
            }
            return string;
        }

        private final String javaClassName(H2IntroQueries.RoutineInfoV2 $this$javaClassName) {
            String string;
            if ($this$javaClassName.external_name == null) {
                return null;
            }
            String string2 = $this$javaClassName.external_name;
            Intrinsics.checkNotNull((Object)string2);
            int p2 = StringsKt.lastIndexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (p2 >= 0) {
                String string3;
                String string4 = $this$javaClassName.external_name;
                Intrinsics.checkNotNull((Object)string4);
                String string5 = string4.substring(0, p2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                String it = string3 = string5;
                boolean bl = false;
                string = !Intrinsics.areEqual((Object)it, (Object)"null") ? string3 : null;
            } else {
                string = null;
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveConstants(H2Schema schema) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.CONSTANT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CONSTANT");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = schema.getConstants();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily constants = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processConstants(this.getTransaction(), schema, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.ConstantInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveConstants$lambda$107$lambda$106$lambda$105(constants, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveSynonyms(H2Schema schema) {
            void $this$modifyAndCleanup_u24default$iv;
            Object object = new int[]{1, 4, 197};
            if (!H2Introspector.this.getServerVersion().isOrGreater((int)object)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.SYNONYM;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SYNONYM");
            H2Introspector.this.reportRetrieving(objectKind);
            object = schema.getSynonyms();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily synonyms = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processSynonyms(this.getTransaction(), schema, (Function1<? super H2IntroQueries.SynonymInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveSynonyms$lambda$111$lambda$110$lambda$109(synonyms, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        private final void retrieveSourcesV2(H2Schema schema) {
            this.getModel().writeSources(() -> H2SchemaAbstractSchemaRetriever.retrieveSourcesV2$lambda$112(this, schema));
        }

        private final void retrieveViewSources(H2Schema schema) {
            H2Introspector.this.reportRetrieving("view sources", "introspection.retrieve.view.sources");
            H2IntroQueries.INSTANCE.processViewSources(this.getTransaction(), schema, (Function1<? super H2IntroQueries.SourceInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveViewSources$lambda$113(schema, this, arg_0)));
        }

        private final void retrieveTriggerSources(H2Schema schema) {
            H2Introspector.this.reportRetrieving("trigger sources", "introspection.retrieve.trigger.sources");
            HashMap triggerMap = new HashMap();
            for (H2Table h2Table : schema.getTables()) {
                for (H2Trigger h2Trigger : h2Table.getTriggers()) {
                    ((Map)triggerMap).put(h2Trigger.getName(), h2Trigger);
                }
            }
            H2IntroQueries.INSTANCE.processTriggerSources(this.getTransaction(), schema, (Function1<? super H2IntroQueries.SourceInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveTriggerSources$lambda$114(triggerMap, this, arg_0)));
        }

        private static final void retrieveMainContent$lambda$1$lambda$0(H2SchemaAbstractSchemaRetriever this$0, H2Schema $schema, H2Introspector this$1) {
            this$0.retrieveDomains($schema);
            if (this$1.isNewSchema()) {
                this$0.retrieveDomainChecks($schema);
            }
            this$0.retrieveTables($schema);
            this$0.retrieveColumns($schema);
            this$0.retrieveIndexes($schema);
            this$0.retrieveTriggers($schema);
            this$0.retrieveConstants($schema);
            if (this$1.isNewSchema()) {
                this$0.retrieveRoutinesV2($schema);
            } else {
                this$0.retrieveRoutines($schema);
            }
        }

        private static final Unit retrieveMainContent$lambda$1(H2Introspector this$0, H2SchemaAbstractSchemaRetriever this$1, H2Schema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            if (this$0.isNewSchema()) {
                this$1.retrieveEnumValues(schema);
                this$1.retrieveArrayTypes(schema);
                this$1.retrieveRowFields(schema);
            }
            this$1.retrieveSequences(schema);
            this$1.getModel().writeSources(() -> H2SchemaAbstractSchemaRetriever.retrieveMainContent$lambda$1$lambda$0(this$1, schema, this$0));
            this$1.retrieveConstraints(schema);
            this$1.retrieveSynonyms(schema);
            if (this$0.isNewSchema()) {
                this$1.retrieveSourcesV2(schema);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveEnumValues$lambda$3$lambda$2(H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.EnumValueInfo info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            ((Map)this$0.enumValues).put(info2.enum_identifier, ArraysKt.asList((Object[])info2.enum_values));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveArrayTypes$lambda$5$lambda$4(H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.ArrayElementInfo info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            ((Map)this$0.arrayElementTypes).put(info2.collection_type_identifier, info2);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRowFields$lambda$7$lambda$6(H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.RowFieldInfo info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            this$0.rowFields.putValue((Object)info2.row_identifier, (Object)info2);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveDomains$lambda$11$lambda$10$lambda$9(ModNamingFamily $domains, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.DomainInfo info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            Object e = $domains.createOrGet(info2.name);
            H2Domain $this$retrieveDomains_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = (H2Domain)e;
            boolean bl = false;
            $this$retrieveDomains_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248.setStoredType(this$0.getDasType(info2));
            $this$retrieveDomains_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248.setDefaultExpression(info2.domain_default);
            $this$retrieveDomains_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248.setOnUpdateExpression(info2.domain_on_update);
            String string = info2.sql;
            $this$retrieveDomains_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248.setSourceText(string != null ? this$0.toCompositeText(string) : null);
            $this$retrieveDomains_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248.setComment(info2.remarks);
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveDomainChecks$lambda$17$lambda$16$lambda$15(NameCache $domainCache, H2Schema $schema, H2IntroQueries.DomainCheckInfo info) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                var4_3 = $domainCache;
                name$iv = info.domain_name;
                $i$f$get = false;
                var7_6 = this_$iv;
                create$iv$iv = false;
                $i$f$get = false;
                if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                v0 = this_$iv$iv.getV();
                Intrinsics.checkNotNull(v0);
                if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                    v1 = this_$iv$iv.getV();
                } else lbl-1000:
                // 2 sources

                {
                    var10_9 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                        final /* synthetic */ boolean $create;
                        final /* synthetic */ String $name;
                        {
                            this.$create = $create;
                            this.$name = $name;
                        }

                        public final T invoke(ModNamingFamily<? extends T> $this$family) {
                            Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                            return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                        }
                    };
                    var11_10 = this_$iv$iv;
                    var13_11 = this_$iv$iv;
                    $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveDomainChecks$2$1$1$domain$1 = false;
                    v2 = $schema.getDomains();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"getDomains(...)");
                    var13_11.setV((BasicModNamedElement)((H2Domain)it.invoke(v2)));
                    v1 = this_$iv$iv.getV();
                }
                v3 = (H2Domain)v1;
                if (v3 == null) {
                    return Unit.INSTANCE;
                }
                domain = v3;
                v4 = domain.getChecks().createOrGet(info.constraint_name);
                if (v4 == null) break block3;
                $this$retrieveDomainChecks_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414 = var4_3 = v4;
                $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveDomainChecks$2$1$1$1 = false;
                $this$retrieveDomainChecks_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.setPredicate(info.check_clause);
                $this$retrieveDomainChecks_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.setNameSurrogate(StringsKt.startsWith$default((String)info.constraint_name, (String)"CONSTRAINT_", (boolean)false, (int)2, null));
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTables$lambda$21$lambda$20$lambda$19(H2Schema $schema, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.TableInfo info2) {
            H2LikeTable h2LikeTable;
            ModNamingFamily<H2LikeTable> modNamingFamily;
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            if (info2.is_view) {
                ModNamingFamily<? extends H2View> modNamingFamily2 = $schema.getViews();
                modNamingFamily = modNamingFamily2;
                Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getViews(...)");
            } else {
                ModNamingFamily<? extends H2Table> modNamingFamily3 = $schema.getTables();
                modNamingFamily = modNamingFamily3;
                Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getTables(...)");
            }
            ModNamingFamily<H2LikeTable> family = modNamingFamily;
            H2LikeTable $this$retrieveTables_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418 = h2LikeTable = family.createOrGet(info2.table_name);
            boolean bl = false;
            if ($this$retrieveTables_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418 instanceof H2Table) {
                ((H2Table)$this$retrieveTables_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418).setTemporary(info2.is_temp);
            }
            if ($this$retrieveTables_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418 instanceof H2View) {
                String string = info2.sql;
                ((H2View)$this$retrieveTables_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418).setSourceText(string != null ? this$0.toCompositeText(string) : null);
            }
            $this$retrieveTables_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418.setComment(info2.remarks);
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static final Unit retrieveColumns$lambda$30$lambda$29$lambda$28(NameCache $tableCache, H2Schema $schema, H2SchemaAbstractSchemaRetriever this$0, H2Introspector this$1, H2IntroQueries.ColumnInfo info) {
            block16: {
                block18: {
                    block19: {
                        block15: {
                            block17: {
                                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                                var7_5 = $tableCache;
                                name$iv = info.table_name;
                                $i$f$get = false;
                                var10_11 = this_$iv;
                                create$iv$iv = false;
                                $i$f$get = false;
                                if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                                v0 = this_$iv$iv.getV();
                                Intrinsics.checkNotNull(v0);
                                if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                                    v1 = this_$iv$iv.getV();
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var13_15 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                                        final /* synthetic */ boolean $create;
                                        final /* synthetic */ String $name;
                                        {
                                            this.$create = $create;
                                            this.$name = $name;
                                        }

                                        public final T invoke(ModNamingFamily<? extends T> $this$family) {
                                            Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                                            return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                                        }
                                    };
                                    var14_16 = this_$iv$iv;
                                    var20_17 = this_$iv$iv;
                                    $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveColumns$3$1$1$table$1 = false;
                                    v2 = $schema.getTables();
                                    Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                                    v3 = (H2LikeTable)it.invoke(v2);
                                    if (v3 == null) {
                                        v4 = $schema.getViews();
                                        Intrinsics.checkNotNullExpressionValue(v4, (String)"getViews(...)");
                                        v3 = (H2LikeTable)it.invoke(v4);
                                    }
                                    var20_17.setV((BasicModNamedElement)v3);
                                    v1 = this_$iv$iv.getV();
                                }
                                v5 = (H2LikeTable)v1;
                                if (v5 == null) {
                                    return Unit.INSTANCE;
                                }
                                table = v5;
                                var6_20 = table.getColumns().createOrGetAt(info.ordinal_position);
                                $this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427 = (BasicModTableOrViewColumn)var6_20;
                                $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveColumns$3$1$1$1 = false;
                                $this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setName(info.column_name);
                                $this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setStoredType(this$0.getDasType(info));
                                v6 = $this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427;
                                v7 = info.column_default;
                                if (v7 != null) {
                                    this_$iv$iv = $i$f$get = v7;
                                    var11_13 = v6;
                                    $i$a$-takeIf-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveColumns$3$1$1$1$1 = false;
                                    v6 = var11_13;
                                    v8 = Boolean.valueOf(H2Introspector.access$isNewSchema(this$1) != false || info.is_identity == false).booleanValue() ? $i$f$get : null;
                                } else {
                                    v8 = null;
                                }
                                v6.setDefaultExpression(v8);
                                if (!($this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427 instanceof H2TableColumn)) break block16;
                                if (!H2Introspector.access$isNewSchema(this$1)) break block17;
                                ((H2TableColumn)$this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427).setOnUpdate(info.column_on_update);
                                if (info.is_identity) {
                                    v9 = BasicMetaUtils.getMetaObject((Family)$schema.getSequences()).newDataObject();
                                    Intrinsics.checkNotNullExpressionValue(v9, (String)"newDataObject(...)");
                                    sequence = (H2Sequence)v9;
                                    this$0.processSequenceLike(sequence, info, info.is_identity);
                                    BasicDataObject.freeze(sequence);
                                    ((H2TableColumn)$this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427).setSequenceRef(BasicInlineObjectReference.create(sequence));
                                } else {
                                    ((H2TableColumn)$this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427).setSequenceRef(null);
                                }
                                break block18;
                            }
                            if (!H2Introspector.access$isV2(this$1)) break block19;
                            columnPsi = SqlPsiElementFactory.createColumnFromText(info.column_name + " " + info.getColumn_type(), H2Dialect.INSTANCE, H2Introspector.access$getProject(this$1));
                            v10 /* !! */  = columnPsi;
                            if (v10 /* !! */  == null || (v10 /* !! */  = v10 /* !! */ .getConstraints()) == null) ** GOTO lbl-1000
                            $this$firstOrNull$iv = (Iterable)v10 /* !! */ ;
                            $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                it = (SqlConstraintDefinition)element$iv;
                                $i$a$-firstOrNull-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveColumns$3$1$1$1$defaultHolder$1 = false;
                                if (!(it.getConstraintType() == SqlConstraintDefinition.Type.DEFAULT)) continue;
                                v11 = element$iv;
                                break block15;
                            }
                            v11 = null;
                        }
                        if ((v10 /* !! */  = (SqlConstraintDefinition)v11) != null) {
                            v12 = (SqlCompositeElement)v10 /* !! */ ;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v12 = (SqlCompositeElement)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)columnPsi), SqlColumnGeneratedClause.class);
                        }
                        defaultHolder = v12;
                        onUpdateClause = (H2OnUpdateClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)columnPsi), H2OnUpdateClause.class);
                        v13 = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)defaultHolder), SqlExpression.class);
                        ((H2TableColumn)$this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427).setDefaultExpression(v13 != null ? v13.getText() : null);
                        v14 = onUpdateClause;
                        ((H2TableColumn)$this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427).setOnUpdate(v14 != null && (v14 = v14.getExpression()) != null ? v14.getText() : null);
                    }
                    ((H2TableColumn)$this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427).setSequenceRef(BasicNameReference.create(info.sequence_name));
                }
                v15 = (H2TableColumn)$this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427;
                if (info.is_generated || Intrinsics.areEqual((Object)info.identity_generation, (Object)"ALWAYS")) {
                    v16 = ColumnKind.GENERATED_VIRTUAL;
                } else if (info.is_identity) {
                    v17 = info.getColumn_type();
                    v16 = (v17 != null ? StringsKt.contains((CharSequence)v17, (CharSequence)"generated always", (boolean)true) : false) ? ColumnKind.GENERATED_VIRTUAL : ColumnKind.GENERATED_STORED;
                } else {
                    v16 = ColumnKind.NORMAL;
                }
                v15.setColumnKind(v16);
                ((H2TableColumn)$this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427).setHidden(info.is_visible == false);
            }
            $this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setNotNull(info.is_nullable == false);
            $this$retrieveColumns_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setComment(info.remarks);
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveConstraints$lambda$45$lambda$44$lambda$37(NameCache $tableCache, H2SchemaAbstractSchemaRetriever this$0, H2Introspector this$1, HashMap $constraintMap, H2Schema $schema, H2IntroQueries.ConstraintInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            var8_6 = $tableCache;
            name$iv = info.table_name;
            $i$f$get = false;
            var11_11 = this_$iv;
            create$iv$iv = false;
            $i$f$get = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv$iv.getV();
            Intrinsics.checkNotNull(v0);
            if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                v1 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var14_19 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                var15_20 = this_$iv$iv;
                var17_21 = this_$iv$iv;
                $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$table$1 = false;
                v2 = $schema.getTables();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                var17_21.setV((BasicModNamedElement)((H2Table)it.invoke(v2)));
                v1 = this_$iv$iv.getV();
            }
            v3 = (H2Table)v1;
            if (v3 == null) {
                return Unit.INSTANCE;
            }
            table = v3;
            v4 = info.unique_index_name;
            if (v4 != null) {
                it = v4;
                $i$a$-let-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$index$1 = false;
                v5 = (H2Index)table.getIndices().get(it);
            } else {
                v5 = null;
            }
            if ((v6 = (index = v5)) == null || (v6 = v6.getColNames()) == null) {
                v7 = info.column_list;
                if (v7 == null) {
                    v7 = "";
                }
                v6 = this$0.parseColumnList(v7);
            }
            colNames = v6;
            it = info.constraint_type;
            tmp = -1;
            switch (it.hashCode()) {
                case 1284802305: {
                    if (it.equals("PRIMARY KEY")) {
                        tmp = 1;
                    }
                    break;
                }
                case -1787199535: {
                    if (it.equals("UNIQUE")) {
                        tmp = 2;
                    }
                    break;
                }
                case 64089320: {
                    if (it.equals("CHECK")) {
                        tmp = 3;
                    }
                    break;
                }
                case 704200915: {
                    if (it.equals("FOREIGN KEY")) {
                        tmp = 4;
                    }
                    break;
                }
                case 2137260521: {
                    if (it.equals("REFERENTIAL")) {
                        tmp = 4;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    v8 = table.getKeys();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getKeys(...)");
                    var11_13 = this$0.renewConstraint((ModNamingFamily<C>)v8, info.constraint_name, colNames);
                    $this$retrieveConstraints_u24lambda_u2445_u24lambda_u2444_u24lambda_u2437_u24lambda_u2434 = (H2Key)var11_13;
                    $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$constraint$1 = false;
                    $this$retrieveConstraints_u24lambda_u2445_u24lambda_u2444_u24lambda_u2437_u24lambda_u2434.setPrimary(true);
                    v9 = var11_13;
                    break;
                }
                case 2: {
                    v10 = table.getKeys();
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getKeys(...)");
                    v9 = this$0.renewConstraint((ModNamingFamily<C>)v10, info.constraint_name, colNames);
                    break;
                }
                case 3: {
                    v11 = table.getChecks();
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getChecks(...)");
                    var11_14 = this$0.renewConstraint((ModNamingFamily<C>)v11, info.constraint_name, colNames);
                    $this$retrieveConstraints_u24lambda_u2445_u24lambda_u2444_u24lambda_u2437_u24lambda_u2436 = (H2Check)var11_14;
                    $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$constraint$2 = false;
                    v12 = $this$retrieveConstraints_u24lambda_u2445_u24lambda_u2444_u24lambda_u2437_u24lambda_u2436;
                    v13 = info.check_expression;
                    if (v13 != null) {
                        it = v13;
                        var15_20 = v12;
                        $i$a$-let-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$constraint$2$1 = false;
                        v14 = this$0.removeParens(it);
                        v12 = var15_20;
                    } else {
                        v14 = null;
                    }
                    v12.setPredicate(v14);
                    v9 = var11_14;
                    break;
                }
                case 4: {
                    v15 = table.getForeignKeys();
                    Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"getForeignKeys(...)");
                    v9 = this$0.renewConstraint((ModNamingFamily<C>)v15, info.constraint_name, colNames);
                    break;
                }
                default: {
                    return Unit.INSTANCE;
                }
            }
            constraint = v9;
            key = H2Introspector.access$isNewSchema(this$1) != false ? (Serializable)info.constraint_name : (Serializable)TuplesKt.to((Object)info.table_name, (Object)info.constraint_name);
            ((Map)$constraintMap).put(key, constraint);
            constraint.setNameSurrogate(StringsKt.startsWith$default((String)info.constraint_name, (String)"CONSTRAINT_", (boolean)false, (int)2, null));
            constraint.setColNames(colNames);
            constraint.setComment(info.remarks);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveConstraints$lambda$45$lambda$44$lambda$41(H2Introspector this$0, HashMap $constraintMap, H2SchemaAbstractSchemaRetriever this$1, H2IntroQueries.ForeignKeyInfo info2) {
            BasicReference basicReference;
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            H2Constraint h2Constraint = this$0.isNewSchema() ? (H2Constraint)$constraintMap.get(info2.fk_name) : (H2Constraint)$constraintMap.get(TuplesKt.to((Object)info2.fktable_name, (Object)info2.fk_name));
            H2ForeignKey h2ForeignKey = h2Constraint instanceof H2ForeignKey ? (H2ForeignKey)h2Constraint : null;
            if (h2ForeignKey == null) {
                return Unit.INSTANCE;
            }
            H2ForeignKey key2 = h2ForeignKey;
            BasicNameReference nameRef = BasicNameReference.create(info2.pk_name);
            if (this$0.isV2()) {
                key2.setRefKeyRef(nameRef);
            } else {
                key2.setRefKeyRef(BasicKeyByIndexReference.create(nameRef));
            }
            H2ForeignKey h2ForeignKey2 = key2;
            if (this$0.isNewSchema()) {
                H2Constraint h2Constraint2 = (H2Constraint)$constraintMap.get(info2.pk_name);
                DasTable dasTable = h2Constraint2 != null ? h2Constraint2.getTable() : null;
                H2LikeTable h2LikeTable = dasTable instanceof H2LikeTable ? (H2LikeTable)dasTable : null;
                if (h2LikeTable != null) {
                    void it;
                    H2LikeTable h2LikeTable2 = h2LikeTable;
                    H2ForeignKey h2ForeignKey3 = h2ForeignKey2;
                    boolean bl = false;
                    basicReference = BasicParentReference.create(it.getSchemaName(), BasicNameReference.create(it.getName()));
                    h2ForeignKey2 = h2ForeignKey3;
                } else {
                    basicReference = null;
                }
            } else {
                String string;
                String it = string = info2.pktable_name;
                H2ForeignKey h2ForeignKey4 = h2ForeignKey2;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                h2ForeignKey2 = h2ForeignKey4;
                String string2 = bl2 ? string : null;
                if (string2 != null) {
                    it = string2;
                    h2ForeignKey4 = h2ForeignKey2;
                    boolean bl3 = false;
                    basicReference = BasicParentReference.create(info2.pktable_schema, BasicNameReference.create(info2.pktable_name));
                    h2ForeignKey2 = h2ForeignKey4;
                } else {
                    basicReference = null;
                }
            }
            h2ForeignKey2.setRefTableRef(basicReference);
            key2.setOnUpdate(this$1.getCascadeRule(info2.update_rule));
            key2.setOnDelete(this$1.getCascadeRule(info2.delete_rule));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveConstraints$lambda$45$lambda$44$lambda$42(HashMap $constraintMap, H2IntroQueries.CheckInfo info2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                Object v = $constraintMap.get(info2.constraint_name);
                H2Check h2Check = v instanceof H2Check ? (H2Check)v : null;
                if (h2Check == null) break block0;
                h2Check.setPredicate(info2.check_clause);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveConstraints$lambda$45$lambda$44$lambda$43(HashMap $constraintMap, MultiMap $keyColumnNames, H2IntroQueries.ForeignKeyColumnInfo info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            H2Constraint h2Constraint = (H2Constraint)$constraintMap.get(info2.constraint_name);
            if (h2Constraint == null) {
                return Unit.INSTANCE;
            }
            H2Constraint key2 = h2Constraint;
            if (!$keyColumnNames.get((Object)key2).contains(info2.column_name)) {
                $keyColumnNames.putValue((Object)key2, (Object)info2.column_name);
            }
            return Unit.INSTANCE;
        }

        private static final boolean renewConstraint$lambda$46(List $colNames, H2Constraint it) {
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return ((CharSequence)string).length() == 0 && ((BasicModMixinElement)it).isSyncPending() && Intrinsics.areEqual(((BasicColumniation)it).getColNames(), (Object)$colNames);
        }

        private static final boolean renewConstraint$lambda$47(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveIndexes$lambda$60$lambda$59$lambda$55(NameCache $tableCache, H2Schema $schema, H2IntroQueries.IndexInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            var5_3 = $tableCache;
            name$iv = info.table_name;
            $i$f$get = false;
            var8_7 = this_$iv;
            create$iv$iv = false;
            $i$f$get = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv$iv.getV();
            Intrinsics.checkNotNull(v0);
            if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                v1 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var11_10 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                var12_11 = this_$iv$iv;
                var14_12 = this_$iv$iv;
                $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveIndexes$2$1$1$table$1 = false;
                v2 = $schema.getTables();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                var14_12.setV((BasicModNamedElement)((H2Table)it.invoke(v2)));
                v1 = this_$iv$iv.getV();
            }
            v3 = (H2Table)v1;
            if (v3 == null) {
                return Unit.INSTANCE;
            }
            table = v3;
            var4_15 = table.getIndices().createOrGet(info.index_name);
            $this$retrieveIndexes_u24lambda_u2460_u24lambda_u2459_u24lambda_u2455_u24lambda_u2454 = (H2Index)var4_15;
            $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveIndexes$2$1$1$1 = false;
            $this$retrieveIndexes_u24lambda_u2460_u24lambda_u2459_u24lambda_u2455_u24lambda_u2454.setNameSurrogate(info.is_generated);
            $this$retrieveIndexes_u24lambda_u2460_u24lambda_u2459_u24lambda_u2455_u24lambda_u2454.setUnique(info.non_unique == false);
            $this$retrieveIndexes_u24lambda_u2460_u24lambda_u2459_u24lambda_u2455_u24lambda_u2454.setComment(info.remarks);
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveIndexes$lambda$60$lambda$59$lambda$58(NameCache $tableCache, NameCache $indexCache, ArrayList $indexColumns, H2SchemaAbstractSchemaRetriever this$0, H2Schema $schema, H2IntroQueries.IndexColumnInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            var8_6 = $tableCache;
            name$iv = info.table_name;
            $i$f$get = false;
            var11_11 = this_$iv;
            create$iv$iv = false;
            $i$f$get = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv$iv.getV();
            Intrinsics.checkNotNull(v0);
            if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                v1 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var14_16 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                var15_17 = this_$iv$iv;
                var17_19 = this_$iv$iv;
                $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveIndexes$2$1$2$table$1 = false;
                H2SchemaAbstractSchemaRetriever.access$applyIndexColumns(this$0, (H2Index)$indexCache.getV(), $indexColumns);
                $indexCache.setV(null);
                v2 = $schema.getTables();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                var17_19.setV((BasicModNamedElement)((H2Table)it.invoke(v2)));
                v1 = this_$iv$iv.getV();
            }
            v3 = (H2Table)v1;
            if (v3 == null) {
                return Unit.INSTANCE;
            }
            table = v3;
            var7_22 = $indexCache;
            name$iv = info.index_name;
            $i$f$get = false;
            $i$f$get = this_$iv;
            create$iv$iv = false;
            $i$f$get = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v4 = this_$iv$iv.getV();
            Intrinsics.checkNotNull(v4);
            if (Intrinsics.areEqual((Object)v4.getName(), (Object)name$iv)) {
                v5 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                $i$f$get = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                it = this_$iv$iv;
                var17_19 = this_$iv$iv;
                $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveIndexes$2$1$2$1 = false;
                H2SchemaAbstractSchemaRetriever.access$applyIndexColumns(this$0, (H2Index)$indexCache.getV(), $indexColumns);
                v6 = table.getIndices();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getIndices(...)");
                var17_19.setV((BasicModNamedElement)((H2Index)it.invoke((Object)v6)));
                v5 = this_$iv$iv.getV();
            }
            ((Collection)$indexColumns).add(info);
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveTriggers$lambda$70$lambda$69$lambda$68(NameCache $tableCache, H2Schema $schema, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.TriggerInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            var6_4 = $tableCache;
            name$iv = info.table_name;
            $i$f$get = false;
            var9_8 = this_$iv;
            create$iv$iv = false;
            $i$f$get = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv$iv.getV();
            Intrinsics.checkNotNull(v0);
            if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                v1 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var12_11 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                var13_12 = this_$iv$iv;
                var15_13 = this_$iv$iv;
                $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveTriggers$2$1$1$table$1 = false;
                v2 = $schema.getTables();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                var15_13.setV((BasicModNamedElement)((H2Table)it.invoke(v2)));
                v1 = this_$iv$iv.getV();
            }
            v3 = (H2Table)v1;
            if (v3 == null) {
                return Unit.INSTANCE;
            }
            table = v3;
            $this$retrieveTriggers_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467 = var5_16 = table.getTriggers().createOrGet(info.trigger_name);
            $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveTriggers$2$1$1$1 = false;
            $this$retrieveTriggers_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.setSchemaName(info.trigger_schema);
            v4 = info.sql;
            $this$retrieveTriggers_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.setSourceText(v4 != null ? this$0.toCompositeText(v4) : null);
            $this$retrieveTriggers_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.setTurn(H2IntrospectorKt.access$asTrigTurn(info));
            $this$retrieveTriggers_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.setEvents(SetsKt.setOf((Object)H2IntrospectorKt.access$asEvent(info)));
            $this$retrieveTriggers_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.setComment(info.remarks);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveSequences$lambda$73$lambda$72$lambda$71(ModNamingFamily $sequences, H2SchemaAbstractSchemaRetriever this$0, Ref.IntRef $order, H2IntroQueries.SequenceInfo info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            H2Sequence sequence = (H2Sequence)$sequences.createOrGet(info2.sequence_name);
            Intrinsics.checkNotNull((Object)sequence);
            H2SchemaAbstractSchemaRetriever.processSequenceLike$default(this$0, sequence, info2, false, 4, null);
            sequence.setNameSurrogate(info2.is_generated);
            Object object = StringKt.nullize$default((String)info2.remarks, (boolean)false, (int)1, null);
            if (object == null) {
                if (info2.is_generated) {
                    ++$order.element;
                    object = "#" + $order.element;
                } else {
                    object = null;
                }
            }
            sequence.setComment((String)object);
            return Unit.INSTANCE;
        }

        private static final boolean retrieveRoutines$lambda$82$lambda$81$lambda$80$lambda$76(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Unit retrieveRoutines$lambda$82$lambda$81$lambda$80(ModNamingFamily $aggregates, ModNamingFamily $routines, HashMap $aliasMap, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.RoutineInfo info2) {
            H2LikeRoutine h2LikeRoutine;
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            String aliasName = info2.alias_name;
            int colCount = info2.column_count;
            Object object = info2.source;
            if ((object == null || object.length() == 0) && ((object = (CharSequence)info2.java_method) == null || object.length() == 0)) {
                h2LikeRoutine = (H2LikeRoutine)$aggregates.createOrGet(aliasName);
            } else {
                Object object2;
                object = (H2Routine)$routines.find(arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveRoutines$lambda$82$lambda$81$lambda$80$lambda$76(new Function1(aliasName, colCount){
                    final /* synthetic */ String $aliasName;
                    final /* synthetic */ int $colCount;
                    {
                        this.$aliasName = $aliasName;
                        this.$colCount = $colCount;
                    }

                    public final Boolean invoke(H2Routine it) {
                        return Intrinsics.areEqual((Object)((H2LikeRoutine)it).getName(), (Object)this.$aliasName) && ((H2LikeRoutine)it).getArguments().size() == this.$colCount + 1;
                    }
                }, arg_0));
                if (object != null) {
                    Object object3;
                    Object $this$retrieveRoutines_u24lambda_u2482_u24lambda_u2481_u24lambda_u2480_u24lambda_u2477 = object3 = object;
                    boolean bl = false;
                    $this$retrieveRoutines_u24lambda_u2482_u24lambda_u2481_u24lambda_u2480_u24lambda_u2477.resetSyncPending();
                    object2 = object3;
                } else {
                    Object e = $routines.createNewOne();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"createNewOne(...)");
                    Object e2 = e;
                    H2Routine $this$retrieveRoutines_u24lambda_u2482_u24lambda_u2481_u24lambda_u2480_u24lambda_u2478 = (H2Routine)e2;
                    boolean bl = false;
                    $this$retrieveRoutines_u24lambda_u2482_u24lambda_u2481_u24lambda_u2480_u24lambda_u2478.setName(aliasName);
                    object2 = (H2Routine)e2;
                }
                h2LikeRoutine = (H2LikeRoutine)object2;
            }
            H2LikeRoutine routine2 = h2LikeRoutine;
            ((Map)$aliasMap).put(aliasName + "/" + colCount, routine2);
            H2LikeRoutine $this$retrieveRoutines_u24lambda_u2482_u24lambda_u2481_u24lambda_u2480_u24lambda_u2479 = routine2;
            boolean bl = false;
            $this$retrieveRoutines_u24lambda_u2482_u24lambda_u2481_u24lambda_u2480_u24lambda_u2479.setRoutineKind(info2.is_func ? DasRoutine.Kind.FUNCTION : DasRoutine.Kind.PROCEDURE);
            if ($this$retrieveRoutines_u24lambda_u2482_u24lambda_u2481_u24lambda_u2480_u24lambda_u2479 instanceof H2Routine) {
                ((H2Routine)$this$retrieveRoutines_u24lambda_u2482_u24lambda_u2481_u24lambda_u2480_u24lambda_u2479).setJavaClass(info2.java_class);
                String string = info2.source;
                ((H2Routine)$this$retrieveRoutines_u24lambda_u2482_u24lambda_u2481_u24lambda_u2480_u24lambda_u2479).setSourceText(string != null && (string = StringKt.nullize$default((String)string, (boolean)false, (int)1, null)) != null ? this$0.toCompositeText(string) : null);
                ((H2Routine)$this$retrieveRoutines_u24lambda_u2482_u24lambda_u2481_u24lambda_u2480_u24lambda_u2479).setJavaMethod(info2.java_method);
            } else {
                $this$retrieveRoutines_u24lambda_u2482_u24lambda_u2481_u24lambda_u2480_u24lambda_u2479.setJavaClass(info2.java_class);
            }
            $this$retrieveRoutines_u24lambda_u2482_u24lambda_u2481_u24lambda_u2480_u24lambda_u2479.setComment(info2.remarks);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoutines$lambda$87$lambda$86$lambda$85(HashMap $aliasMap, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.RoutineArgumentInfo info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            H2LikeRoutine h2LikeRoutine = (H2LikeRoutine)$aliasMap.get(info2.alias_name + "/" + info2.column_count);
            if (h2LikeRoutine == null) {
                return Unit.INSTANCE;
            }
            H2LikeRoutine routine2 = h2LikeRoutine;
            Object e = routine2.getArguments().createOrGetAt(info2.pos);
            H2Argument $this$retrieveRoutines_u24lambda_u2487_u24lambda_u2486_u24lambda_u2485_u24lambda_u2484 = (H2Argument)e;
            boolean bl = false;
            $this$retrieveRoutines_u24lambda_u2487_u24lambda_u2486_u24lambda_u2485_u24lambda_u2484.setName(info2.column_name);
            $this$retrieveRoutines_u24lambda_u2487_u24lambda_u2486_u24lambda_u2485_u24lambda_u2484.setArgumentDirection(info2._column_type == 5 ? ArgumentDirection.RETURN : ArgumentDirection.IN);
            $this$retrieveRoutines_u24lambda_u2487_u24lambda_u2486_u24lambda_u2485_u24lambda_u2484.setStoredType(this$0.getDasType(info2));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoutinesV2$lambda$95$lambda$94$lambda$93(ModNamingFamily $aggregates, ModNamingFamily $routines, HashMap $routineMap, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.RoutineInfoV2 info2) {
            H2LikeRoutine h2LikeRoutine;
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            String routineName = info2.routine_name;
            String string = info2.specific_name;
            if (string == null) {
                return Unit.INSTANCE;
            }
            String specificName = string;
            boolean isAggregate = Intrinsics.areEqual((Object)info2.routine_type, (Object)"AGGREGATE");
            boolean isFunction = Intrinsics.areEqual((Object)info2.routine_type, (Object)"FUNCTION");
            ModNamingFamily family = isAggregate ? $aggregates : $routines;
            H2LikeRoutine h2LikeRoutine2 = (H2LikeRoutine)$routineMap.get(specificName);
            if (h2LikeRoutine2 != null) {
                H2LikeRoutine $this$retrieveRoutinesV2_u24lambda_u2495_u24lambda_u2494_u24lambda_u2493_u24lambda_u2490 = var13_10 = h2LikeRoutine2;
                boolean bl = false;
                $this$retrieveRoutinesV2_u24lambda_u2495_u24lambda_u2494_u24lambda_u2493_u24lambda_u2490.resetSyncPending();
                h2LikeRoutine = var13_10;
            } else {
                Object e = family.createNewOne();
                Intrinsics.checkNotNullExpressionValue(e, (String)"createNewOne(...)");
                H2LikeRoutine $this$retrieveRoutinesV2_u24lambda_u2495_u24lambda_u2494_u24lambda_u2493_u24lambda_u2491 = var13_10 = e;
                boolean bl = false;
                $this$retrieveRoutinesV2_u24lambda_u2495_u24lambda_u2494_u24lambda_u2493_u24lambda_u2491.setName(routineName);
                ((Map)$routineMap).put(specificName, $this$retrieveRoutinesV2_u24lambda_u2495_u24lambda_u2494_u24lambda_u2493_u24lambda_u2491);
                h2LikeRoutine = var13_10;
            }
            H2LikeRoutine routine2 = h2LikeRoutine;
            routine2.setSpecificName(specificName);
            H2LikeRoutine $this$retrieveRoutinesV2_u24lambda_u2495_u24lambda_u2494_u24lambda_u2493_u24lambda_u2492 = routine2;
            boolean bl = false;
            $this$retrieveRoutinesV2_u24lambda_u2495_u24lambda_u2494_u24lambda_u2493_u24lambda_u2492.setRoutineKind(isFunction ? DasRoutine.Kind.FUNCTION : DasRoutine.Kind.PROCEDURE);
            if ($this$retrieveRoutinesV2_u24lambda_u2495_u24lambda_u2494_u24lambda_u2493_u24lambda_u2492 instanceof H2Routine) {
                ((H2Routine)$this$retrieveRoutinesV2_u24lambda_u2495_u24lambda_u2494_u24lambda_u2493_u24lambda_u2492).setJavaClass(this$0.javaClassName(info2));
                ((H2Routine)$this$retrieveRoutinesV2_u24lambda_u2495_u24lambda_u2494_u24lambda_u2493_u24lambda_u2492).setJavaMethod(this$0.javaMethodName(info2));
                String string2 = info2.routine_definition;
                ((H2Routine)$this$retrieveRoutinesV2_u24lambda_u2495_u24lambda_u2494_u24lambda_u2493_u24lambda_u2492).setSourceText(string2 != null && (string2 = StringKt.nullize$default((String)string2, (boolean)false, (int)1, null)) != null ? this$0.toCompositeText(string2) : null);
            } else {
                $this$retrieveRoutinesV2_u24lambda_u2495_u24lambda_u2494_u24lambda_u2493_u24lambda_u2492.setJavaClass(info2.external_name);
            }
            if (isFunction) {
                $this$retrieveRoutinesV2_u24lambda_u2495_u24lambda_u2494_u24lambda_u2493_u24lambda_u2492.createOrGetReturnArgument().setStoredType(this$0.getDasType(info2));
            }
            $this$retrieveRoutinesV2_u24lambda_u2495_u24lambda_u2494_u24lambda_u2493_u24lambda_u2492.setComment(info2.remarks);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoutinesV2$lambda$101$lambda$100$lambda$98(HashMap $routineMap, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.RoutineArgumentInfoV2 info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            H2LikeRoutine h2LikeRoutine = (H2LikeRoutine)$routineMap.get(info2.specific_name);
            if (h2LikeRoutine == null) {
                return Unit.INSTANCE;
            }
            H2LikeRoutine routine2 = h2LikeRoutine;
            Object e = routine2.getArguments().createOrGetAt(info2.ordinal_position);
            H2Argument $this$retrieveRoutinesV2_u24lambda_u24101_u24lambda_u24100_u24lambda_u2498_u24lambda_u2497 = (H2Argument)e;
            boolean bl = false;
            $this$retrieveRoutinesV2_u24lambda_u24101_u24lambda_u24100_u24lambda_u2498_u24lambda_u2497.setName(info2.parameter_name);
            $this$retrieveRoutinesV2_u24lambda_u24101_u24lambda_u24100_u24lambda_u2498_u24lambda_u2497.setArgumentDirection(ArgumentDirection.IN);
            $this$retrieveRoutinesV2_u24lambda_u24101_u24lambda_u24100_u24lambda_u2498_u24lambda_u2497.setStoredType(this$0.getDasType(info2));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveConstants$lambda$107$lambda$106$lambda$105(ModNamingFamily $constants, H2IntroQueries.ConstantInfo info2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            Object e = $constants.createOrGet(info2.constant_name);
            H2Constant $this$retrieveConstants_u24lambda_u24107_u24lambda_u24106_u24lambda_u24105_u24lambda_u24104 = (H2Constant)e;
            boolean bl = false;
            int num = StringUtil.parseInt((String)info2.data_type, (int)Integer.MIN_VALUE);
            if (num == Integer.MIN_VALUE) {
                string = info2.data_type;
            } else {
                String string2 = JdbcUtil.getJdbcTypeName(num);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getJdbcTypeName(...)");
            }
            String typeName = string;
            Intrinsics.checkNotNull((Object)$this$retrieveConstants_u24lambda_u24107_u24lambda_u24106_u24lambda_u24105_u24lambda_u24104);
            DasTypeSystemBase dasTypeSystemBase = DasTypeUtilsKt.getTypeSystem($this$retrieveConstants_u24lambda_u24107_u24lambda_u24106_u24lambda_u24105_u24lambda_u24104);
            DataType dataType = DataTypeFactory.of(typeName);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            $this$retrieveConstants_u24lambda_u24107_u24lambda_u24106_u24lambda_u24105_u24lambda_u24104.setStoredType(dasTypeSystemBase.createDasType(dataType));
            $this$retrieveConstants_u24lambda_u24107_u24lambda_u24106_u24lambda_u24105_u24lambda_u24104.setValue(info2.sql);
            $this$retrieveConstants_u24lambda_u24107_u24lambda_u24106_u24lambda_u24105_u24lambda_u24104.setComment(info2.remarks);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveSynonyms$lambda$111$lambda$110$lambda$109(ModNamingFamily $synonyms, H2IntroQueries.SynonymInfo info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            Object e = $synonyms.createOrGet(info2.synonym_name);
            H2Synonym $this$retrieveSynonyms_u24lambda_u24111_u24lambda_u24110_u24lambda_u24109_u24lambda_u24108 = (H2Synonym)e;
            boolean bl = false;
            $this$retrieveSynonyms_u24lambda_u24111_u24lambda_u24110_u24lambda_u24109_u24lambda_u24108.setTargetObjectRef(BasicParentReference.create(info2.synonym_for_schema, BasicNameReference.create(info2.synonym_for)));
            $this$retrieveSynonyms_u24lambda_u24111_u24lambda_u24110_u24lambda_u24109_u24lambda_u24108.setComment(info2.remarks);
            return Unit.INSTANCE;
        }

        private static final void retrieveSourcesV2$lambda$112(H2SchemaAbstractSchemaRetriever this$0, H2Schema $schema) {
            this$0.retrieveViewSources($schema);
            this$0.retrieveTriggerSources($schema);
        }

        private static final Unit retrieveViewSources$lambda$113(H2Schema $schema, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.SourceInfo info2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                H2View h2View = (H2View)$schema.getViews().get(info2.name);
                if (h2View == null) break block0;
                String string = info2.sql;
                ((BasicModSourceAware)h2View).setSourceText(string != null ? this$0.toCompositeText(string) : null);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTriggerSources$lambda$114(HashMap $triggerMap, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.SourceInfo info2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                H2Trigger h2Trigger = (H2Trigger)$triggerMap.get(info2.name);
                if (h2Trigger == null) break block0;
                String string = info2.sql;
                h2Trigger.setSourceText(string != null ? this$0.toCompositeText(string) : null);
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$applyIndexColumns(H2SchemaAbstractSchemaRetriever $this, H2Index index, List columns) {
            $this.applyIndexColumns(index, columns);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$Interval;", "", "<init>", "(Ljava/lang/String;I)V", "YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "intellij.database.dialects.h2"})
    private static final class Interval
    extends Enum<Interval> {
        public static final /* enum */ Interval YEAR = new Interval();
        public static final /* enum */ Interval MONTH = new Interval();
        public static final /* enum */ Interval DAY = new Interval();
        public static final /* enum */ Interval HOUR = new Interval();
        public static final /* enum */ Interval MINUTE = new Interval();
        public static final /* enum */ Interval SECOND = new Interval();
        private static final /* synthetic */ Interval[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Interval[] values() {
            return (Interval[])$VALUES.clone();
        }

        public static Interval valueOf(String value) {
            return Enum.valueOf(Interval.class, value);
        }

        @NotNull
        public static EnumEntries<Interval> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = intervalArray = new Interval[]{Interval.YEAR, Interval.MONTH, Interval.DAY, Interval.HOUR, Interval.MINUTE, Interval.SECOND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

