/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.redis.RedisDbms;
import com.intellij.database.dialects.redis.RedisDvStructureExtensionKt;
import com.intellij.database.dialects.redis.RedisFolder;
import com.intellij.database.dialects.redis.RedisTree;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.HostFamily;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006\"\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"!\u0010\u0013\u001a\u0015\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00020\u00020\u0014\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"isRedis", "", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/model/basic/BasicElement;)Z", "growTree", "Lcom/intellij/database/dialects/redis/RedisTree;", "Lcom/intellij/database/model/basic/BasicNode;", "schema", "Lcom/intellij/database/model/basic/BasicSchema;", "family", "Lcom/intellij/database/model/families/HostFamily;", "delimiter", "", "getNodePath", "node", "emptyTree", "getEmptyTree", "()Lcom/intellij/database/dialects/redis/RedisTree;", "noDelimiter", "noElements", "Lcom/intellij/util/containers/JBIterable;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.dialects.redis"})
public final class RedisDvStructureExtensionKt {
    @NotNull
    private static final RedisTree<BasicNode> emptyTree = new RedisTree(SetsKt.emptySet(), "\u0000", RedisDvStructureExtensionKt::emptyTree$lambda$1, RedisDvStructureExtensionKt::emptyTree$lambda$2, (Function0<N[]>)((Function0)emptyTree.3.INSTANCE));
    @NotNull
    private static final String noDelimiter;
    @NotNull
    private static final JBIterable<BasicElement> noElements;

    public static final boolean isRedis(@NotNull BasicElement $this$isRedis) {
        Intrinsics.checkNotNullParameter((Object)$this$isRedis, (String)"<this>");
        boolean $i$f$isRedis = false;
        Object object = $this$isRedis.getModel();
        return object != null && (object = object.getDbms()) != null ? ((Dbms)object).is(RedisDbms.REDIS) : false;
    }

    @NotNull
    public static final RedisTree<BasicNode> growTree(@NotNull BasicSchema schema, @NotNull HostFamily<? extends BasicElement> family, @NotNull String delimiter) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(family, (String)"family");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        JBIterable jBIterable = family.jbi();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"jbi(...)");
        RedisTree<BasicNode> tree2 = new RedisTree<BasicNode>((Iterable)jBIterable, delimiter, growTree.tree.1.INSTANCE, (arg_0, arg_1) -> RedisDvStructureExtensionKt.growTree$lambda$0(schema, family, delimiter, arg_0, arg_1), (Function0<N[]>)((Function0)growTree.tree.3.INSTANCE));
        return tree2;
    }

    @NotNull
    public static final String getNodePath(@NotNull BasicNode node) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        if (basicNode instanceof BasicElement) {
            String string2 = ((BasicElement)node).getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        } else {
            string = basicNode instanceof RedisFolder ? ((RedisFolder)node).getPath() : "";
        }
        return string;
    }

    @NotNull
    public static final RedisTree<BasicNode> getEmptyTree() {
        return emptyTree;
    }

    private static final BasicNode growTree$lambda$0(BasicSchema $schema, HostFamily $family, String $delimiter, BasicNode parentNode, String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new RedisFolder($schema, $family, parentNode, path, $delimiter);
    }

    private static final String emptyTree$lambda$1(BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "";
    }

    private static final BasicNode emptyTree$lambda$2(BasicNode basicNode, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        throw new IllegalStateException("EmptyRedisTree cannot contain reddish");
    }

    public static final /* synthetic */ String access$getNoDelimiter$p() {
        return noDelimiter;
    }

    public static final /* synthetic */ JBIterable access$getNoElements$p() {
        return noElements;
    }

    static {
        String string = "\u0000".intern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intern(...)");
        noDelimiter = string;
        JBIterable jBIterable = JBIterable.empty();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
        noElements = jBIterable;
    }
}

