/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbTextModelState;
import com.intellij.database.schemaEditor.ui.AutoSelectListener;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbTextEditorBase;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.JBTextField;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class DbTextEditor<E extends BasicElement>
extends DbTextEditorBase<E, DbTextModelState> {
    protected final JTextField myTextField;

    public DbTextEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, DbTextModelState> model) {
        if (controller == null) {
            DbTextEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DbTextEditor.$$$reportNull$$$0(1);
        }
        super(controller, model, DbTextModelState.accessor());
        this.myTextField = this.createTextField();
        this.myTextField.setColumns(this.getFieldSize() == FieldSize.LARGE ? 20 : 7);
        this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                DbTextEditor.this.modified();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/schemaEditor/ui/DbTextEditor$1", "textChanged"));
            }
        });
        DbTextEditor.doNotHideEmptyTextOnFocus(this.myTextField);
        AutoSelectListener.INSTANCE.install(this.myTextField);
    }

    @NotNull
    protected JTextField createTextField() {
        return DbTextEditor.isPassword(this.getModelInternalKey()) ? new JBPasswordField() : new TextFieldWithEmptyText();
    }

    private static boolean isPassword(@NotNull BasicMetaId property) {
        if (property == null) {
            DbTextEditor.$$$reportNull$$$0(2);
        }
        return property instanceof BasicMetaPropertyId && ((BasicMetaPropertyId)property).type.isKindOf(OneTimeString.class) && property.name.equals("Password");
    }

    @Override
    @NotNull
    protected String getText() {
        String string = this.myTextField.getText();
        if (string == null) {
            DbTextEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected void setText(@NotNull String text2) {
        if (text2 == null) {
            DbTextEditor.$$$reportNull$$$0(4);
        }
        this.myTextField.setText(text2);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JTextField jTextField = this.myTextField;
        if (jTextField == null) {
            DbTextEditor.$$$reportNull$$$0(5);
        }
        return jTextField;
    }

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        FieldSize fieldSize = ((DbTextModelState)this.getState()).isSmall() ? FieldSize.SMALL : FieldSize.LARGE;
        if (fieldSize == null) {
            DbTextEditor.$$$reportNull$$$0(6);
        }
        return fieldSize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbTextEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbTextEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPassword";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }

    private static class TextFieldWithEmptyText
    extends JBTextField {
        private TextFieldWithEmptyText() {
        }

        public Dimension getPreferredSize() {
            Dimension s1 = super.getPreferredSize();
            if (this.getColumns() != 0) {
                return s1;
            }
            Dimension s2 = this.getEmptyText().getPreferredSize();
            return new Dimension(Math.max(s1.width, s2.width + s1.height / 2), s1.height);
        }
    }
}

