/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.testRunner;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.testing.runScope.JsTestRunScopeComponent;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.ui.PathShortener;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerLanguageSetting;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerLanguageSettingModel;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerRunConfiguration;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerRunConfigurationEditorKt;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerRunSettings;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerTypeScriptLoader;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerTypeScriptLoaderModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0014J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "interpreterField", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField;", "nodeOptionsEditor", "Lcom/intellij/ui/RawCommandLineEditor;", "Lorg/jetbrains/annotations/NotNull;", "workingDirComponent", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "envVarsComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton;", "languageModel", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerLanguageSettingModel;", "typeScriptLoaderModel", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerTypeScriptLoaderModel;", "scopeComponent", "Lcom/intellij/javascript/testing/runScope/JsTestRunScopeComponent;", "panel", "Ljavax/swing/JPanel;", "resetEditorFrom", "", "runConfiguration", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "createWorkingDirComponent", "intellij.nodeJS"})
public final class NodeJsTestRunnerRunConfigurationEditor
extends SettingsEditor<NodeJsTestRunnerRunConfiguration> {
    @NotNull
    private final NodeJsInterpreterField interpreterField;
    @NotNull
    private final RawCommandLineEditor nodeOptionsEditor;
    @NotNull
    private final TextFieldWithBrowseButton workingDirComponent;
    @NotNull
    private final EnvironmentVariablesTextFieldWithBrowseButton envVarsComponent;
    @NotNull
    private final NodeJsTestRunnerLanguageSettingModel languageModel;
    @NotNull
    private final NodeJsTestRunnerTypeScriptLoaderModel typeScriptLoaderModel;
    @NotNull
    private final JsTestRunScopeComponent scopeComponent;
    @NotNull
    private final JPanel panel;

    public NodeJsTestRunnerRunConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.interpreterField = new NodeJsInterpreterField(project);
        RawCommandLineEditor rawCommandLineEditor = new RawCommandLineEditor().withMonospaced(false);
        Intrinsics.checkNotNullExpressionValue((Object)rawCommandLineEditor, (String)"withMonospaced(...)");
        this.nodeOptionsEditor = rawCommandLineEditor;
        this.workingDirComponent = this.createWorkingDirComponent(project);
        this.envVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.languageModel = new NodeJsTestRunnerLanguageSettingModel();
        this.typeScriptLoaderModel = new NodeJsTestRunnerTypeScriptLoaderModel();
        String string = JavaScriptBundle.message((String)"rc.environmentVariables.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String envVariablesLabelText = string;
        int envVariablesLabelWidth = new JLabel((String)UIUtil.removeMnemonic((String)envVariablesLabelText)).getPreferredSize().width;
        this.scopeComponent = new JsTestRunScopeComponent(project, envVariablesLabelWidth, true);
        this.panel = (JPanel)BuilderKt.panel(arg_0 -> NodeJsTestRunnerRunConfigurationEditor._init_$lambda$8(this, envVariablesLabelText, arg_0));
    }

    protected void resetEditorFrom(@NotNull NodeJsTestRunnerRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        NodeJsTestRunnerRunSettings settings = runConfiguration.getSettings();
        this.interpreterField.setInterpreterRef(settings.getInterpreterRef());
        this.nodeOptionsEditor.setText(settings.getNodeOptions());
        this.workingDirComponent.setText(FileUtil.toSystemDependentName((String)settings.getWorkingDir()));
        this.envVarsComponent.setData(settings.getEnvData());
        this.scopeComponent.resetEditorFrom(settings.getScope());
        this.languageModel.setSelectedItem((Object)settings.getLanguage());
        this.typeScriptLoaderModel.setSelectedItem((Object)settings.getTypeScriptLoader());
    }

    protected void applyEditorTo(@NotNull NodeJsTestRunnerRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        NodeJsTestRunnerRunSettings.Builder builder = new NodeJsTestRunnerRunSettings.Builder(null, null, null, null, null, null, null, 127, null);
        builder.setInterpreterRef(this.interpreterField.getInterpreterRef());
        builder.setNodeOptions(this.nodeOptionsEditor.getText());
        builder.setWorkingDir(PathShortener.getAbsolutePath((JTextField)this.workingDirComponent.getTextField()));
        builder.setEnvData(this.envVarsComponent.getData());
        builder.setScope(this.scopeComponent.getScope());
        NodeJsTestRunnerLanguageSetting nodeJsTestRunnerLanguageSetting = (NodeJsTestRunnerLanguageSetting)((Object)this.languageModel.getSelected());
        if (nodeJsTestRunnerLanguageSetting == null) {
            nodeJsTestRunnerLanguageSetting = NodeJsTestRunnerLanguageSetting.Companion.getDEFAULT();
        }
        builder.setLanguage(nodeJsTestRunnerLanguageSetting);
        NodeJsTestRunnerTypeScriptLoader nodeJsTestRunnerTypeScriptLoader = (NodeJsTestRunnerTypeScriptLoader)((Object)this.typeScriptLoaderModel.getSelected());
        if (nodeJsTestRunnerTypeScriptLoader == null) {
            nodeJsTestRunnerTypeScriptLoader = NodeJsTestRunnerTypeScriptLoader.Companion.getDEFAULT();
        }
        builder.setTypeScriptLoader(nodeJsTestRunnerTypeScriptLoader);
        runConfiguration.setSettings(builder.build());
    }

    @NotNull
    protected JComponent createEditor() {
        return this.panel;
    }

    private final TextFieldWithBrowseButton createWorkingDirComponent(Project project) {
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        PathShortener.enablePathShortening((JTextField)textFieldWithBrowseButton.getTextField(), null);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(JavaScriptBundle.message((String)"rc.workingDirectory.browseDialogTitle", (Object[])new Object[0]));
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (FileChooserDescriptor)descriptor);
        return textFieldWithBrowseButton;
    }

    private static final Unit lambda$8$lambda$0(NodeJsTestRunnerRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.interpreterField).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$8$lambda$1(NodeJsTestRunnerRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)((Object)this$0.languageModel)), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$8$lambda$2(NodeJsTestRunnerRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)((Object)this$0.typeScriptLoaderModel)), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final boolean lambda$8$lambda$3(NodeJsTestRunnerLanguageSetting it) {
        return it == NodeJsTestRunnerLanguageSetting.TYPE_SCRIPT;
    }

    private static final Unit lambda$8$lambda$4(NodeJsTestRunnerRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.nodeOptionsEditor).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$8$lambda$5(NodeJsTestRunnerRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.workingDirComponent).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$8$lambda$6(NodeJsTestRunnerRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.envVarsComponent).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$8$lambda$7(NodeJsTestRunnerRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell(this$0.scopeComponent.getComponent()).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(NodeJsTestRunnerRunConfigurationEditor this$0, String $envVariablesLabelText, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = NodeJsInterpreterField.getLabelTextForComponent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLabelTextForComponent(...)");
        $this$panel.row(string, arg_0 -> NodeJsTestRunnerRunConfigurationEditor.lambda$8$lambda$0(this$0, arg_0));
        String string2 = NodeJSBundle.message("rc.nodejs.test.runner.language_setting", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> NodeJsTestRunnerRunConfigurationEditor.lambda$8$lambda$1(this$0, arg_0));
        String string3 = NodeJSBundle.message("rc.nodejs.test.runner.type_script_loader", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(string3, arg_0 -> NodeJsTestRunnerRunConfigurationEditor.lambda$8$lambda$2(this$0, arg_0)).visibleIf((ObservableProperty)NodeJsTestRunnerRunConfigurationEditorKt.selectedItemMatches$default((ComboBoxModel)((Object)this$0.languageModel), null, NodeJsTestRunnerRunConfigurationEditor::lambda$8$lambda$3, 1, null));
        String string4 = JavaScriptBundle.message((String)"rc.nodeOptions.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        $this$panel.row(string4, arg_0 -> NodeJsTestRunnerRunConfigurationEditor.lambda$8$lambda$4(this$0, arg_0));
        String string5 = JavaScriptBundle.message((String)"rc.workingDirectory.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        $this$panel.row(string5, arg_0 -> NodeJsTestRunnerRunConfigurationEditor.lambda$8$lambda$5(this$0, arg_0));
        $this$panel.row($envVariablesLabelText, arg_0 -> NodeJsTestRunnerRunConfigurationEditor.lambda$8$lambda$6(this$0, arg_0));
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> NodeJsTestRunnerRunConfigurationEditor.lambda$8$lambda$7(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }
}

