/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.localization.editor;

import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.localization.LocaleTokenTypes;
import java.util.Arrays;

public final class LocaleQuoteHandler
extends SimpleTokenSetQuoteHandler {
    private final char[] ourAutoClosingChars = new char[]{' ', '\t', '\n'};

    public LocaleQuoteHandler() {
        super(TokenSet.create((IElementType[])new IElementType[]{LocaleTokenTypes.STRING_LITERAL}));
        Arrays.sort(this.ourAutoClosingChars);
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        Document document = iterator.getDocument();
        if (document == null) {
            return false;
        }
        CharSequence text = document.getCharsSequence();
        if (offset + 1 >= text.length() || Arrays.binarySearch(this.ourAutoClosingChars, text.charAt(offset + 1)) >= 0) {
            int start;
            if (super.isOpeningQuote(iterator, offset)) {
                return true;
            }
            if (this.myLiteralTokenSet.contains(iterator.getTokenType()) && offset - (start = iterator.getStart()) == 0) {
                return true;
            }
        }
        return false;
    }

    protected boolean isNonClosedLiteral(HighlighterIterator iterator, CharSequence chars) {
        if (iterator.getStart() >= iterator.getEnd() - 1) {
            return true;
        }
        return chars.charAt(iterator.getEnd() - 1) != '\"' && chars.charAt(iterator.getEnd() - 1) != '\'';
    }
}

