/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.VcsInternalDataKeys;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vcs.history.DetailsPanel;
import com.intellij.openapi.vcs.history.FileHistoryColumnWrapper;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.TreeNodeOnVcsRevision;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.dualView.CellWrapper;
import com.intellij.ui.dualView.DualView;
import com.intellij.ui.dualView.DualViewColumnInfo;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.TreeItem;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileHistoryPanelImpl
extends JPanel
implements UiDataProvider,
Disposable,
EditorColorsListener,
CopyProvider {
    public static final DataKey<VcsFileRevision> PREVIOUS_REVISION_FOR_DIFF = DataKey.create((String)"PREVIOUS_VCS_FILE_REVISION_FOR_DIFF");
    @Language(value="devkit-action-id")
    private static final String VCS_HISTORY_POPUP_ACTION_GROUP = "VcsHistoryInternalGroup.Popup";
    @Language(value="devkit-action-id")
    private static final String VCS_HISTORY_TOOLBAR_ACTION_GROUP = "VcsHistoryInternalGroup.Toolbar";
    @Language(value="devkit-action-id")
    private static final String VCS_HISTORY_POPUP_PLUGIN_ACTION_GROUP = "VcsHistoryActionsGroup";
    @Language(value="devkit-action-id")
    private static final String VCS_HISTORY_TOOLBAR_PLUGIN_ACTION_GROUP = "VcsHistoryActionsGroup.Toolbar";
    private final String myHelpId;
    @NotNull
    private final AbstractVcs myVcs;
    private final VcsHistoryProvider myProvider;
    @NotNull
    private final FileHistoryRefresherI myRefresherI;
    @NotNull
    private final FilePath myFilePath;
    @Nullable
    private final VcsRevisionNumber myStartingRevision;
    @NotNull
    private final Map<VcsRevisionNumber, Integer> myRevisionsOrder;
    @NotNull
    private final Map<VcsFileRevision, VirtualFile> myRevisionToVirtualFile;
    @NotNull
    private final DetailsPanel myDetails;
    @NotNull
    private final DualView myDualView;
    @Nullable
    private final JComponent myAdditionalDetails;
    @Nullable
    private final Consumer<VcsFileRevision> myRevisionSelectionListener;
    @NotNull
    private VcsHistorySession myHistorySession;
    private VcsFileRevision myBottomRevisionForShowDiff;
    private List<Object> myTargetSelection;
    private boolean myIsStaticAndEmbedded;
    private Splitter myDetailsSplitter;
    private Splitter mySplitter;

    public FileHistoryPanelImpl(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsHistorySession session, VcsHistoryProvider provider, @NotNull FileHistoryRefresherI refresherI, boolean isStaticEmbedded) {
        if (vcs == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(1);
        }
        if (session == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(2);
        }
        if (refresherI == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(3);
        }
        this(vcs, filePath, null, session, provider, refresherI, isStaticEmbedded);
    }

    public FileHistoryPanelImpl(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @Nullable VcsRevisionNumber startingRevision, @NotNull VcsHistorySession session, VcsHistoryProvider provider, @NotNull FileHistoryRefresherI refresherI, boolean isStaticEmbedded) {
        if (vcs == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(4);
        }
        if (filePath == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(5);
        }
        if (session == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(6);
        }
        if (refresherI == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(7);
        }
        super(new BorderLayout());
        this.myRevisionsOrder = new HashMap<VcsRevisionNumber, Integer>();
        this.myRevisionToVirtualFile = new HashMap<VcsFileRevision, VirtualFile>();
        this.myHelpId = provider.getHelpId() != null ? provider.getHelpId() : "reference.versionControl.toolwindow.history";
        this.myIsStaticAndEmbedded = false;
        this.myVcs = vcs;
        this.myProvider = provider;
        this.myRefresherI = refresherI;
        this.myHistorySession = session;
        this.myFilePath = filePath;
        this.myStartingRevision = startingRevision;
        this.myDetails = new DetailsPanel(vcs.getProject());
        this.refreshRevisionsOrder();
        VcsDependentHistoryComponents components = provider.getUICustomization(session, (JComponent)this);
        this.myAdditionalDetails = components.getDetailsComponent();
        this.myRevisionSelectionListener = components.getRevisionListener();
        DualViewColumnInfo[] columns = this.createColumnList(vcs.getProject(), provider, components.getColumns());
        @NonNls String storageKey = "FileHistory." + provider.getClass().getName();
        HistoryAsTreeProvider treeHistoryProvider = this.myHistorySession.getHistoryAsTreeProvider();
        if (treeHistoryProvider != null) {
            this.myDualView = new DualView((Object)new TreeNodeOnVcsRevision(null, treeHistoryProvider.createTreeOn(this.myHistorySession.getRevisionList())), columns, storageKey, this.myVcs.getProject());
        } else {
            this.myDualView = new DualView((Object)new TreeNodeOnVcsRevision(null, ContainerUtil.map((Collection)this.myHistorySession.getRevisionList(), TreeItem::new)), columns, storageKey, this.myVcs.getProject());
            this.myDualView.switchToTheFlatMode();
        }
        TableSpeedSearch.installOn((JTable)this.myDualView.getFlatView()).setComparator(new SpeedSearchComparator(false));
        TableLinkMouseListener listener2 = new TableLinkMouseListener();
        listener2.installOn((Component)this.myDualView.getFlatView());
        listener2.installOn((Component)this.myDualView.getTreeView());
        this.myDualView.setEmptyText(CommonBundle.getLoadingTreeNodeText());
        this.setupDualView(this.fillActionGroup(true, new DefaultActionGroup()));
        if (isStaticEmbedded) {
            this.setIsStaticAndEmbedded(true);
        }
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        this.fillActionGroup(false, toolbarGroup);
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar toolbar = actionManager.createActionToolbar("FileHistoryViewToolbar", (ActionGroup)toolbarGroup, isStaticEmbedded);
        JComponent centerPanel = this.createCenterPanel();
        toolbar.setTargetComponent(centerPanel);
        for (AnAction action : toolbarGroup.getChildren(actionManager)) {
            action.registerCustomShortcutSet(action.getShortcutSet(), centerPanel);
        }
        JPanel mainPanel = new JPanel(new BorderLayout());
        EditorNotificationPanel notificationLabel = components.getNotificationPanel();
        if (notificationLabel != null) {
            notificationLabel.setBorder((Border)new CompoundBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)1, (int)1, (int)1), (Border)ObjectUtils.notNull((Object)notificationLabel.getBorder(), (Object)JBUI.Borders.empty())));
            mainPanel.add((Component)notificationLabel, "North");
        }
        mainPanel.add((Component)centerPanel, "Center");
        this.add((Component)mainPanel, "Center");
        this.add((Component)toolbar.getComponent(), isStaticEmbedded ? "North" : "West");
        this.chooseView();
        Disposer.register((Disposable)vcs.getProject(), (Disposable)this);
    }

    private static void makeBold(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Font font = jComponent.getFont();
            if (font != null) {
                jComponent.setFont(font.deriveFont(1));
            }
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                FileHistoryPanelImpl.makeBold(container.getComponent(i));
            }
        }
    }

    @Nls
    @NotNull
    public static String getPresentableText(@NotNull VcsFileRevision revision, boolean withMessage) {
        if (revision == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(8);
        }
        @Nls StringBuilder sb = new StringBuilder();
        long time = revision.getRevisionDate().getTime();
        sb.append(VcsBundle.message((String)"file.history.details.hash.author.on.date.at.time", (Object[])new Object[]{VcsUtil.getShortRevisionString((VcsRevisionNumber)revision.getRevisionNumber()), revision.getAuthor(), DateFormatUtil.formatDate((long)time), DateFormatUtil.formatTime((long)time)}));
        if (revision instanceof VcsFileRevisionEx && !Objects.equals(revision.getAuthor(), ((VcsFileRevisionEx)revision).getCommitterName())) {
            sb.append(" (").append(VcsBundle.message((String)"file.history.details.committer.info", (Object[])new Object[]{((VcsFileRevisionEx)revision).getCommitterName()})).append(")");
        }
        if (withMessage) {
            sb.append(" ").append(MessageColumnInfo.getSubject(revision));
        }
        String string = sb.toString();
        if (string == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    static boolean sameHistories(@NotNull FileHistoryPanelImpl historyPanel, @NotNull FilePath filePath2, @Nullable VcsRevisionNumber startingRevision2) {
        if (historyPanel == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(10);
        }
        if (filePath2 == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(11);
        }
        return FileHistoryPanelImpl.sameHistories(historyPanel.myFilePath, historyPanel.myStartingRevision, filePath2, startingRevision2);
    }

    public static boolean sameHistories(@NotNull FilePath filePath1, @Nullable VcsRevisionNumber startingRevision1, @NotNull FilePath filePath2, @Nullable VcsRevisionNumber startingRevision2) {
        if (filePath1 == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(12);
        }
        if (filePath2 == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(13);
        }
        String existingRevision = startingRevision1 == null ? null : startingRevision1.asString();
        String newRevision = startingRevision2 == null ? null : startingRevision2.asString();
        return filePath1.equals(filePath2) && Objects.equals(existingRevision, newRevision);
    }

    private DualViewColumnInfo @NotNull [] createColumnList(@NotNull Project project, @NotNull VcsHistoryProvider provider, ColumnInfo @Nullable [] additionalColumns) {
        if (project == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(14);
        }
        if (provider == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(15);
        }
        ArrayList columns = new ArrayList();
        columns.add(new TreeNodeColumnInfoWrapper<VcsRevisionNumber>(new RevisionColumnInfo(Comparator.comparing(revision -> this.myRevisionsOrder.get(revision.getRevisionNumber()), Comparator.reverseOrder()))));
        if (!provider.isDateOmittable()) {
            columns.add(new TreeNodeColumnInfoWrapper<Date>(new DateColumnInfo()));
        }
        columns.add(new TreeNodeColumnInfoWrapper<String>(new AuthorColumnInfo()));
        if (additionalColumns != null) {
            for (ColumnInfo additionalColumn : additionalColumns) {
                columns.add(new TreeNodeColumnInfoWrapper(additionalColumn));
            }
        }
        columns.add(new TreeNodeColumnInfoWrapper<String>(new MessageColumnInfo(project)));
        DualViewColumnInfo[] dualViewColumnInfoArray = columns.toArray(new DualViewColumnInfo[0]);
        if (dualViewColumnInfoArray == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(16);
        }
        return dualViewColumnInfoArray;
    }

    @RequiresEdt
    public void setHistorySession(@NotNull VcsHistorySession session) {
        if (session == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(17);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myTargetSelection == null) {
            this.myTargetSelection = this.myDualView.getFlatView().getSelectedObjects();
        }
        this.myHistorySession = session;
        this.refreshRevisionsOrder();
        HistoryAsTreeProvider treeHistoryProvider = session.getHistoryAsTreeProvider();
        if (this.myHistorySession.getRevisionList().isEmpty()) {
            this.adjustEmptyText();
        }
        if (treeHistoryProvider != null) {
            this.myDualView.setRoot((TreeNode)new TreeNodeOnVcsRevision(null, treeHistoryProvider.createTreeOn(this.myHistorySession.getRevisionList())), this.myTargetSelection);
        } else {
            this.myDualView.setRoot((TreeNode)new TreeNodeOnVcsRevision(null, ContainerUtil.map((Collection)this.myHistorySession.getRevisionList(), TreeItem::new)), this.myTargetSelection);
        }
        this.mySplitter.revalidate();
        this.mySplitter.repaint();
        this.myDualView.expandAll();
        this.myDualView.repaint();
    }

    @RequiresEdt
    public void finishRefresh() {
        TreeTableView treeView;
        int lastRow;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myHistorySession.getHistoryAsTreeProvider() != null && (lastRow = (treeView = this.myDualView.getTreeView()).getRowCount() - 1) >= 0) {
            treeView.scrollRectToVisible(treeView.getCellRect(lastRow, 0, true));
        }
        this.myTargetSelection = null;
        this.mySplitter.revalidate();
        this.mySplitter.repaint();
    }

    private void adjustEmptyText() {
        VirtualFile virtualFile = this.myFilePath.getVirtualFile();
        if (!(virtualFile != null && virtualFile.isValid() || this.myFilePath.getIOFile().exists())) {
            this.myDualView.setEmptyText(VcsBundle.message((String)"history.file.not.found", (Object[])new Object[]{this.myFilePath.getName()}));
        } else if (VcsCachingHistory.getHistoryLock(this.myVcs, VcsBackgroundableActions.CREATE_HISTORY_SESSION, this.myFilePath, this.myStartingRevision).isLocked()) {
            this.myDualView.setEmptyText(CommonBundle.getLoadingTreeNodeText());
        } else {
            this.myDualView.setEmptyText(StatusText.getDefaultEmptyText());
        }
    }

    private void setupDualView(@NotNull DefaultActionGroup group) {
        if (group == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(18);
        }
        this.myDualView.setShowGrid(true);
        PopupHandler.installPopupMenu((JComponent)this.myDualView.getTreeView(), (ActionGroup)group, (String)"UpdatePopup");
        PopupHandler.installPopupMenu((JComponent)this.myDualView.getFlatView(), (ActionGroup)group, (String)"UpdatePopup");
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myDualView, true));
        this.myDualView.addListSelectionListener(e -> this.updateMessage());
        this.myDualView.setRootVisible(false);
        this.myDualView.expandAll();
        this.myDualView.setTreeCellRenderer((TreeCellRenderer)new MyTreeCellRenderer(this.myDualView.getTree().getCellRenderer(), () -> this.myHistorySession));
        this.myDualView.setCellWrapper((CellWrapper)new MyCellWrapper(() -> this.myHistorySession));
        this.myDualView.installDoubleClickHandler(ActionUtil.wrap((String)"Diff.ShowDiff"));
        this.myDualView.getFlatView().getTableViewModel().setSortable(true);
        RowSorter rowSorter = this.myDualView.getFlatView().getRowSorter();
        if (rowSorter != null) {
            rowSorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.DESCENDING)));
        }
    }

    private void updateMessage() {
        List selection = this.myDualView.getSelection();
        this.myDetails.update(selection);
        if (selection.isEmpty()) {
            return;
        }
        if (this.myRevisionSelectionListener != null) {
            this.myRevisionSelectionListener.consume((Object)((TreeNodeOnVcsRevision)selection.get(0)).getRevision());
        }
    }

    @NotNull
    private JComponent createCenterPanel() {
        this.mySplitter = new OnePixelSplitter(true, "vcs.history.splitter.proportion", 0.6f);
        this.mySplitter.setFirstComponent((JComponent)this.myDualView);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myDetails);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)1));
        this.myDetailsSplitter = new OnePixelSplitter(false, "vcs.history.details.splitter.proportion", 0.5f);
        this.myDetailsSplitter.setFirstComponent((JComponent)scrollPane);
        this.myDetailsSplitter.setSecondComponent(this.myAdditionalDetails);
        this.setupDetails();
        Splitter splitter = this.mySplitter;
        if (splitter == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(19);
        }
        return splitter;
    }

    private void setupDetails() {
        boolean showDetails = !this.myIsStaticAndEmbedded && VcsConfiguration.getInstance((Project)this.myVcs.getProject()).SHOW_FILE_HISTORY_DETAILS;
        this.myDualView.setViewBorder(IdeBorderFactory.createBorder((int)1));
        this.mySplitter.setSecondComponent((JComponent)(showDetails ? this.myDetailsSplitter : null));
    }

    private void chooseView() {
        if (VcsConfiguration.getInstance((Project)this.myVcs.getProject()).SHOW_FILE_HISTORY_AS_TREE) {
            this.myDualView.switchToTheTreeMode();
        } else {
            this.myDualView.switchToTheFlatMode();
        }
    }

    @NotNull
    private DefaultActionGroup fillActionGroup(boolean popup, DefaultActionGroup result2) {
        if (popup) {
            result2.add(ActionManager.getInstance().getAction("EditSource"));
        }
        result2.add(ActionManager.getInstance().getAction(popup ? VCS_HISTORY_POPUP_ACTION_GROUP : VCS_HISTORY_TOOLBAR_ACTION_GROUP));
        AnAction[] additionalActions = this.myProvider.getAdditionalActions(() -> ApplicationManager.getApplication().invokeAndWait(() -> this.myRefresherI.refresh(true)));
        if (additionalActions != null) {
            for (AnAction additionalAction : additionalActions) {
                if (!popup && additionalAction.getTemplatePresentation().getIcon() == null) continue;
                result2.add(additionalAction);
            }
        }
        result2.add(ActionManager.getInstance().getAction(popup ? VCS_HISTORY_POPUP_PLUGIN_ACTION_GROUP : VCS_HISTORY_TOOLBAR_PLUGIN_ACTION_GROUP));
        if (!this.myIsStaticAndEmbedded) {
            result2.add((AnAction)new MyShowDetailsAction());
        }
        if (!popup && this.myHistorySession.getHistoryAsTreeProvider() != null) {
            result2.add((AnAction)new MyShowAsTreeAction());
        }
        DefaultActionGroup defaultActionGroup = result2;
        if (defaultActionGroup == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(20);
        }
        return defaultActionGroup;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(21);
        }
        Object[] selectedRevisions = this.getSelectedRevisions();
        sink.lazy(CommonDataKeys.NAVIGATABLE, () -> this.lambda$uiDataSnapshot$7((VcsFileRevision[])selectedRevisions));
        sink.set(CommonDataKeys.PROJECT, (Object)this.myVcs.getProject());
        sink.set(VcsDataKeys.VCS_FILE_REVISION, (Object)((VcsFileRevision)ArrayUtil.getFirstElement((Object[])this.getSelectedRevisions())));
        sink.set(VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION, (Object)(!this.myHistorySession.hasLocalSource() ? 1 : 0));
        sink.set(VcsDataKeys.VCS, (Object)this.myVcs.getKeyInstanceMethod());
        sink.set(VcsDataKeys.VCS_FILE_REVISIONS, (Object)this.getSelectedRevisions());
        sink.set(VcsDataKeys.REMOTE_HISTORY_CHANGED_LISTENER, s -> this.myDualView.rebuild());
        sink.set(VcsDataKeys.CHANGES, (Object)this.getChanges());
        sink.set(VcsDataKeys.VCS_VIRTUAL_FILE, selectedRevisions.length == 0 ? null : this.createVirtualFileForRevision((VcsFileRevision)ArrayUtil.getFirstElement((Object[])selectedRevisions)));
        sink.set(VcsDataKeys.FILE_PATH, (Object)this.myFilePath);
        sink.lazy(CommonDataKeys.VIRTUAL_FILE, () -> {
            VirtualFile virtualFile = this.myFilePath.getVirtualFile();
            return virtualFile == null || !virtualFile.isValid() ? null : virtualFile;
        });
        sink.set(VcsDataKeys.HISTORY_SESSION, (Object)this.myHistorySession);
        sink.set(VcsDataKeys.HISTORY_PROVIDER, (Object)this.myProvider);
        sink.set(PlatformDataKeys.COPY_PROVIDER, (Object)this);
        TableView flatView = this.myDualView.getFlatView();
        sink.set(PREVIOUS_REVISION_FOR_DIFF, (Object)(flatView.getSelectedRow() == flatView.getRowCount() - 1 ? (this.myBottomRevisionForShowDiff != null ? this.myBottomRevisionForShowDiff : VcsFileRevision.NULL) : ((TreeNodeOnVcsRevision)flatView.getRow(flatView.getSelectedRow() + 1)).getRevision()));
        sink.set(VcsInternalDataKeys.FILE_HISTORY_REFRESHER, (Object)this.myRefresherI);
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)this.myHelpId);
    }

    private Change @Nullable [] getChanges() {
        VcsFileRevision[] revisions = this.getSelectedRevisions();
        if (revisions.length > 0) {
            Arrays.sort(revisions, Comparator.comparing(VcsRevisionDescription::getRevisionNumber));
            for (VcsFileRevision revision : revisions) {
                if (this.myHistorySession.isContentAvailable(revision)) continue;
                return null;
            }
            LoadedContentRevision startRevision = new LoadedContentRevision(this.myFilePath, revisions[0], this.myVcs.getProject());
            Object endRevision = revisions.length == 1 ? new CurrentContentRevision(this.myFilePath) : new LoadedContentRevision(this.myFilePath, revisions[revisions.length - 1], this.myVcs.getProject());
            return new Change[]{new Change((ContentRevision)startRevision, (ContentRevision)endRevision)};
        }
        return null;
    }

    private VirtualFile createVirtualFileForRevision(VcsFileRevision revision) {
        if (!this.myRevisionToVirtualFile.containsKey(revision)) {
            FilePath filePath = revision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)revision).getPath() : this.myFilePath;
            this.myRevisionToVirtualFile.put(revision, filePath.isDirectory() ? new VcsVirtualFolder(filePath, null) : new VcsVirtualFile(filePath, revision));
        }
        return this.myRevisionToVirtualFile.get(revision);
    }

    public VcsFileRevision @NotNull [] getSelectedRevisions() {
        List selection = this.myDualView.getSelection();
        VcsFileRevision[] result2 = new VcsFileRevision[selection.size()];
        for (int i = 0; i < selection.size(); ++i) {
            result2[i] = ((TreeNodeOnVcsRevision)selection.get(i)).getRevision();
        }
        if (result2 == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(22);
        }
        return result2;
    }

    public void dispose() {
        this.myDualView.dispose();
    }

    private void refreshRevisionsOrder() {
        List list = this.myHistorySession.getRevisionList();
        this.myRevisionsOrder.clear();
        int cnt = 0;
        for (VcsFileRevision revision : list) {
            this.myRevisionsOrder.put(revision.getRevisionNumber(), cnt);
            ++cnt;
        }
    }

    public void setIsStaticAndEmbedded(boolean isStaticAndEmbedded) {
        this.myIsStaticAndEmbedded = isStaticAndEmbedded;
        this.myDualView.setZipByHeight(isStaticAndEmbedded);
        this.myDualView.getFlatView().updateColumnSizes();
        if (this.myIsStaticAndEmbedded) {
            this.myDualView.getFlatView().getTableHeader().setBorder(IdeBorderFactory.createBorder((int)2));
            this.myDualView.getTreeView().getTableHeader().setBorder(IdeBorderFactory.createBorder((int)2));
            this.myDualView.getFlatView().setBorder(null);
            this.myDualView.getTreeView().setBorder(null);
        }
    }

    public void setBottomRevisionForShowDiff(VcsFileRevision bottomRevisionForShowDiff) {
        this.myBottomRevisionForShowDiff = bottomRevisionForShowDiff;
    }

    public boolean equals(Object obj) {
        return obj instanceof FileHistoryPanelImpl && FileHistoryPanelImpl.sameHistories((FileHistoryPanelImpl)obj, this.myFilePath, this.myStartingRevision);
    }

    public int hashCode() {
        int result2 = this.myFilePath.hashCode();
        result2 = 31 * result2 + (this.myStartingRevision != null ? this.myStartingRevision.asString().hashCode() : 0);
        return result2;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(23);
        }
        String text = StringUtil.join((Object[])this.getSelectedRevisions(), revision -> FileHistoryPanelImpl.getPresentableText(revision, true), (String)"\n");
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(24);
        }
        return actionUpdateThread;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(25);
        }
        return !this.myDualView.getSelection().isEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            FileHistoryPanelImpl.$$$reportNull$$$0(26);
        }
        return true;
    }

    public void globalSchemeChange(EditorColorsScheme scheme) {
        this.updateMessage();
    }

    @NlsContexts.ColumnName
    private static String getCommitMessageTitle() {
        return VcsBundle.message((String)"label.selected.revision.commit.message", (Object[])new Object[0]);
    }

    private /* synthetic */ Navigatable lambda$uiDataSnapshot$7(VcsFileRevision[] selectedRevisions) {
        if (selectedRevisions.length != 1) {
            return null;
        }
        VcsFileRevision firstSelectedRevision = (VcsFileRevision)ArrayUtil.getFirstElement((Object[])selectedRevisions);
        if (!this.myHistorySession.isContentAvailable(firstSelectedRevision)) {
            return null;
        }
        VirtualFile virtualFileForRevision = this.createVirtualFileForRevision(firstSelectedRevision);
        if (virtualFileForRevision != null) {
            return new OpenFileDescriptor(this.myVcs.getProject(), virtualFileForRevision);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 16, 19, 20, 22, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresherI";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 9: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyPanel";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnList";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "fillActionGroup";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRevisions";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 9: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sameHistories";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createColumnList";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setHistorySession";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setupDualView";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 16, 19, 20, 22, 24 -> new IllegalStateException(string);
        };
    }

    public static class MessageColumnInfo
    extends ColumnInfo<VcsFileRevision, String> {
        private final ColoredTableCellRenderer myRenderer = new BaseHistoryCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setOpaque(selected);
                if (value instanceof String) {
                    @NlsSafe String message = (String)value;
                    myIssueLinkRenderer.appendTextWithLinks(message, this.getDefaultAttributes());
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MessageColumnInfo$1", "customizeCellRenderer"));
            }
        };
        private final IssueLinkRenderer myIssueLinkRenderer;

        public MessageColumnInfo(Project project) {
            super(FileHistoryPanelImpl.getCommitMessageTitle());
            this.myIssueLinkRenderer = new IssueLinkRenderer(project, (SimpleColoredComponent)this.myRenderer);
        }

        @NotNull
        public static String getSubject(@NotNull VcsFileRevision object) {
            String originalMessage;
            if (object == null) {
                MessageColumnInfo.$$$reportNull$$$0(0);
            }
            if ((originalMessage = object.getCommitMessage()) == null) {
                return "";
            }
            int index = StringUtil.indexOfAny((String)originalMessage, (String)"\n\r");
            String string = index == -1 ? originalMessage : originalMessage.substring(0, index);
            if (string == null) {
                MessageColumnInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String valueOf(VcsFileRevision revision) {
            return MessageColumnInfo.getSubject(revision);
        }

        public String getPreferredStringValue() {
            return StringUtil.repeatSymbol((char)'m', (int)80);
        }

        @Nullable
        public TableCellRenderer getRenderer(VcsFileRevision revision) {
            return this.myRenderer;
        }

        @NotNull
        public Comparator<VcsFileRevision> getComparator() {
            Comparator<VcsFileRevision> comparator = Comparator.comparing(revision -> this.valueOf((VcsFileRevision)revision));
            if (comparator == null) {
                MessageColumnInfo.$$$reportNull$$$0(2);
            }
            return comparator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MessageColumnInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MessageColumnInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubject";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private class TreeNodeColumnInfoWrapper<T extends Comparable<T>>
    extends FileHistoryColumnWrapper<T> {
        TreeNodeColumnInfoWrapper(ColumnInfo<VcsFileRevision, T> additionalColumn) {
            if (additionalColumn == null) {
                TreeNodeColumnInfoWrapper.$$$reportNull$$$0(0);
            }
            super(additionalColumn);
        }

        @Override
        protected DualView getDualView() {
            return FileHistoryPanelImpl.this.myDualView;
        }

        public TableCellRenderer getCustomizedRenderer(TreeNodeOnVcsRevision revision, @Nullable TableCellRenderer renderer) {
            if (renderer instanceof BaseHistoryCellRenderer) {
                ((BaseHistoryCellRenderer)((Object)renderer)).setCurrentRevision(FileHistoryPanelImpl.this.myHistorySession.isCurrentRevision(revision.getRevision().getRevisionNumber()));
            }
            return renderer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalColumn", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$TreeNodeColumnInfoWrapper", "<init>"));
        }
    }

    public static class RevisionColumnInfo
    extends ColumnInfo<VcsFileRevision, VcsRevisionNumber> {
        @Nullable
        private final Comparator<VcsFileRevision> myComparator;
        @NotNull
        private final ColoredTableCellRenderer myRenderer;

        public RevisionColumnInfo(@Nullable Comparator<VcsFileRevision> comparator) {
            super(VcsBundle.message((String)"column.name.revision.version", (Object[])new Object[0]));
            this.myComparator = comparator;
            this.myRenderer = new BaseHistoryCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.setOpaque(selected);
                    this.append(VcsUtil.getShortRevisionString((VcsRevisionNumber)((VcsRevisionNumber)value)), this.getDefaultAttributes());
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$RevisionColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }

        @Nullable
        public VcsRevisionNumber valueOf(VcsFileRevision revision) {
            return revision.getRevisionNumber();
        }

        @Nullable
        public Comparator<VcsFileRevision> getComparator() {
            return this.myComparator;
        }

        public String getPreferredStringValue() {
            return StringUtil.repeatSymbol((char)'m', (int)10);
        }

        @Nullable
        public TableCellRenderer getRenderer(VcsFileRevision revision) {
            return this.myRenderer;
        }
    }

    public static class DateColumnInfo
    extends ColumnInfo<VcsFileRevision, Date> {
        @NotNull
        private final ColoredTableCellRenderer myRenderer = new BaseHistoryCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setOpaque(selected);
                Date date = (Date)value;
                if (date != null) {
                    this.append(DateFormatUtil.formatPrettyDateTime((Date)date), this.getDefaultAttributes());
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$DateColumnInfo$1", "customizeCellRenderer"));
            }
        };

        public DateColumnInfo() {
            super(VcsBundle.message((String)"column.name.revision.date", (Object[])new Object[0]));
        }

        @NotNull
        public Comparator<VcsFileRevision> getComparator() {
            Comparator<VcsFileRevision> comparator = Comparator.comparing(revision -> this.valueOf((VcsFileRevision)revision));
            if (comparator == null) {
                DateColumnInfo.$$$reportNull$$$0(0);
            }
            return comparator;
        }

        @Nullable
        public Date valueOf(VcsFileRevision revision) {
            return revision.getRevisionDate();
        }

        public String getPreferredStringValue() {
            return DateFormatUtil.formatDateTime((long)(Clock.getTime() + 1000L));
        }

        @Nullable
        public TableCellRenderer getRenderer(VcsFileRevision revision) {
            return this.myRenderer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$DateColumnInfo", "getComparator"));
        }
    }

    public static class AuthorColumnInfo
    extends ColumnInfo<VcsFileRevision, String> {
        private final TableCellRenderer AUTHOR_RENDERER = new AuthorCellRenderer();

        public AuthorColumnInfo() {
            super(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0]));
        }

        @Nullable
        public TableCellRenderer getRenderer(VcsFileRevision revision) {
            return this.AUTHOR_RENDERER;
        }

        public TableCellRenderer getCustomizedRenderer(VcsFileRevision revision, TableCellRenderer renderer) {
            if (renderer instanceof AuthorCellRenderer && revision instanceof VcsFileRevisionEx) {
                VcsFileRevisionEx ex = (VcsFileRevisionEx)revision;
                @Nls StringBuilder sb = new StringBuilder(StringUtil.notNullize((String)ex.getAuthor()));
                if (ex.getAuthorEmail() != null) {
                    sb.append(" &lt;").append(ex.getAuthorEmail()).append("&gt;");
                }
                if (ex.getCommitterName() != null && !Objects.equals(ex.getAuthor(), ex.getCommitterName())) {
                    sb.append(", ").append(VcsBundle.message((String)"file.history.details.committer.tooltip.info", (Object[])new Object[]{ex.getCommitterName()}));
                    if (ex.getCommitterEmail() != null) {
                        sb.append(" &lt;").append(ex.getCommitterEmail()).append("&gt;");
                    }
                }
                ((AuthorCellRenderer)((Object)renderer)).setTooltipText(sb.toString());
            }
            return renderer;
        }

        @Nullable
        public String valueOf(VcsFileRevision revision) {
            if (revision instanceof VcsFileRevisionEx && !Objects.equals(revision.getAuthor(), ((VcsFileRevisionEx)revision).getCommitterName())) {
                return revision.getAuthor() + "*";
            }
            return revision.getAuthor();
        }

        @NonNls
        public String getPreferredStringValue() {
            return StringUtil.repeatSymbol((char)'m', (int)14);
        }

        @NotNull
        public Comparator<VcsFileRevision> getComparator() {
            Comparator<VcsFileRevision> comparator = Comparator.comparing(revision -> this.valueOf((VcsFileRevision)revision));
            if (comparator == null) {
                AuthorColumnInfo.$$$reportNull$$$0(0);
            }
            return comparator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$AuthorColumnInfo", "getComparator"));
        }
    }

    private static final class MyTreeCellRenderer
    implements TreeCellRenderer {
        private final TreeCellRenderer myDefaultCellRenderer;
        private final Supplier<? extends VcsHistorySession> myHistorySession;

        MyTreeCellRenderer(TreeCellRenderer defaultCellRenderer, Supplier<? extends VcsHistorySession> historySession) {
            this.myDefaultCellRenderer = defaultCellRenderer;
            this.myHistorySession = historySession;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TreeNodeOnVcsRevision node;
            Component result2 = this.myDefaultCellRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            TreePath path = tree.getPathForRow(row);
            if (path == null) {
                return result2;
            }
            TreeNodeOnVcsRevision treeNodeOnVcsRevision = node = row >= 0 ? (TreeNodeOnVcsRevision)path.getLastPathComponent() : null;
            if (node != null) {
                if (this.myHistorySession.get().isCurrentRevision(node.getRevision().getRevisionNumber())) {
                    FileHistoryPanelImpl.makeBold(result2);
                }
                if (!selected && this.myHistorySession.get().isCurrentRevision(node.getRevision().getRevisionNumber())) {
                    result2.setBackground((Color)new JBColor(new Color(188, 227, 231), new Color(188, 227, 231)));
                }
                ((JComponent)result2).setOpaque(false);
            } else if (selected) {
                result2.setBackground(UIUtil.getTableSelectionBackground((boolean)true));
            } else {
                result2.setBackground(UIUtil.getTableBackground());
            }
            return result2;
        }
    }

    private static final class MyCellWrapper
    implements CellWrapper {
        private final Supplier<? extends VcsHistorySession> myHistorySession;

        MyCellWrapper(Supplier<? extends VcsHistorySession> historySession) {
            this.myHistorySession = historySession;
        }

        public void wrap(Component component, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column, Object treeNode) {
            VcsFileRevision revision = ((TreeNodeOnVcsRevision)treeNode).getRevision();
            if (this.myHistorySession.get().isCurrentRevision(revision.getRevisionNumber())) {
                FileHistoryPanelImpl.makeBold(component);
            }
        }
    }

    private class MyShowDetailsAction
    extends ToggleAction
    implements DumbAware {
        MyShowDetailsAction() {
            super(VcsBundle.messagePointer((String)"action.ToggleAction.text.show.details", (Object[])new Object[0]), VcsBundle.messagePointer((String)"action.ToggleAction.description.show.details", (Object[])new Object[0]), AllIcons.Actions.PreviewDetailsVertically);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyShowDetailsAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowDetailsAction.$$$reportNull$$$0(1);
            }
            return VcsConfiguration.getInstance((Project)FileHistoryPanelImpl.this.myVcs.getProject()).SHOW_FILE_HISTORY_DETAILS;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyShowDetailsAction.$$$reportNull$$$0(2);
            }
            VcsConfiguration.getInstance((Project)FileHistoryPanelImpl.this.myVcs.getProject()).SHOW_FILE_HISTORY_DETAILS = state;
            FileHistoryPanelImpl.this.setupDetails();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MyShowDetailsAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MyShowDetailsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private class MyShowAsTreeAction
    extends ToggleAction
    implements DumbAware {
        MyShowAsTreeAction() {
            super(VcsBundle.messagePointer((String)"action.name.show.files.as.tree", (Object[])new Object[0]), PlatformIcons.SMALL_VCS_CONFIGURABLE);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyShowAsTreeAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowAsTreeAction.$$$reportNull$$$0(1);
            }
            return VcsConfiguration.getInstance((Project)FileHistoryPanelImpl.this.myVcs.getProject()).SHOW_FILE_HISTORY_AS_TREE;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyShowAsTreeAction.$$$reportNull$$$0(2);
            }
            VcsConfiguration.getInstance((Project)FileHistoryPanelImpl.this.myVcs.getProject()).SHOW_FILE_HISTORY_AS_TREE = state;
            FileHistoryPanelImpl.this.chooseView();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MyShowAsTreeAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$MyShowAsTreeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class LoadedContentRevision
    implements ByteBackedContentRevision {
        private final FilePath myFile;
        private final VcsFileRevision myRevision;
        private final Project myProject;

        private LoadedContentRevision(FilePath file, VcsFileRevision revision, Project project) {
            this.myFile = file;
            this.myRevision = revision;
            this.myProject = project;
        }

        public String getContent() throws VcsException {
            try {
                return VcsHistoryUtil.loadRevisionContentGuessEncoding(this.myRevision, this.myFile.getVirtualFile(), this.myProject);
            }
            catch (IOException e) {
                throw new VcsException(VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}));
            }
        }

        public byte @Nullable [] getContentAsBytes() throws VcsException {
            try {
                return VcsHistoryUtil.loadRevisionContent(this.myRevision);
            }
            catch (IOException e) {
                throw new VcsException(VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}));
            }
        }

        @NotNull
        public FilePath getFile() {
            FilePath filePath = this.myFile;
            if (filePath == null) {
                LoadedContentRevision.$$$reportNull$$$0(0);
            }
            return filePath;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myRevision.getRevisionNumber();
            if (vcsRevisionNumber == null) {
                LoadedContentRevision.$$$reportNull$$$0(1);
            }
            return vcsRevisionNumber;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$LoadedContentRevision";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class AuthorCellRenderer
    extends BaseHistoryCellRenderer {
        private @NlsContexts.Tooltip String myTooltipText;

        private AuthorCellRenderer() {
        }

        public void setTooltipText(@NlsContexts.Tooltip String text) {
            this.myTooltipText = text;
        }

        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (table == null) {
                AuthorCellRenderer.$$$reportNull$$$0(0);
            }
            this.setToolTipText(this.myTooltipText);
            if (value != null) {
                this.append(value.toString(), this.getDefaultAttributes());
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/vcs/history/FileHistoryPanelImpl$AuthorCellRenderer", "customizeCellRenderer"));
        }
    }

    private static abstract class BaseHistoryCellRenderer
    extends ColoredTableCellRenderer {
        private boolean myIsCurrentRevision = false;

        private BaseHistoryCellRenderer() {
        }

        protected SimpleTextAttributes getDefaultAttributes() {
            return this.myIsCurrentRevision ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }

        public void setCurrentRevision(boolean currentRevision) {
            this.myIsCurrentRevision = currentRevision;
        }
    }
}

