/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.Unsafe;
import com.intellij.util.lang.JavaVersion;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ByteBufferUtil {
    private static final MethodHandle invokeCleaner = ByteBufferUtil.findInvokeCleaner();
    private static final MethodHandle address = ByteBufferUtil.findAddress();
    private static final int byteArrayBaseOffset = ByteBufferUtil.byteArrayBaseOffset();

    @Nullable
    private static MethodHandle findInvokeCleaner() {
        MethodHandle invokeCleaner = null;
        try {
            if (JavaVersion.current().feature >= 9) {
                Object unsafe = ReflectionUtil.getUnsafe();
                MethodType type = MethodType.methodType(Void.TYPE, ByteBuffer.class);
                invokeCleaner = MethodHandles.publicLookup().findVirtual(unsafe.getClass(), "invokeCleaner", type).bindTo(unsafe);
            }
        }
        catch (Throwable t) {
            Logger.getInstance(ByteBufferUtil.class).warn(t);
        }
        return invokeCleaner;
    }

    @Nullable
    private static MethodHandle findAddress() {
        MethodHandle address = null;
        try {
            if (JavaVersion.current().feature >= 9) {
                Class<?> directBufferClass = Class.forName("sun.nio.ch.DirectBuffer");
                address = MethodHandles.lookup().findVirtual(directBufferClass, "address", MethodType.methodType(Long.TYPE));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return address;
    }

    private static int byteArrayBaseOffset() {
        return Unsafe.arrayBaseOffset(byte[].class);
    }

    public static boolean cleanBuffer(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            ByteBufferUtil.$$$reportNull$$$0(0);
        }
        if (!buffer.isDirect()) {
            return true;
        }
        if (invokeCleaner != null) {
            try {
                invokeCleaner.invoke(buffer);
                return true;
            }
            catch (Throwable t) {
                ByteBufferUtil.getLogger().warn(t);
                return false;
            }
        }
        try {
            Class<?> directBufferClass = Class.forName("sun.nio.ch.DirectBuffer");
            Class<?> cleanerClass = Class.forName("sun.misc.Cleaner");
            Object cleaner = directBufferClass.getDeclaredMethod("cleaner", new Class[0]).invoke((Object)buffer, new Object[0]);
            if (cleaner != null) {
                cleanerClass.getDeclaredMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
            }
            return true;
        }
        catch (Exception e) {
            ByteBufferUtil.getLogger().warn(e);
            return false;
        }
    }

    public static void copyMemory(@NotNull ByteBuffer src, int index, byte[] dst, int dstIndex, int length) {
        if (src == null) {
            ByteBufferUtil.$$$reportNull$$$0(1);
        }
        if (address != null && src.isDirect()) {
            try {
                long address = ByteBufferUtil.address.invoke(src);
                Unsafe.copyMemory(null, address + (long)index, dst, byteArrayBaseOffset + dstIndex, length);
                return;
            }
            catch (Throwable e) {
                ByteBufferUtil.getLogger().warn(e);
            }
        }
        ByteBuffer buf = src.duplicate();
        buf.position(index);
        buf.get(dst, dstIndex, length);
    }

    public static long getAddress(@NotNull ByteBuffer src) {
        if (src == null) {
            ByteBufferUtil.$$$reportNull$$$0(2);
        }
        try {
            return address.invoke(src);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(ByteBufferUtil.class);
        if (logger == null) {
            ByteBufferUtil.$$$reportNull$$$0(3);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/ByteBufferUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/ByteBufferUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cleanBuffer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "copyMemory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAddress";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

