/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target.prepare;

import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.run.target.configuration.wizard.DockerTargetIntrospectable;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.ui.utils.DockerRedirectToTerminal;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeConfigurationKt;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0004J$\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0014\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u000bH$J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/docker/remote/run/target/prepare/PrepareImageOperation;", "", "docker", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "<init>", "(Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;Lcom/intellij/docker/agent/progress/TtySink;)V", "getDocker", "()Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "perform", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/agent/DockerAgentImage;", "languageRuntime", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "println", "", "text", "", "introspect", "image", "prepareChannel", "Ljava/util/concurrent/BlockingQueue;", "", "onChannelFinished", "auxDetails", "", "Lcom/intellij/docker/agent/progress/DockerResponseItem$AuxDetail;", "intellij.clouds.docker.remoteRun"})
public abstract class PrepareImageOperation {
    @NotNull
    private final RemoteDockerRuntime docker;
    @NotNull
    private final TtySink ttySink;

    public PrepareImageOperation(@NotNull RemoteDockerRuntime docker, @NotNull TtySink ttySink) {
        Intrinsics.checkNotNullParameter((Object)docker, (String)"docker");
        Intrinsics.checkNotNullParameter((Object)ttySink, (String)"ttySink");
        this.docker = docker;
        this.ttySink = ttySink;
    }

    @NotNull
    protected final RemoteDockerRuntime getDocker() {
        return this.docker;
    }

    @NotNull
    public final CompletableFuture<DockerAgentImage> perform(@Nullable LanguageRuntimeConfiguration languageRuntime) {
        CompletableFuture<BlockingQueue<byte[]>> channelPromise = this.prepareChannel();
        CompletableFuture<List<DockerResponseItem.AuxDetail>> auxDetailsPromise = new DockerRedirectToTerminal(this.ttySink).redirectToTerminalLater(channelPromise);
        CompletionStage completionStage = ((CompletableFuture)auxDetailsPromise.thenApply(arg_0 -> PrepareImageOperation.perform$lambda$1(arg_0 -> PrepareImageOperation.perform$lambda$0(this, arg_0), arg_0))).thenCompose(arg_0 -> PrepareImageOperation.perform$lambda$3(arg_0 -> PrepareImageOperation.perform$lambda$2(this, languageRuntime, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    protected final void println(@Nls @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.ttySink.ttyPrintln(text);
    }

    private final CompletableFuture<DockerAgentImage> introspect(DockerAgentImage image, LanguageRuntimeConfiguration languageRuntime) {
        CompletableFuture<DockerAgentImage> withoutIntrospection = CompletableFuture.completedFuture(image);
        if (image == null) {
            Intrinsics.checkNotNull(withoutIntrospection);
            return withoutIntrospection;
        }
        LanguageRuntimeConfiguration languageRuntimeConfiguration = languageRuntime;
        if (languageRuntimeConfiguration == null || (languageRuntimeConfiguration = LanguageRuntimeConfigurationKt.getRuntimeType((LanguageRuntimeConfiguration)languageRuntimeConfiguration)) == null || (languageRuntimeConfiguration = languageRuntimeConfiguration.createIntrospector(languageRuntime)) == null) {
            Intrinsics.checkNotNull(withoutIntrospection);
            return withoutIntrospection;
        }
        LanguageRuntimeConfiguration introspector = languageRuntimeConfiguration;
        DockerTargetIntrospectable introspectable = new DockerTargetIntrospectable(this.docker, image, this.ttySink);
        CompletionStage completionStage = ((CompletableFuture)introspector.introspect((LanguageRuntimeType.Introspectable)introspectable).thenApply(arg_0 -> PrepareImageOperation.introspect$lambda$5(arg_0 -> PrepareImageOperation.introspect$lambda$4(image, arg_0), arg_0))).whenComplete((arg_0, arg_1) -> PrepareImageOperation.introspect$lambda$7((arg_0, arg_1) -> PrepareImageOperation.introspect$lambda$6(this, introspectable, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"whenComplete(...)");
        return completionStage;
    }

    @NotNull
    protected abstract CompletableFuture<BlockingQueue<byte[]>> prepareChannel();

    @Nullable
    protected abstract DockerAgentImage onChannelFinished(@NotNull List<? extends DockerResponseItem.AuxDetail> var1) throws ServerRuntimeException;

    private static final DockerAgentImage perform$lambda$0(PrepareImageOperation this$0, List auxDetails) {
        try {
            Intrinsics.checkNotNull((Object)auxDetails);
            DockerAgentImage image = this$0.onChannelFinished(auxDetails);
            if (image == null) {
                String string = DockerBundle.message("PrepareImageOperation.unable.to.find.an.image.for.introspection", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this$0.println(string);
            }
            return image;
        }
        catch (ServerRuntimeException e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            String string = DockerBundle.message("PrepareImageOperation.failed.to.find.image.for.introspection", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this$0.println(string);
            return null;
        }
    }

    private static final DockerAgentImage perform$lambda$1(Function1 $tmp0, Object p0) {
        return (DockerAgentImage)$tmp0.invoke(p0);
    }

    private static final CompletionStage perform$lambda$2(PrepareImageOperation this$0, LanguageRuntimeConfiguration $languageRuntime, DockerAgentImage image) {
        return this$0.introspect(image, $languageRuntime);
    }

    private static final CompletionStage perform$lambda$3(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final DockerAgentImage introspect$lambda$4(DockerAgentImage $image, LanguageRuntimeConfiguration it) {
        return $image;
    }

    private static final DockerAgentImage introspect$lambda$5(Function1 $tmp0, Object p0) {
        return (DockerAgentImage)$tmp0.invoke(p0);
    }

    private static final Unit introspect$lambda$6(PrepareImageOperation this$0, DockerTargetIntrospectable $introspectable, Object object, Throwable err) {
        if (err == null) {
            String string = DockerBundle.message("PrepareImageOperation.introspection.completed", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this$0.println(string);
        } else {
            Object[] objectArray = new Object[]{err.getMessage()};
            String string = DockerBundle.message("PrepareImageOperation.introspection.completed.with.error", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this$0.println(string);
        }
        $introspectable.shutdown();
        return Unit.INSTANCE;
    }

    private static final void introspect$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

