/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.python;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.RegistryKeys;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.python.PipenvBuildFileProvider;
import com.intellij.packageChecker.python.TextedPythonDependenciesModel;
import com.intellij.packageChecker.python.transitiveDependencies.PipenvTransitiveDependencies;
import com.intellij.packageChecker.python.utils.UtilsKt;
import com.intellij.packageChecker.service.PackageCheckerDisposable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.python.extensions.VirtualFileExtKt;
import com.jetbrains.python.packaging.common.PythonPackageManagementListener;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.lang.psi.TomlFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\fH\u0014J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/packageChecker/python/PipenvDependenciesModel;", "Lcom/intellij/packageChecker/python/TextedPythonDependenciesModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "transitiveDependenciesEnabled", "", "findCorrespondingBuildFileProvider", "Lcom/intellij/packageChecker/python/PipenvBuildFileProvider;", "findBuildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "getDependenciesTree", "", "Lcom/intellij/packageChecker/model/Dependency;", "packageDeclarations", "", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "virtualBuildFile", "declaredDependencies", "intellij.packageChecker.python"})
public final class PipenvDependenciesModel
extends TextedPythonDependenciesModel
implements Disposable {
    @NotNull
    private final Project project;
    private final boolean transitiveDependenciesEnabled;

    public PipenvDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.transitiveDependenciesEnabled = RegistryKeys.INSTANCE.getEnablePipEnvTransitiveDependencies();
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
        this.project.getMessageBus().connect((Disposable)this).subscribe(PythonPackageManager.Companion.getPACKAGE_MANAGEMENT_TOPIC(), (Object)new PythonPackageManagementListener(){

            public void packagesChanged(Sdk sdk) {
                Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
                this.refresh(project);
            }
        });
    }

    @Override
    @NotNull
    public PipenvBuildFileProvider findCorrespondingBuildFileProvider() {
        return (PipenvBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(PipenvBuildFileProvider.class, (AreaInstance)this.project);
    }

    @Override
    @Nullable
    public VirtualFile findBuildFile(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return UtilsKt.getPipFile(module);
    }

    @Override
    @NotNull
    protected Set<Dependency> getDependenciesTree(@NotNull List<PackageDeclaration> packageDeclarations, @NotNull Module module, @NotNull VirtualFile virtualBuildFile) {
        Intrinsics.checkNotNullParameter(packageDeclarations, (String)"packageDeclarations");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)virtualBuildFile, (String)"virtualBuildFile");
        if (this.transitiveDependenciesEnabled) {
            return PipenvTransitiveDependencies.INSTANCE.getAllTransitiveDependencies(packageDeclarations, module, virtualBuildFile);
        }
        return super.getDependenciesTree(packageDeclarations, module, virtualBuildFile);
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object object = ReadAction.compute(() -> PipenvDependenciesModel.declaredDependencies$lambda$0(module, this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (List)object;
    }

    private static final List declaredDependencies$lambda$0(Module $module, PipenvDependenciesModel this$0) {
        VirtualFile virtualFile = UtilsKt.getPipFile($module);
        PsiFileSystemItem psiFileSystemItem = virtualFile != null ? VirtualFileExtKt.toPsi((VirtualFile)virtualFile, (Project)this$0.project) : null;
        TomlFile tomlFile = psiFileSystemItem instanceof TomlFile ? (TomlFile)psiFileSystemItem : null;
        if (tomlFile == null) {
            return CollectionsKt.emptyList();
        }
        TomlFile tomlFile2 = tomlFile;
        return this$0.findCorrespondingBuildFileProvider().declaredDependencies((PsiFile)tomlFile2);
    }
}

