/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.webcore.packaging.PackageVersionComparator;
import com.jetbrains.python.packaging.PyPackageVersion;
import com.jetbrains.python.packaging.PyPackageVersionNormalizer;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002JC\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u00190\u0018\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b2\u0006\u0010\u001d\u001a\u0002H\u0019H\u0002\u00a2\u0006\u0002\u0010\u001eJ7\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00190 \"\u0004\b\u0000\u0010\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b2\u0006\u0010\u001d\u001a\u0002H\u00192\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$R,\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0001j\b\u0012\u0004\u0012\u00020\u0007`\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0005\u001a\u0004\b\t\u0010\n\u00a8\u0006%"}, d2={"Lcom/jetbrains/python/packaging/PyPackageVersionComparator;", "Ljava/util/Comparator;", "Lcom/jetbrains/python/packaging/PyPackageVersion;", "Lkotlin/Comparator;", "<init>", "()V", "STR_COMPARATOR", "", "getSTR_COMPARATOR$annotations", "getSTR_COMPARATOR", "()Ljava/util/Comparator;", "compare", "", "o1", "o2", "compareEpochs", "compareReleases", "Lcom/jetbrains/python/packaging/requirement/PyRequirementRelation;", "comparePosts", "comparePres", "compareDevs", "compareLocals", "compareAsInts", "zipLongest", "Lone/util/streamex/EntryStream;", "E", "c1", "", "c2", "fillValue", "(Ljava/util/Collection;Ljava/util/Collection;Ljava/lang/Object;)Lone/util/streamex/EntryStream;", "fillToLength", "Ljava/util/stream/Stream;", "c", "length", "", "(Ljava/util/Collection;Ljava/lang/Object;J)Ljava/util/stream/Stream;", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPyPackageVersionComparator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPackageVersionComparator.kt\ncom/jetbrains/python/packaging/PyPackageVersionComparator\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,149:1\n434#2:150\n507#2,5:151\n434#2:156\n507#2,5:157\n*S KotlinDebug\n*F\n+ 1 PyPackageVersionComparator.kt\ncom/jetbrains/python/packaging/PyPackageVersionComparator\n*L\n105#1:150\n105#1:151,5\n106#1:156\n106#1:157,5\n*E\n"})
public final class PyPackageVersionComparator
implements Comparator<PyPackageVersion> {
    @NotNull
    public static final PyPackageVersionComparator INSTANCE = new PyPackageVersionComparator();
    @NotNull
    private static final Comparator<String> STR_COMPARATOR = PyPackageVersionComparator::STR_COMPARATOR$lambda$0;

    private PyPackageVersionComparator() {
    }

    @NotNull
    public static final Comparator<String> getSTR_COMPARATOR() {
        return STR_COMPARATOR;
    }

    @JvmStatic
    public static /* synthetic */ void getSTR_COMPARATOR$annotations() {
    }

    @Override
    public int compare(@NotNull PyPackageVersion o1, @NotNull PyPackageVersion o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        int epochs = this.compareEpochs(o1, o2);
        if (epochs != 0) {
            return epochs;
        }
        PyRequirementRelation releases = this.compareReleases(o1, o2);
        if (releases != PyRequirementRelation.EQ) {
            if (releases == PyRequirementRelation.LT) {
                return -1;
            }
            if (releases == PyRequirementRelation.GT) {
                return 1;
            }
            return 0;
        }
        int pres = this.comparePres(o1, o2);
        if (pres != 0) {
            return pres;
        }
        int posts = this.comparePosts(o1, o2);
        if (posts != 0) {
            return posts;
        }
        int devs = this.compareDevs(o1, o2);
        if (devs != 0) {
            return devs;
        }
        return this.compareLocals(o1, o2);
    }

    private final int compareEpochs(PyPackageVersion o1, PyPackageVersion o2) {
        String string;
        String string2 = o1.getEpoch();
        if (string2 == null) {
            string2 = "0";
        }
        if ((string = o2.getEpoch()) == null) {
            string = "0";
        }
        return this.compareAsInts(string2, string);
    }

    private final PyRequirementRelation compareReleases(PyPackageVersion o1, PyPackageVersion o2) {
        boolean devOnly2;
        char[] cArray = new char[]{'.'};
        Collection collection = StringsKt.split$default((CharSequence)o1.getRelease(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        cArray = new char[]{'.'};
        Iterator iterator = this.zipLongest(collection, StringsKt.split$default((CharSequence)o2.getRelease(), (char[])cArray, (boolean)false, (int)0, (int)6, null), "0").iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            Intrinsics.checkNotNull((Object)entry);
            String releasePart1 = (String)entry.getKey();
            String releasePart2 = (String)entry.getValue();
            if (Intrinsics.areEqual((Object)releasePart1, (Object)"*") || Intrinsics.areEqual((Object)releasePart2, (Object)"*")) {
                return PyRequirementRelation.COMPATIBLE;
            }
            Intrinsics.checkNotNull((Object)releasePart1);
            Intrinsics.checkNotNull((Object)releasePart2);
            int releaseParts = this.compareAsInts(releasePart1, releasePart2);
            if (releaseParts < 0) {
                return PyRequirementRelation.LT;
            }
            if (releaseParts <= 0) continue;
            return PyRequirementRelation.GT;
        }
        boolean devOnly1 = o1.getDev() != null && o1.getPre() == null && o1.getPost() == null;
        boolean bl = devOnly2 = o2.getDev() != null && o2.getPre() == null && o2.getPost() == null;
        if (devOnly1 || devOnly2) {
            if (!devOnly2) {
                return PyRequirementRelation.LT;
            }
            if (!devOnly1) {
                return PyRequirementRelation.GT;
            }
            int devs = this.compareDevs(o1, o2);
            if (devs < 0) {
                return PyRequirementRelation.LT;
            }
            if (devs > 0) {
                return PyRequirementRelation.GT;
            }
        }
        return PyRequirementRelation.EQ;
    }

    private final int comparePosts(PyPackageVersion o1, PyPackageVersion o2) {
        String string;
        String string2;
        block7: {
            block6: {
                block5: {
                    block4: {
                        string2 = o1.getPost();
                        if (string2 == null) break block4;
                        String string3 = string2.substring(4);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        string2 = string3;
                        if (string3 != null) break block5;
                    }
                    string2 = "-1";
                }
                if ((string = o2.getPost()) == null) break block6;
                String string4 = string.substring(4);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                string = string4;
                if (string4 != null) break block7;
            }
            string = "-1";
        }
        return this.compareAsInts(string2, string);
    }

    /*
     * WARNING - void declaration
     */
    private final int comparePres(PyPackageVersion o1, PyPackageVersion o2) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        String pre1 = o1.getPre();
        String pre2 = o2.getPre();
        if (pre1 == null && pre2 == null) {
            return 0;
        }
        if (pre2 == null) {
            return -1;
        }
        if (pre1 == null) {
            return 1;
        }
        String $this$filter$iv = pre1;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Object destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv2.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char p0 = element$iv$iv = $this$filterTo$iv$iv2.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isLetter(p0)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String preType1 = ((StringBuilder)destination$iv$iv).toString();
        String $this$filter$iv2 = pre2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Appendable destination$iv$iv2 = new StringBuilder();
        boolean $i$f$filterTo2 = false;
        int n2 = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n2; ++index$iv$iv) {
            char element$iv$iv;
            char p0 = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isLetter(p0)) continue;
            destination$iv$iv2.append(element$iv$iv);
        }
        String preType2 = ((StringBuilder)destination$iv$iv2).toString();
        int preTypes = preType1.compareTo(preType2);
        if (preTypes != 0) {
            return preTypes;
        }
        String string = pre1.substring(preType1.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = pre2.substring(preType2.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return this.compareAsInts(string, string2);
    }

    private final int compareDevs(PyPackageVersion o1, PyPackageVersion o2) {
        String dev1 = o1.getDev();
        String dev2 = o2.getDev();
        if (dev1 == null && dev2 == null) {
            return 0;
        }
        if (dev2 == null) {
            return -1;
        }
        if (dev1 == null) {
            return 1;
        }
        String string = dev1.substring(3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = dev2.substring(3);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string.compareTo(string2);
    }

    private final int compareLocals(PyPackageVersion o1, PyPackageVersion o2) {
        String string;
        String string2 = o1.getLocal();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = o2.getLocal()) == null) {
            string = "";
        }
        return string2.compareTo(string);
    }

    private final int compareAsInts(String o1, String o2) {
        return new BigInteger(o1).compareTo(new BigInteger(o2));
    }

    private final <E> EntryStream<E, E> zipLongest(Collection<? extends E> c1, Collection<? extends E> c2, E fillValue) {
        long maxSize = Math.max(c1.size(), c2.size());
        EntryStream entryStream = StreamEx.of(this.fillToLength(c1, fillValue, maxSize)).zipWith(this.fillToLength(c2, fillValue, maxSize));
        Intrinsics.checkNotNullExpressionValue((Object)entryStream, (String)"zipWith(...)");
        return entryStream;
    }

    private final <E> Stream<E> fillToLength(Collection<? extends E> c, E fillValue, long length) {
        AbstractStreamEx abstractStreamEx = ((StreamEx)StreamEx.of(c).append((Stream)StreamEx.constant(fillValue, (long)length))).limit(length);
        Intrinsics.checkNotNullExpressionValue((Object)abstractStreamEx, (String)"limit(...)");
        return (Stream)abstractStreamEx;
    }

    private static final int STR_COMPARATOR$lambda$0(String o1, String o2) {
        PyPackageVersion pyPackageVersion = PyPackageVersionNormalizer.normalize(o1);
        if (pyPackageVersion == null) {
            return PackageVersionComparator.VERSION_COMPARATOR.compare(o1, o2);
        }
        PyPackageVersion normalized1 = pyPackageVersion;
        PyPackageVersion pyPackageVersion2 = PyPackageVersionNormalizer.normalize(o2);
        if (pyPackageVersion2 == null) {
            return PackageVersionComparator.VERSION_COMPARATOR.compare(o1, o2);
        }
        PyPackageVersion normalized2 = pyPackageVersion2;
        return INSTANCE.compare(normalized1, normalized2);
    }
}

