/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl;

import com.google.common.base.Charsets;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.impl.HttpRequestHandlerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestHandlerHelper {
    private static final Logger LOG = Logger.getInstance(HttpRequestHandlerHelper.class);
    private static final String UNICODE_QUOTE = "\\u0022";
    private static final String ESCAPED_UNICODE_BEGIN = "\\\\u";

    private HttpRequestHandlerHelper() {
    }

    @NotNull
    public static String getEncoding(@NotNull RestClientRequest request) {
        if (request == null) {
            HttpRequestHandlerHelper.$$$reportNull$$$0(0);
        }
        String string = request.getHeaderValue("Accept-Charset", "UTF-8");
        if (string == null) {
            HttpRequestHandlerHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String cleanBody(@NotNull String body2, @NotNull Charset charset, @NotNull String contentType) {
        if (body2 == null) {
            HttpRequestHandlerHelper.$$$reportNull$$$0(2);
        }
        if (charset == null) {
            HttpRequestHandlerHelper.$$$reportNull$$$0(3);
        }
        if (contentType == null) {
            HttpRequestHandlerHelper.$$$reportNull$$$0(4);
        }
        if (charset == Charsets.UTF_8) {
            String result2 = body2;
            if (HttpRequestHandlerUtil.isJsonMimeType(contentType)) {
                result2 = body2.replace(UNICODE_QUOTE, "\\\"");
                String string = StringUtil.split((String)result2, (String)ESCAPED_UNICODE_BEGIN, (boolean)false).stream().map(StringUtil::replaceUnicodeEscapeSequences).collect(Collectors.joining());
                if (string == null) {
                    HttpRequestHandlerHelper.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = StringUtil.replaceUnicodeEscapeSequences((String)result2);
            if (string == null) {
                HttpRequestHandlerHelper.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = body2;
        if (string == null) {
            HttpRequestHandlerHelper.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getFullUri(@NotNull String uri, @NotNull RestClientRequest request) {
        String query;
        if (uri == null) {
            HttpRequestHandlerHelper.$$$reportNull$$$0(8);
        }
        if (request == null) {
            HttpRequestHandlerHelper.$$$reportNull$$$0(9);
        }
        if (request.parametersEnabled && StringUtil.isNotEmpty((String)(query = request.createQueryString()))) {
            uri = (String)uri + (((String)uri).contains("?") ? "&" : "?") + query;
        }
        String string = uri;
        if (string == null) {
            HttpRequestHandlerHelper.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static void convertCookieHeadersToBiscuits(@NotNull RestClientRequest request) {
        List<String> cookieHeaders;
        if (request == null) {
            HttpRequestHandlerHelper.$$$reportNull$$$0(11);
        }
        if ((cookieHeaders = request.getHeadersValue("Cookie")) == null || cookieHeaders.isEmpty()) {
            return;
        }
        URI uri = HttpRequestHandlerHelper.getUrlForCookieDomain(request.getURL());
        for (String cookieHeader : cookieHeaders) {
            for (String cookie : StringUtil.split((String)cookieHeader.trim(), (String)";")) {
                request.addBiscuit(HttpRequestHandlerHelper.createNewCookie(uri, cookie));
            }
        }
        request.deleteHeader("Cookie");
    }

    @NotNull
    private static RestClientRequest.Biscuit createNewCookie(URI uri, String cookie) {
        RestClientRequest.Biscuit newCookie;
        String trimmedCookie = StringUtil.trimLeading((String)cookie);
        int separatorPos = trimmedCookie.indexOf(61);
        if (separatorPos == -1) {
            newCookie = new RestClientRequest.Biscuit(trimmedCookie, null, null, null, -1L);
        } else {
            String cookieName = trimmedCookie.substring(0, separatorPos);
            String cookieValue = trimmedCookie.substring(separatorPos + 1);
            newCookie = new RestClientRequest.Biscuit(cookieName, cookieValue, null, null, -1L);
        }
        if (uri != null) {
            newCookie.setDomain(uri.getHost());
            newCookie.setPath(uri.getPath());
        }
        RestClientRequest.Biscuit biscuit = newCookie;
        if (biscuit == null) {
            HttpRequestHandlerHelper.$$$reportNull$$$0(12);
        }
        return biscuit;
    }

    @Nullable
    private static URI getUrlForCookieDomain(@Nullable String url) {
        try {
            if (StringUtil.isNotEmpty((String)url)) {
                return new URI(url);
            }
        }
        catch (URISyntaxException e) {
            LOG.warn("Cannot detect request url to set domain to cookies", (Throwable)e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/execution/impl/HttpRequestHandlerHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/execution/impl/HttpRequestHandlerHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEncoding";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanBody";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullUri";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewCookie";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEncoding";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cleanBody";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFullUri";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertCookieHeadersToBiscuits";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7, 10, 12 -> new IllegalStateException(string);
        };
    }
}

