/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter.auth.digest;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.postman.converter.auth.digest.AlgorithmType;
import com.intellij.httpClient.postman.converter.auth.digest.CryptoResult;
import com.intellij.httpClient.postman.converter.auth.digest.DigestAuthProviderKt;
import com.intellij.httpClient.postman.converter.auth.digest.DigestCalculator;
import com.intellij.httpClient.postman.converter.auth.digest.DigestScriptBuilder;
import com.intellij.httpClient.postman.converter.auth.digest.HeaderAttribute;
import com.intellij.httpClient.postman.converter.auth.digest.HeaderAttributes;
import com.intellij.httpClient.postman.converter.auth.digest.QopType;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpScript;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a.\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a6\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u001a4\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001c\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002\u001a\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0002\u001a\f\u0010\u001b\u001a\u00020\b*\u00020\bH\u0002\u001a\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002\u001a\f\u0010\u001f\u001a\u00020\b*\u00020 H\u0002\u00a8\u0006!"}, d2={"buildPreScript", "Lcom/intellij/httpClient/postman/converter/dto/httpClient/HttpScript;", "attributes", "Lcom/intellij/httpClient/postman/converter/auth/digest/HeaderAttributes;", "algorithm", "Lcom/intellij/httpClient/postman/converter/auth/digest/AlgorithmType;", "build", "", "", "digestScriptBuilder", "Lcom/intellij/httpClient/postman/converter/auth/digest/DigestScriptBuilder;", "digestCalculator", "Lcom/intellij/httpClient/postman/converter/auth/digest/DigestCalculator;", "getHA2", "Lcom/intellij/httpClient/postman/converter/auth/digest/CryptoResult;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "qopType", "Lcom/intellij/httpClient/postman/converter/auth/digest/QopType;", "getHA1", "getVariable", "attribute", "Lcom/intellij/httpClient/postman/converter/auth/digest/HeaderAttribute;", "asVariable", "name", "value", "asJsTemplate", "getFromEnv", "variableName", "envVariableName", "toHex", "", "intellij.restClient"})
public final class DigestScriptProviderKt {
    @NotNull
    public static final HttpScript buildPreScript(@NotNull HeaderAttributes attributes, @NotNull AlgorithmType algorithm) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Pair pair = switch (WhenMappings.$EnumSwitchMapping$0[algorithm.ordinal()]) {
            case 1, 2 -> TuplesKt.to((Object)"crypto.md5()", (Object)"MD5");
            case 3, 4 -> TuplesKt.to((Object)"crypto.sha256()", (Object)"SHA-256");
            default -> throw new NoWhenBranchMatchedException();
        };
        String function = (String)pair.component1();
        String algorithmName = (String)pair.component2();
        DigestScriptBuilder digestScriptBuilder = new DigestScriptBuilder(function);
        MessageDigest messageDigest = MessageDigest.getInstance(algorithmName);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        DigestCalculator digestCalculator = new DigestCalculator(messageDigest);
        List<String> scriptLines = DigestScriptProviderKt.build(attributes, digestScriptBuilder, digestCalculator, algorithm);
        return new HttpScript(scriptLines, true, false);
    }

    private static final List<String> build(HeaderAttributes attributes, DigestScriptBuilder digestScriptBuilder, DigestCalculator digestCalculator, AlgorithmType algorithm) {
        StringBuilder builder;
        HeaderAttribute qop;
        block7: {
            CharSequence charSequence;
            block6: {
                CryptoResult cryptoResult;
                Object[] objectArray;
                qop = attributes.getQop();
                QopType qopType = DigestAuthProviderKt.toQopType(qop);
                builder = new StringBuilder();
                CryptoResult ha1 = DigestScriptProviderKt.getHA1(attributes, digestScriptBuilder, builder, algorithm, digestCalculator);
                builder.append("const HA1 = " + ha1.getScriptCode()).append("\n");
                CryptoResult ha2 = DigestScriptProviderKt.getHA2(attributes, digestScriptBuilder, digestCalculator, builder, qopType);
                builder.append("const HA2 = " + ha2.getScriptCode()).append("\n");
                String ha1Template = DigestScriptProviderKt.asJsTemplate("HA1");
                String ha2Template = DigestScriptProviderKt.asJsTemplate("HA2");
                HeaderAttribute nonce = attributes.getNonce();
                String nonceVariable = DigestScriptProviderKt.getVariable(nonce, builder);
                if (qopType == QopType.AUTH || qopType == QopType.AUTH_INT) {
                    HeaderAttribute nonceCount = attributes.getNonceCount();
                    HeaderAttribute clientNonce = attributes.getClientNonce();
                    String qopVariable = DigestScriptProviderKt.getVariable(qop, builder);
                    String nonceCountVariable = DigestScriptProviderKt.getVariable(nonceCount, builder);
                    String clientNonceVariable = DigestScriptProviderKt.getVariable(clientNonce, builder);
                    objectArray = digestScriptBuilder.buildFunction(ha1Template + ":" + nonceVariable + ":" + nonceCountVariable + ":" + clientNonceVariable + ":" + qopVariable + ":" + ha2Template);
                    String string = digestCalculator.calculateResponse(ha1.getCalculationResult(), ha2.getCalculationResult(), nonce, nonceCount, clientNonce, qop);
                    cryptoResult = new CryptoResult(string, (String)objectArray);
                } else {
                    String string = digestScriptBuilder.buildFunction(ha1Template + ":" + nonceVariable + ":" + ha2Template);
                    String string2 = DigestCalculator.calculateResponse$default(digestCalculator, ha1.getCalculationResult(), ha2.getCalculationResult(), nonce, null, null, null, 56, null);
                    cryptoResult = new CryptoResult(string2, string);
                }
                CryptoResult response2 = cryptoResult;
                builder.append("const response = " + response2.getScriptCode()).append("\n");
                builder.append("request.variables.set(\"response\", response)").append("\n");
                charSequence = response2.getCalculationResult();
                if (charSequence == null) break block6;
                String it = charSequence;
                boolean bl = false;
                objectArray = new Object[]{it};
                StringBuilder stringBuilder = builder.append(RestClientBundle.message("http.client.postman.converter.convert.script.calculated", objectArray));
                charSequence = stringBuilder;
                if (stringBuilder != null) break block7;
            }
            charSequence = builder.append(RestClientBundle.message("http.client.postman.converter.convert.script.specify.env", new Object[0]));
        }
        if (qop.isFromEnv()) {
            builder.append("\n");
            builder.append(RestClientBundle.message("http.client.postman.converter.convert.script.specify.qop", new Object[0]));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.lines((CharSequence)string);
    }

    private static final CryptoResult getHA2(HeaderAttributes attributes, DigestScriptBuilder digestScriptBuilder, DigestCalculator digestCalculator, StringBuilder builder, QopType qopType) {
        HeaderAttribute method = attributes.getMethod();
        HeaderAttribute uri = attributes.getDigestURI();
        String methodVariable = DigestScriptProviderKt.getVariable(method, builder);
        String uriVariable = DigestScriptProviderKt.getVariable(uri, builder);
        if (qopType == QopType.AUTH_INT) {
            String body2 = DigestScriptProviderKt.asJsTemplate(digestScriptBuilder.buildFunction(""));
            String string = digestScriptBuilder.buildFunction(methodVariable + ":" + uriVariable + ":" + body2);
            String string2 = digestCalculator.calculateHA2(method, uri, "");
            return new CryptoResult(string2, string);
        }
        String string = digestScriptBuilder.buildFunction(methodVariable + ":" + uriVariable);
        String string3 = DigestCalculator.calculateHA2$default(digestCalculator, method, uri, null, 4, null);
        return new CryptoResult(string3, string);
    }

    private static final CryptoResult getHA1(HeaderAttributes attributes, DigestScriptBuilder digestScriptBuilder, StringBuilder builder, AlgorithmType algorithm, DigestCalculator digestCalculator) {
        CryptoResult cryptoResult;
        HeaderAttribute username = attributes.getUsername();
        HeaderAttribute realm = attributes.getRealm();
        HeaderAttribute password = attributes.getPassword();
        String usernameValue = DigestScriptProviderKt.getVariable(username, builder);
        String realmValue = DigestScriptProviderKt.getVariable(realm, builder);
        String passwordValue = DigestScriptProviderKt.getVariable(password, builder);
        String unspecifiedHA1Text = usernameValue + ":" + realmValue + ":" + passwordValue;
        if (algorithm == AlgorithmType.SHA256_SESS || algorithm == AlgorithmType.MD5_SESS) {
            String unspecifiedHA1 = digestScriptBuilder.buildFunction(unspecifiedHA1Text);
            String unspecifiedHA1VariableName = "HA1_1";
            builder.append(DigestScriptProviderKt.asVariable(unspecifiedHA1VariableName, unspecifiedHA1)).append("\n");
            HeaderAttribute nonce = attributes.getNonce();
            String nonceValue = DigestScriptProviderKt.getVariable(nonce, builder);
            HeaderAttribute clientNonce = attributes.getClientNonce();
            String clientNonceValue = DigestScriptProviderKt.getVariable(attributes.getClientNonce(), builder);
            String code = digestScriptBuilder.buildFunction(DigestScriptProviderKt.asJsTemplate(unspecifiedHA1VariableName) + ":" + nonceValue + ":" + clientNonceValue);
            String calculation = digestCalculator.calculateHA1(username, realm, password, true, nonce, clientNonce);
            cryptoResult = new CryptoResult(calculation, code);
        } else {
            String code = digestScriptBuilder.buildFunction(unspecifiedHA1Text);
            String calculation = DigestCalculator.calculateHA1$default(digestCalculator, username, realm, password, false, null, null, 56, null);
            cryptoResult = new CryptoResult(calculation, code);
        }
        return cryptoResult;
    }

    private static final String getVariable(HeaderAttribute attribute, StringBuilder builder) {
        String string;
        if (attribute.isFromEnv()) {
            builder.append(DigestScriptProviderKt.getFromEnv(attribute.getKey(), attribute.getValueName()));
            builder.append("\n");
            string = DigestScriptProviderKt.asJsTemplate(attribute.getKey());
        } else {
            string = attribute.getValue();
        }
        return string;
    }

    private static final String asVariable(String name, String value2) {
        return "const " + name + " = " + value2;
    }

    private static final String asJsTemplate(String $this$asJsTemplate) {
        return "${" + $this$asJsTemplate + "}";
    }

    private static final String getFromEnv(String variableName, String envVariableName) {
        return DigestScriptProviderKt.asVariable(variableName, "request.environment.get(\"" + envVariableName + "\")");
    }

    private static final String toHex(byte[] $this$toHex) {
        return ArraysKt.joinToString$default((byte[])$this$toHex, (CharSequence)"", null, null, (int)0, null, DigestScriptProviderKt::toHex$lambda$1, (int)30, null);
    }

    private static final CharSequence toHex$lambda$1(byte by) {
        String string = "%02x";
        Object[] objectArray = new Object[]{by};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static final /* synthetic */ String access$toHex(byte[] $receiver) {
        return DigestScriptProviderKt.toHex($receiver);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AlgorithmType.values().length];
            try {
                nArray[AlgorithmType.MD5.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlgorithmType.MD5_SESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlgorithmType.SHA256.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlgorithmType.SHA256_SESS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

