/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.foreign;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.foreign.ForeignIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class ForeignIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<ForeignIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new ForeignIteratorPrototypeBuiltins();

    protected ForeignIteratorPrototypeBuiltins() {
        super(null, ForeignIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, ForeignIteratorPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return ForeignIteratorPrototypeBuiltinsFactory.NextNodeGen.create(context2, builtin, ForeignIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum ForeignIteratorPrototype implements BuiltinEnum<ForeignIteratorPrototype>
    {
        next(0);

        private final int length;

        private ForeignIteratorPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class NextNode
    extends JSBuiltinNode {
        public NextNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected JSObject next(VirtualFrame frame, Object target, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached(value="create(getContext())") CreateIterResultObjectNode createIterResult, @Cached ImportValueNode importValue, @Cached InlinedBranchProfile errorBranch) {
            boolean hasNext;
            if (!interop.isIterator(target)) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorNotIterator(target, this);
            }
            try {
                hasNext = interop.hasIteratorNextElement(target);
            }
            catch (UnsupportedMessageException umex) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorInteropException(target, umex, "hasIteratorNextElement", null);
            }
            Object nextValue = Undefined.instance;
            if (hasNext) {
                try {
                    nextValue = importValue.executeWithTarget(interop.getIteratorNextElement(target));
                }
                catch (UnsupportedMessageException umex) {
                    errorBranch.enter(this);
                    throw Errors.createTypeErrorInteropException(target, umex, "getIteratorNextElement", null);
                }
                catch (StopIterationException siex) {
                    hasNext = false;
                }
            }
            return createIterResult.execute(frame, nextValue, !hasNext);
        }
    }
}

