/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.HasPropertyCacheNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.ToPropertyDescriptorNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class ToPropertyDescriptorNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private PropertyGetNode getEnumerableNode;
    @Node.Child
    private PropertyGetNode getConfigurableNode;
    @Node.Child
    private PropertyGetNode getWritableNode;
    @Node.Child
    private PropertyGetNode getValueNode;
    @Node.Child
    private PropertyGetNode getSetNode;
    @Node.Child
    private PropertyGetNode getGetNode;
    @Node.Child
    private HasPropertyCacheNode hasEnumerableNode;
    @Node.Child
    private HasPropertyCacheNode hasConfigurableNode;
    @Node.Child
    private HasPropertyCacheNode hasWritableNode;
    @Node.Child
    private HasPropertyCacheNode hasValueNode;
    @Node.Child
    private HasPropertyCacheNode hasSetNode;
    @Node.Child
    private HasPropertyCacheNode hasGetNode;

    public abstract PropertyDescriptor execute(Object var1);

    @NeverDefault
    public static ToPropertyDescriptorNode create(JSContext context2) {
        return ToPropertyDescriptorNodeGen.create(context2);
    }

    protected ToPropertyDescriptorNode(JSContext context2) {
        this.context = context2;
        this.hasEnumerableNode = HasPropertyCacheNode.create(JSAttributes.ENUMERABLE, context2);
        this.hasConfigurableNode = HasPropertyCacheNode.create(JSAttributes.CONFIGURABLE, context2);
        this.hasWritableNode = HasPropertyCacheNode.create(JSAttributes.WRITABLE, context2);
        this.hasValueNode = HasPropertyCacheNode.create(JSAttributes.VALUE, context2);
        this.hasGetNode = HasPropertyCacheNode.create(JSAttributes.GET, context2);
        this.hasSetNode = HasPropertyCacheNode.create(JSAttributes.SET, context2);
    }

    @Specialization(guards={"isObjectNode.executeBoolean(obj)"}, limit="1")
    protected PropertyDescriptor doDefault(Object obj, @Cached @Cached.Shared(value="isObject") IsObjectNode isObjectNode, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached InlinedBranchProfile hasGetBranch, @Cached InlinedBranchProfile hasSetBranch, @Cached InlinedBranchProfile hasEnumerableBranch, @Cached InlinedBranchProfile hasConfigurableBranch, @Cached InlinedBranchProfile hasValueBranch, @Cached InlinedBranchProfile hasWritableBranch, @Cached InlinedBranchProfile errorBranch, @Cached IsCallableNode isCallable) {
        boolean hasSet;
        boolean hasGet;
        boolean hasWritable;
        boolean hasValue;
        PropertyDescriptor desc = PropertyDescriptor.createEmpty();
        if (this.hasEnumerableNode.hasProperty(obj)) {
            hasEnumerableBranch.enter(this);
            desc.setEnumerable(toBooleanNode.executeBoolean(this, this.getEnumerableNode().getValue(obj)));
        }
        if (this.hasConfigurableNode.hasProperty(obj)) {
            hasConfigurableBranch.enter(this);
            desc.setConfigurable(toBooleanNode.executeBoolean(this, this.getConfigurableNode().getValue(obj)));
        }
        if (hasValue = this.hasValueNode.hasProperty(obj)) {
            hasValueBranch.enter(this);
            desc.setValue(this.getValue(obj));
        }
        if (hasWritable = this.hasWritableNode.hasProperty(obj)) {
            hasWritableBranch.enter(this);
            desc.setWritable(toBooleanNode.executeBoolean(this, this.getWritableNode().getValue(obj)));
        }
        if (hasGet = this.hasGetNode.hasProperty(obj)) {
            hasGetBranch.enter(this);
            Object getter = this.getGet(obj);
            if (!isCallable.executeBoolean(getter) && getter != Undefined.instance) {
                errorBranch.enter(this);
                throw Errors.createTypeError("Getter must be a function");
            }
            desc.setGet(getter);
        }
        if (hasSet = this.hasSetNode.hasProperty(obj)) {
            hasSetBranch.enter(this);
            Object setter = this.getSet(obj);
            if (!isCallable.executeBoolean(setter) && setter != Undefined.instance) {
                errorBranch.enter(this);
                throw Errors.createTypeError("Setter must be a function");
            }
            desc.setSet(setter);
        }
        if ((hasGet || hasSet) && (hasValue || hasWritable)) {
            errorBranch.enter(this);
            throw Errors.createTypeError("Invalid property. A property cannot both have accessors and be writable or have a value");
        }
        return desc;
    }

    private Object getSet(Object obj) {
        if (this.getSetNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getSetNode = this.insert(PropertyGetNode.create(JSAttributes.SET, this.context));
        }
        return this.getSetNode.getValue(obj);
    }

    private Object getGet(Object obj) {
        if (this.getGetNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getGetNode = this.insert(PropertyGetNode.create(JSAttributes.GET, this.context));
        }
        return this.getGetNode.getValue(obj);
    }

    private Object getValue(Object obj) {
        if (this.getValueNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getValueNode = this.insert(PropertyGetNode.create(JSAttributes.VALUE, this.context));
        }
        return this.getValueNode.getValue(obj);
    }

    private PropertyGetNode getWritableNode() {
        if (this.getWritableNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getWritableNode = this.insert(PropertyGetNode.create(JSAttributes.WRITABLE, this.context));
        }
        return this.getWritableNode;
    }

    private PropertyGetNode getConfigurableNode() {
        if (this.getConfigurableNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getConfigurableNode = this.insert(PropertyGetNode.create(JSAttributes.CONFIGURABLE, this.context));
        }
        return this.getConfigurableNode;
    }

    private PropertyGetNode getEnumerableNode() {
        if (this.getEnumerableNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getEnumerableNode = this.insert(PropertyGetNode.create(JSAttributes.ENUMERABLE, this.context));
        }
        return this.getEnumerableNode;
    }

    @Specialization(guards={"!isObjectNode.executeBoolean(obj)"}, limit="1")
    protected PropertyDescriptor doNonObject(Object obj, @Cached @Cached.Shared(value="isObject") IsObjectNode isObjectNode) {
        throw Errors.createTypeErrorPropertyDescriptorNotAnObject(obj, this);
    }
}

