/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorAwaitReturnNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSAsyncGeneratorObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import com.oracle.truffle.js.runtime.objects.Completion;
import java.util.ArrayDeque;

public class AsyncGeneratorDrainQueueNode
extends AsyncGeneratorAwaitReturnNode {
    AsyncGeneratorDrainQueueNode(JSContext context2) {
        super(context2);
    }

    public static AsyncGeneratorDrainQueueNode create(JSContext context2) {
        return new AsyncGeneratorDrainQueueNode(context2);
    }

    public final void asyncGeneratorCompleteStepAndDrainQueue(VirtualFrame frame, JSAsyncGeneratorObject generator, Completion.Type resultType, Object resultValue) {
        ArrayDeque<AsyncGeneratorRequest> queue = generator.getAsyncGeneratorQueue();
        generator.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.Completed);
        this.asyncGeneratorCompleteStep(frame, resultType, resultValue, true, queue);
        if (!queue.isEmpty()) {
            this.asyncGeneratorDrainQueue(frame, generator, queue);
        }
    }

    public final void asyncGeneratorDrainQueue(VirtualFrame frame, JSAsyncGeneratorObject generator, ArrayDeque<AsyncGeneratorRequest> queue) {
        assert (generator.getAsyncGeneratorState() == JSFunction.AsyncGeneratorState.Completed) : generator.getAsyncGeneratorState();
        while (!queue.isEmpty()) {
            AsyncGeneratorRequest next = queue.peekFirst();
            if (next.getCompletionType() == Completion.Type.Return) {
                generator.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.AwaitingReturn);
                try {
                    this.asyncGeneratorAwaitReturn(generator, queue);
                    break;
                }
                catch (AbstractTruffleException ex) {
                    this.asyncGeneratorRejectBrokenPromise(frame, generator, ex, queue);
                    continue;
                }
            }
            this.asyncGeneratorCompleteStep(frame, next.getCompletionType(), next.getCompletionValue(), true, queue);
        }
    }
}

