/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.AsyncGeneratorPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSAsyncGeneratorObject;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSAsyncGenerator
extends JSNonProxy
implements JSConstructorFactory,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("AsyncGenerator");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("AsyncGenerator.prototype");
    public static final TruffleString TO_STRING_TAG = CLASS_NAME;
    public static final JSAsyncGenerator INSTANCE = new JSAsyncGenerator();

    private JSAsyncGenerator() {
    }

    public static JSAsyncGeneratorObject create(JSContext context2, JSRealm realm, JSDynamicObject proto) {
        return JSAsyncGenerator.create(context2.getAsyncGeneratorObjectFactory(), realm, proto);
    }

    public static JSAsyncGeneratorObject create(JSContext context2, JSRealm realm) {
        return JSAsyncGenerator.create(context2.getAsyncGeneratorObjectFactory(), realm);
    }

    public static JSAsyncGeneratorObject create(JSObjectFactory factory, JSRealm realm, JSDynamicObject proto) {
        Shape shape = factory.getShape(realm, proto);
        JSAsyncGeneratorObject newObj = factory.initProto(new JSAsyncGeneratorObject(shape, proto), realm, proto);
        return factory.trackAllocation(newObj);
    }

    public static JSAsyncGeneratorObject create(JSObjectFactory factory, JSRealm realm) {
        return JSAsyncGenerator.create(factory, realm, factory.getPrototype(realm));
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm, realm.getAsyncIteratorPrototype());
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, AsyncGeneratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(prototype, JSObject.CONSTRUCTOR, constructor, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putToStringTag(prototype, TO_STRING_TAG);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context2, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context2);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return this.getClassName();
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getAsyncGeneratorObjectPrototype();
    }
}

