/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.time.LocalDate;

@ExportLibrary(value=InteropLibrary.class)
public final class JSTemporalPlainDateObject
extends JSTemporalCalendarHolder {
    private final int year;
    private final int month;
    private final int day;

    public JSTemporalPlainDateObject(Shape shape, JSDynamicObject proto, int year, int month, int day, JSDynamicObject calendar) {
        super(shape, proto, calendar);
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    @ExportMessage
    boolean isDate() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalDate asDate() {
        return LocalDate.of(this.year, this.month, this.day);
    }
}

