/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSSpacingProcessor;
import com.intellij.lang.javascript.types.JSBlockStatementElementType;
import com.intellij.lang.qml.QmlElementTypes;
import com.intellij.lang.qml.types.QmlImportDeclarationElementType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class QmlSpacingProcessor
extends JSSpacingProcessor {
    public QmlSpacingProcessor(ASTNode parent, ASTNode child1, ASTNode child2, CodeStyleSettings topSettings, Language dialect, @NotNull JSCodeStyleSettings jsCodeStyleSettings) {
        if (jsCodeStyleSettings == null) {
            QmlSpacingProcessor.$$$reportNull$$$0(0);
        }
        super(parent, child1, child2, topSettings, dialect, jsCodeStyleSettings);
    }

    public void visitAssignmentExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.COLON) {
            this.setSingleSpace(this.myCustomSettings.SPACE_AFTER_PROPERTY_COLON);
            return;
        }
        if (this.type2 == JSTokenTypes.COLON) {
            this.setSingleSpace(this.myCustomSettings.SPACE_BEFORE_PROPERTY_COLON);
            return;
        }
        super.visitAssignmentExpression(node);
    }

    protected boolean isSourceElement(IElementType type) {
        return type == QmlElementTypes.QML_PROPERTY_DECLARATION || type == QmlElementTypes.QML_ELEMENT_DECLARATION || type == JSStubElementTypes.ASSIGNMENT_EXPRESSION || JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(type);
    }

    protected void processBlock(int blankLinesAroundFunction) {
        if (this.type2 == JSElementTypes.EMPTY_STATEMENT || this.type1 == JSElementTypes.EMPTY_STATEMENT) {
            this.setSingleSpace(this.type1 == JSElementTypes.EMPTY_STATEMENT);
            return;
        }
        super.processBlock(blankLinesAroundFunction);
    }

    public void visitFile(ASTNode node) {
        if (this.type1 instanceof QmlImportDeclarationElementType && !(this.type2 instanceof QmlImportDeclarationElementType) && !JSTokenTypes.COMMENTS.contains(this.type2)) {
            int minLines = this.myCommonSettings.BLANK_LINES_AFTER_IMPORTS;
            if (this.type2 == QmlElementTypes.QML_ELEMENT_DECLARATION) {
                minLines = Math.max(this.myCommonSettings.BLANK_LINES_AROUND_CLASS, this.myCommonSettings.BLANK_LINES_AFTER_IMPORTS);
            }
            this.setBlankLines(minLines, this.myCommonSettings.KEEP_BLANK_LINES_IN_CODE);
            return;
        }
        super.visitFile(node);
    }

    public void visitFunctionExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.COLON && this.type2 == JSTokenTypes.LBRACE) {
            this.setSpaceBeforeLBraceIfMultiline(this.myCustomSettings.FUNCTION_EXPRESSION_BRACE_STYLE, this.myCommonSettings.SPACE_BEFORE_METHOD_LBRACE, this.myCommonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE);
            return;
        }
        super.visitFunctionExpression(node);
    }

    public void visitElement(ASTNode node) {
        if (node.getElementType() == QmlElementTypes.QML_ELEMENT_DECLARATION && this.type2 instanceof JSBlockStatementElementType) {
            TextRange range = QmlSpacingProcessor.getRangeInside((ASTNode)this.myChild2, (IElementType)JSTokenTypes.LBRACE, (IElementType)JSTokenTypes.RBRACE);
            if (range != null) {
                this.setSpaceBeforeLBraceIfMultiline(this.myCommonSettings.CLASS_BRACE_STYLE, this.myCustomSettings.SPACE_BEFORE_CLASS_LBRACE, this.myCommonSettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE, range);
            }
            return;
        }
        if (node.getElementType() instanceof QmlImportDeclarationElementType) {
            this.setSingleSpace(true);
            return;
        }
        super.visitElement(node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCodeStyleSettings", "com/intellij/lang/qml/formatter/QmlSpacingProcessor", "<init>"));
    }
}

