/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.attach;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkWithHoverInfo;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.ide.IdeEventQueue;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.attach.JSDebuggerUrlFilterKt;
import com.intellij.javascript.debugger.attach.statistics.JavaScriptDebuggerEntrypointUsageCounter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0014R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/debugger/attach/JSDebuggerUrlFilter;", "Lcom/intellij/execution/filters/UrlFilter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "currentLink", "Lkotlin/Pair;", "Ljavax/swing/JComponent;", "Ljava/awt/Rectangle;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "buildHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "url", "JSDebuggerStarterHyperlinkInfo", "intellij.javascript.chrome.connector"})
@SourceDebugExtension(value={"SMAP\nJSDebuggerUrlFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSDebuggerUrlFilter.kt\ncom/intellij/javascript/debugger/attach/JSDebuggerUrlFilter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,146:1\n12567#2,2:147\n*S KotlinDebug\n*F\n+ 1 JSDebuggerUrlFilter.kt\ncom/intellij/javascript/debugger/attach/JSDebuggerUrlFilter\n*L\n39#1:147,2\n*E\n"})
public final class JSDebuggerUrlFilter
extends UrlFilter {
    @Nullable
    private Pair<? extends JComponent, ? extends Rectangle> currentLink;

    public JSDebuggerUrlFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        block5: {
            block4: {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                    if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"://", (boolean)false, (int)2, null)) break block4;
                    String[] $this$any$iv = JSDebuggerUrlFilterKt.getDEBUGGABLE_URL_PREFIXES();
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        String element$iv;
                        String it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!StringsKt.contains$default((CharSequence)line, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (bl) break block5;
            }
            return null;
        }
        return super.applyFilter(line, entireLength);
    }

    @NotNull
    protected HyperlinkInfo buildHyperlinkInfo(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HyperlinkInfo hyperlinkInfo = super.buildHyperlinkInfo(url);
        Intrinsics.checkNotNullExpressionValue((Object)hyperlinkInfo, (String)"buildHyperlinkInfo(...)");
        HyperlinkInfo baseHyperlinkInfo = hyperlinkInfo;
        if (!JSDebuggerUrlFilterKt.isLocalHostUrl(url)) {
            return baseHyperlinkInfo;
        }
        JavaScriptDebuggerEntrypointUsageCounter.INSTANCE.logDebuggableUrlShown();
        return (HyperlinkInfo)new JSDebuggerStarterHyperlinkInfo(url, baseHyperlinkInfo);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javascript/debugger/attach/JSDebuggerUrlFilter$JSDebuggerStarterHyperlinkInfo;", "Lcom/intellij/execution/filters/HyperlinkWithHoverInfo;", "url", "", "baseHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "<init>", "(Lcom/intellij/javascript/debugger/attach/JSDebuggerUrlFilter;Ljava/lang/String;Lcom/intellij/execution/filters/HyperlinkInfo;)V", "getUrl", "()Ljava/lang/String;", "navigate", "", "project", "Lcom/intellij/openapi/project/Project;", "showNotification", "onMouseEntered", "hostComponent", "Ljavax/swing/JComponent;", "linkBounds", "Ljava/awt/Rectangle;", "onMouseExited", "intellij.javascript.chrome.connector"})
    public final class JSDebuggerStarterHyperlinkInfo
    implements HyperlinkWithHoverInfo {
        @NotNull
        private final String url;
        @NotNull
        private final HyperlinkInfo baseHyperlinkInfo;

        public JSDebuggerStarterHyperlinkInfo(@NotNull String url, HyperlinkInfo baseHyperlinkInfo) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)baseHyperlinkInfo, (String)"baseHyperlinkInfo");
            this.url = url;
            this.baseHyperlinkInfo = baseHyperlinkInfo;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public void navigate(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            AWTEvent currentEvent = IdeEventQueue.Companion.getInstance().getTrueCurrentEvent();
            if (currentEvent instanceof MouseEvent && UIUtil.isControlKeyDown((MouseEvent)((MouseEvent)currentEvent)) && ((MouseEvent)currentEvent).isShiftDown()) {
                JavaScriptDebuggerEntrypointUsageCounter.INSTANCE.logDebuggableUrlClicked();
                JSDebuggerUrlFilterKt.startJavaScriptDebugRunConfiguration(project, this.url);
            } else {
                this.showNotification(project);
                this.baseHyperlinkInfo.navigate(project);
            }
        }

        private final void showNotification(Project project) {
            Pair pair = JSDebuggerUrlFilter.this.currentLink;
            if (pair == null) {
                return;
            }
            Pair currentLink = pair;
            Disposable disposable = Disposer.newDisposable((Disposable)((Disposable)project), (String)"js.debugger.terminal.start.debugger.from.url");
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable notificationDisposable = disposable;
            Object[] objectArray = new Object[]{ClientSystemInfo.Companion.isMac() ? "Cmd" : "Ctrl"};
            String string = JSDebuggerBundle.message((String)"js.debugger.terminal.start.debugger.from.url", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            GotItTooltip gotItTooltip = new GotItTooltip("js.debugger.terminal.start.debugger.from.url", message, notificationDisposable).withPosition(Balloon.Position.above);
            String string2 = JSDebuggerBundle.message((String)"js.debugger.terminal.start.debugger.from.url.more", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            GotItTooltip tooltip = gotItTooltip.withLink(string2, JSDebuggerStarterHyperlinkInfo::showNotification$lambda$0);
            if (!tooltip.canShow()) {
                Disposer.dispose((Disposable)notificationDisposable);
                return;
            }
            tooltip.show((JComponent)currentLink.getFirst(), (arg_0, arg_1) -> JSDebuggerStarterHyperlinkInfo.showNotification$lambda$1(currentLink, arg_0, arg_1));
        }

        public void onMouseEntered(@NotNull JComponent hostComponent, @NotNull Rectangle linkBounds) {
            Intrinsics.checkNotNullParameter((Object)hostComponent, (String)"hostComponent");
            Intrinsics.checkNotNullParameter((Object)linkBounds, (String)"linkBounds");
            JSDebuggerUrlFilter.this.currentLink = new Pair((Object)hostComponent, (Object)linkBounds);
        }

        public void onMouseExited() {
            JSDebuggerUrlFilter.this.currentLink = null;
        }

        private static final Unit showNotification$lambda$0() {
            HelpManager.getInstance().invokeHelp("wsStartJSDebugFromTerminal");
            return Unit.INSTANCE;
        }

        private static final Point showNotification$lambda$1(Pair $currentLink, Component component, Balloon balloon) {
            Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
            BalloonImpl balloonImpl = (BalloonImpl)balloon;
            Rectangle bounds = (Rectangle)$currentLink.getSecond();
            int shiftY = BalloonImpl.getAbstractPositionFor((Balloon.Position)Balloon.Position.below) != balloonImpl.getPosition() ? 0 : bounds.height;
            return new Point(bounds.x + Math.min(JBUIScale.scale((int)20), bounds.width / 2), bounds.y + shiftY);
        }
    }
}

