/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import groovy.lang.Script;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReplacementBuilder {
    @NotNull
    private final String replacement;
    private final MultiMap<String, ParameterInfo> parameterizations;
    private final Map<String, ScriptSupport> replacementVarsMap;
    private final ReplaceOptions options;
    private final Project myProject;

    ReplacementBuilder(@NotNull Project project2, @NotNull ReplaceOptions options) {
        if (project2 == null) {
            ReplacementBuilder.$$$reportNull$$$0(0);
        }
        if (options == null) {
            ReplacementBuilder.$$$reportNull$$$0(1);
        }
        this.parameterizations = MultiMap.createLinked();
        this.replacementVarsMap = new HashMap<String, ScriptSupport>();
        this.myProject = project2;
        this.options = options;
        Template template = TemplateManager.getInstance((Project)project2).createTemplate("", "", options.getReplacement());
        this.replacement = template.getTemplateText();
        int prevOffset = 0;
        for (int i = 0; i < template.getSegmentsCount(); ++i) {
            int pos;
            String name;
            int offset = template.getSegmentOffset(i);
            ParameterInfo info = new ParameterInfo(name, offset, options.getVariableDefinition(name = template.getSegmentName(i)) != null);
            for (pos = offset - 1; pos >= prevOffset && pos < this.replacement.length() && StringUtil.isWhiteSpace((char)this.replacement.charAt(pos)); --pos) {
            }
            if (pos >= 0) {
                if (this.replacement.charAt(pos) == ',') {
                    info.setHasCommaBefore(true);
                }
                while (pos > prevOffset && StringUtil.isWhiteSpace((char)this.replacement.charAt(pos - 1))) {
                    --pos;
                }
                info.setBeforeDelimiterPos(pos);
            }
            for (pos = offset; pos < this.replacement.length() && StringUtil.isWhiteSpace((char)this.replacement.charAt(pos)); ++pos) {
            }
            if (pos < this.replacement.length()) {
                char ch = this.replacement.charAt(pos);
                if (ch == ';') {
                    info.setStatementContext(true);
                } else if (ch == ',' || ch == ')') {
                    info.setArgumentContext(true);
                    info.setHasCommaAfter(ch == ',');
                }
            }
            info.setAfterDelimiterPos(pos);
            prevOffset = offset;
            this.parameterizations.putValue((Object)name, (Object)info);
        }
        LanguageFileType fileType = options.getMatchOptions().getFileType();
        final StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(fileType);
        if (profile != null) {
            try {
                Language dialect = options.getMatchOptions().getDialect();
                assert (dialect != null);
                PatternContextInfo context = new PatternContextInfo(PatternTreeContext.Block, options.getMatchOptions().getPatternContext());
                PsiElement[] elements = MatcherImplUtil.createTreeFromText(this.prepareReplacementPattern(), context, fileType, dialect, project2, false);
                if (elements.length > 0) {
                    PsiElement patternNode = elements[0].getParent();
                    patternNode.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(@NotNull PsiElement element) {
                            String text;
                            if (element == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (profile.isReplacementTypedVariable(text = element.getText())) {
                                Collection<ParameterInfo> infos = ReplacementBuilder.this.findParameterization(profile.stripReplacementTypedVariableDecorations(text));
                                for (ParameterInfo info : infos) {
                                    if (info.getElement() != null) continue;
                                    info.setElement(element);
                                    return;
                                }
                            }
                            super.visitElement(element);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/plugin/replace/impl/ReplacementBuilder$1", "visitElement"));
                        }
                    });
                    profile.provideAdditionalReplaceOptions(patternNode, options, this);
                }
            }
            catch (IncorrectOperationException e) {
                throw new MalformedPatternException(e.getMessage());
            }
        }
    }

    @NotNull
    String process(@NotNull MatchResult match2, @NotNull ReplacementInfo replacementInfo, @NotNull LanguageFileType type) {
        if (match2 == null) {
            ReplacementBuilder.$$$reportNull$$$0(2);
        }
        if (replacementInfo == null) {
            ReplacementBuilder.$$$reportNull$$$0(3);
        }
        if (type == null) {
            ReplacementBuilder.$$$reportNull$$$0(4);
        }
        if (this.parameterizations.isEmpty()) {
            String string = this.replacement;
            if (string == null) {
                ReplacementBuilder.$$$reportNull$$$0(5);
            }
            return string;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(type);
        assert (profile != null);
        SmartList sorted = new SmartList(this.parameterizations.values());
        sorted.sort(Comparator.comparingInt(ParameterInfo::getStartIndex).reversed());
        StringBuilder result2 = new StringBuilder(this.replacement);
        for (ParameterInfo info : sorted) {
            MatchResult r = replacementInfo.getNamedMatchResult(info.getName());
            if (info.isReplacementVariable()) {
                Object replacement = this.generateReplacement(info, match2);
                if (replacement == null && r != null) {
                    profile.handleSubstitution(info, r, result2, replacementInfo);
                    continue;
                }
                Replacer.insertSubstitution(result2, 0, info, String.valueOf(replacement));
                continue;
            }
            if (r != null) {
                profile.handleSubstitution(info, r, result2, replacementInfo);
                continue;
            }
            profile.handleNoSubstitution(info, result2);
        }
        String string = result2.toString();
        if (string == null) {
            ReplacementBuilder.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private Object generateReplacement(@NotNull ParameterInfo info, @NotNull MatchResult match2) {
        ScriptSupport scriptSupport;
        if (info == null) {
            ReplacementBuilder.$$$reportNull$$$0(7);
        }
        if (match2 == null) {
            ReplacementBuilder.$$$reportNull$$$0(8);
        }
        if ((scriptSupport = this.replacementVarsMap.get(info.getName())) == null) {
            String constraint = this.options.getVariableDefinition(info.getName()).getScriptCodeConstraint();
            List variableNames = ContainerUtil.map(this.options.getVariableDefinitions(), o -> o.getName());
            String name = info.getName();
            String scriptText = StringUtil.unquoteString((String)constraint);
            try {
                Script script = ScriptSupport.buildScript(name, scriptText, this.options.getMatchOptions());
                scriptSupport = new ScriptSupport(this.myProject, script, name, variableNames);
                this.replacementVarsMap.put(info.getName(), scriptSupport);
            }
            catch (MalformedPatternException e) {
                return null;
            }
        }
        return scriptSupport.evaluate(match2, null);
    }

    public Collection<ParameterInfo> findParameterization(String name) {
        return this.parameterizations.get((Object)name);
    }

    public ParameterInfo findParameterization(PsiElement element) {
        if (element == null) {
            return null;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
        assert (profile != null);
        String text = element.getText();
        if (!profile.isReplacementTypedVariable(text)) {
            return null;
        }
        return (ParameterInfo)((Object)ContainerUtil.find(this.findParameterization(profile.stripReplacementTypedVariableDecorations(text)), info -> info.getElement() == element));
    }

    @NotNull
    public String prepareReplacementPattern() {
        LanguageFileType fileType = this.options.getMatchOptions().getFileType();
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(fileType);
        assert (profile != null);
        StringBuilder buf = new StringBuilder();
        Template template = TemplateManager.getInstance((Project)this.myProject).createTemplate("", "", this.options.getReplacement());
        int segmentsCount = template.getSegmentsCount();
        String text = template.getTemplateText();
        int prevOffset = 0;
        for (int i = 0; i < segmentsCount; ++i) {
            int offset = template.getSegmentOffset(i);
            String name = template.getSegmentName(i);
            String compiledName = profile.compileReplacementTypedVariable(name);
            buf.append(text, prevOffset, offset).append(compiledName);
            prevOffset = offset;
        }
        buf.append(text.substring(prevOffset));
        String string = buf.toString();
        if (string == null) {
            ReplacementBuilder.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/replace/impl/ReplacementBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/replace/impl/ReplacementBuilder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareReplacementPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateReplacement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 9 -> new IllegalStateException(string);
        };
    }
}

