/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.clones.index.HashFragmentIndexKt;
import com.jetbrains.clones.index.HashFragmentIndexer;
import com.jetbrains.clones.index.HashIndexFileFilter;
import com.jetbrains.clones.index.TextRangesExternalizer;
import com.jetbrains.clones.structures.CodeFragment;
import com.jetbrains.clones.structures.FileCodeFragment;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u001c\u0012\b\u0012\u00060\u0002j\u0002`\u0003\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00060\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0002H\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0010H\u0016J\"\u0010\u0011\u001a\u001c\u0012\b\u0012\u00060\u0002j\u0002`\u0003\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00060\u0012H\u0016J.\u0010\u0013\u001a(\u0012\b\u0012\u00060\u0002j\u0002`\u0003\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/clones/index/HashFragmentIndex;", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "", "Lcom/jetbrains/clones/index/HashKey;", "Ljava/util/HashSet;", "Lcom/jetbrains/clones/structures/CodeFragment;", "Lcom/jetbrains/clones/index/CodeFragments;", "<init>", "()V", "hasSnapshotMapping", "", "getVersion", "dependsOnFileContent", "getValueExternalizer", "Lcom/jetbrains/clones/index/TextRangesExternalizer;", "getKeyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "getName", "Lcom/intellij/util/indexing/ID;", "getIndexer", "Lcom/intellij/util/indexing/DataIndexer;", "Lkotlin/collections/HashSet;", "Lcom/intellij/util/indexing/FileContent;", "getInputFilter", "Lcom/jetbrains/clones/index/HashIndexFileFilter;", "Companion", "intellij.platform.duplicatesDetector"})
public final class HashFragmentIndex
extends FileBasedIndexExtension<Integer, HashSet<CodeFragment>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ID<Integer, HashSet<CodeFragment>> NAME;
    private static final int tooManyDuplicatesLevel = 200;

    public boolean hasSnapshotMapping() {
        return true;
    }

    public int getVersion() {
        return 19111503;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public TextRangesExternalizer getValueExternalizer() {
        return TextRangesExternalizer.INSTANCE;
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)enumeratorIntegerDescriptor, (String)"INSTANCE");
        return (KeyDescriptor)enumeratorIntegerDescriptor;
    }

    @NotNull
    public ID<Integer, HashSet<CodeFragment>> getName() {
        return NAME;
    }

    @NotNull
    public DataIndexer<Integer, HashSet<CodeFragment>, FileContent> getIndexer() {
        return (DataIndexer)HashFragmentIndexer.INSTANCE;
    }

    @NotNull
    public HashIndexFileFilter getInputFilter() {
        return new HashIndexFileFilter();
    }

    static {
        ID iD = ID.create((String)"HashFragmentIndex");
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"create(...)");
        NAME = iD;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u00112\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u00162\n\u0010\u0017\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R+\u0010\u0004\u001a\u001c\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/clones/index/HashFragmentIndex$Companion;", "", "<init>", "()V", "NAME", "Lcom/intellij/util/indexing/ID;", "", "Lcom/jetbrains/clones/index/HashKey;", "Ljava/util/HashSet;", "Lcom/jetbrains/clones/structures/CodeFragment;", "Lcom/jetbrains/clones/index/CodeFragments;", "getNAME", "()Lcom/intellij/util/indexing/ID;", "tooManyDuplicatesLevel", "requestRebuild", "", "findTextRangesInFile", "", "Lcom/jetbrains/clones/structures/FileCodeFragment;", "file", "Lcom/intellij/psi/PsiFile;", "getFragments", "Lcom/intellij/util/indexing/FileBasedIndex;", "hash", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.platform.duplicatesDetector"})
    @SourceDebugExtension(value={"SMAP\nHashFragmentIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashFragmentIndex.kt\ncom/jetbrains/clones/index/HashFragmentIndex$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1863#2,2:77\n*S KotlinDebug\n*F\n+ 1 HashFragmentIndex.kt\ncom/jetbrains/clones/index/HashFragmentIndex$Companion\n*L\n43#1:77,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ID<Integer, HashSet<CodeFragment>> getNAME() {
            return NAME;
        }

        public final void requestRebuild() {
            block0: {
                FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                if (fileBasedIndex == null) break block0;
                fileBasedIndex.requestRebuild(this.getNAME());
            }
        }

        @NotNull
        public final List<List<FileCodeFragment>> findTextRangesInFile(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            FileBasedIndex index = FileBasedIndex.getInstance();
            Map map = index.getFileData(this.getNAME(), file.getVirtualFile(), file.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getFileData(...)");
            Map fileData = map;
            if (fileData.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)file.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
            GlobalSearchScope scope = globalSearchScope;
            return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)fileData.keySet()), arg_0 -> Companion.findTextRangesInFile$lambda$0(index, scope, arg_0)), Companion::findTextRangesInFile$lambda$1));
        }

        private final List<FileCodeFragment> getFragments(FileBasedIndex $this$getFragments, int hash, GlobalSearchScope scope) {
            SmartList list2 = new SmartList();
            HashFragmentIndexKt.access$processValues($this$getFragments, this.getNAME(), scope, hash, (arg_0, arg_1) -> Companion.getFragments$lambda$3(list2, arg_0, arg_1));
            return list2.size() < 200 ? (List)list2 : CollectionsKt.emptyList();
        }

        private static final List findTextRangesInFile$lambda$0(FileBasedIndex $index, GlobalSearchScope $scope, Integer it) {
            Intrinsics.checkNotNull((Object)$index);
            Intrinsics.checkNotNull((Object)it);
            return Companion.getFragments($index, it, $scope);
        }

        private static final boolean findTextRangesInFile$lambda$1(List it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.size() > 1;
        }

        private static final boolean getFragments$lambda$3(SmartList $list, VirtualFile file, HashSet codeFragments) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)codeFragments, (String)"codeFragments");
            Iterable $this$forEach$iv = codeFragments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CodeFragment codeFragment = (CodeFragment)element$iv;
                boolean bl = false;
                $list.add((Object)new FileCodeFragment(file, codeFragment));
                if ($list.size() < 200) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

