--[[--
value =              -- value of header as string containing comma (and space) separated values
request.get_header(
  key                -- name of header, e.g. "Authorization"
)

Returns the value of an HTTP header sent by the client. If the header occurs multiple times, the values are concatenated with a comma and zero or more space characters (e.g. "value1, value2"). If the header is missing, nil is returned.

--]]--

function request.get_header(key)
  local http_request = request._http_request
  local values = http_request.headers[key]
  if #values == 0 then
    return nil
  elseif #values == 1 then
    return values[1]
  else
    return http_request.headers_csv_string[key]
  end
end
