--[[--
slot.set_layout(
  layout_ident,   -- name of layout or nil for binary data in slot named "data"
  content_type    -- content-type to be sent to the browser, or nil for default
)

This function selects which layout should be used when calling slot.render_layout() (as done by request.handler(...)). If nil is selected as layout, then no layout will be used, but the slot named "data" is used plainly. The second argument to slot.set_layout is the content-type which is sent to the browser.

The default layout for views is "default" (but errors get a default layout named "system_error"). Actions have no default layout, but an explicit call of slot.set_layout(...) (even with nil as first argument) during request handling will cause subsequent calls of slot.layout_is_set() to return true which indicates that content (e.g. via slot.put_into("data", ...)) is available and should be rendered instead of using the action's return value to forward or redirect the user agent.

--]]--

function slot.set_layout(layout_ident, content_type)
  request.configure(function()
    slot._current_layout = layout_ident
    slot._content_type = content_type
  end)
  if request.is_in_progress() then
    slot._layout_set = true
  end
end
