package virtualmachineimagebuilder

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ProvisioningErrorCode enumerates the values for provisioning error code.
type ProvisioningErrorCode string

const (
	// BadCustomizerType ...
	BadCustomizerType ProvisioningErrorCode = "BadCustomizerType"
	// BadISOSource ...
	BadISOSource ProvisioningErrorCode = "BadISOSource"
	// BadPIRSource ...
	BadPIRSource ProvisioningErrorCode = "BadPIRSource"
	// BadSourceType ...
	BadSourceType ProvisioningErrorCode = "BadSourceType"
	// NoCustomizerShellScript ...
	NoCustomizerShellScript ProvisioningErrorCode = "NoCustomizerShellScript"
	// Other ...
	Other ProvisioningErrorCode = "Other"
	// ServerError ...
	ServerError ProvisioningErrorCode = "ServerError"
)

// PossibleProvisioningErrorCodeValues returns an array of possible values for the ProvisioningErrorCode const type.
func PossibleProvisioningErrorCodeValues() []ProvisioningErrorCode {
	return []ProvisioningErrorCode{BadCustomizerType, BadISOSource, BadPIRSource, BadSourceType, NoCustomizerShellScript, Other, ServerError}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Creating, Deleting, Failed, Succeeded}
}

// ProvisioningState1 enumerates the values for provisioning state 1.
type ProvisioningState1 string

const (
	// ProvisioningState1Creating ...
	ProvisioningState1Creating ProvisioningState1 = "Creating"
	// ProvisioningState1Deleting ...
	ProvisioningState1Deleting ProvisioningState1 = "Deleting"
	// ProvisioningState1Failed ...
	ProvisioningState1Failed ProvisioningState1 = "Failed"
	// ProvisioningState1Succeeded ...
	ProvisioningState1Succeeded ProvisioningState1 = "Succeeded"
)

// PossibleProvisioningState1Values returns an array of possible values for the ProvisioningState1 const type.
func PossibleProvisioningState1Values() []ProvisioningState1 {
	return []ProvisioningState1{ProvisioningState1Creating, ProvisioningState1Deleting, ProvisioningState1Failed, ProvisioningState1Succeeded}
}

// RunState enumerates the values for run state.
type RunState string

const (
	// RunStateFailed ...
	RunStateFailed RunState = "failed"
	// RunStatePartiallySucceeded ...
	RunStatePartiallySucceeded RunState = "partiallySucceeded"
	// RunStateReady ...
	RunStateReady RunState = "ready"
	// RunStateRunning ...
	RunStateRunning RunState = "running"
	// RunStateSucceeded ...
	RunStateSucceeded RunState = "succeeded"
)

// PossibleRunStateValues returns an array of possible values for the RunState const type.
func PossibleRunStateValues() []RunState {
	return []RunState{RunStateFailed, RunStatePartiallySucceeded, RunStateReady, RunStateRunning, RunStateSucceeded}
}

// RunSubState enumerates the values for run sub state.
type RunSubState string

const (
	// Building ...
	Building RunSubState = "building"
	// Customizing ...
	Customizing RunSubState = "customizing"
	// Distributing ...
	Distributing RunSubState = "distributing"
	// Queued ...
	Queued RunSubState = "queued"
)

// PossibleRunSubStateValues returns an array of possible values for the RunSubState const type.
func PossibleRunSubStateValues() []RunSubState {
	return []RunSubState{Building, Customizing, Distributing, Queued}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeImageTemplateSource ...
	TypeImageTemplateSource Type = "ImageTemplateSource"
	// TypeISO ...
	TypeISO Type = "ISO"
	// TypePlatformImage ...
	TypePlatformImage Type = "PlatformImage"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeImageTemplateSource, TypeISO, TypePlatformImage}
}

// TypeBasicImageTemplateCustomizer enumerates the values for type basic image template customizer.
type TypeBasicImageTemplateCustomizer string

const (
	// TypeImageTemplateCustomizer ...
	TypeImageTemplateCustomizer TypeBasicImageTemplateCustomizer = "ImageTemplateCustomizer"
	// TypeShell ...
	TypeShell TypeBasicImageTemplateCustomizer = "shell"
)

// PossibleTypeBasicImageTemplateCustomizerValues returns an array of possible values for the TypeBasicImageTemplateCustomizer const type.
func PossibleTypeBasicImageTemplateCustomizerValues() []TypeBasicImageTemplateCustomizer {
	return []TypeBasicImageTemplateCustomizer{TypeImageTemplateCustomizer, TypeShell}
}

// TypeBasicImageTemplateDistributor enumerates the values for type basic image template distributor.
type TypeBasicImageTemplateDistributor string

const (
	// TypeImageTemplateDistributor ...
	TypeImageTemplateDistributor TypeBasicImageTemplateDistributor = "ImageTemplateDistributor"
	// TypeManagedImage ...
	TypeManagedImage TypeBasicImageTemplateDistributor = "managedImage"
	// TypeSharedImage ...
	TypeSharedImage TypeBasicImageTemplateDistributor = "sharedImage"
)

// PossibleTypeBasicImageTemplateDistributorValues returns an array of possible values for the TypeBasicImageTemplateDistributor const type.
func PossibleTypeBasicImageTemplateDistributorValues() []TypeBasicImageTemplateDistributor {
	return []TypeBasicImageTemplateDistributor{TypeImageTemplateDistributor, TypeManagedImage, TypeSharedImage}
}
