package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeExperimentEnv invokes the airec.DescribeExperimentEnv API synchronously
func (client *Client) DescribeExperimentEnv(request *DescribeExperimentEnvRequest) (response *DescribeExperimentEnvResponse, err error) {
	response = CreateDescribeExperimentEnvResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeExperimentEnvWithChan invokes the airec.DescribeExperimentEnv API asynchronously
func (client *Client) DescribeExperimentEnvWithChan(request *DescribeExperimentEnvRequest) (<-chan *DescribeExperimentEnvResponse, <-chan error) {
	responseChan := make(chan *DescribeExperimentEnvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeExperimentEnv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeExperimentEnvWithCallback invokes the airec.DescribeExperimentEnv API asynchronously
func (client *Client) DescribeExperimentEnvWithCallback(request *DescribeExperimentEnvRequest, callback func(response *DescribeExperimentEnvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeExperimentEnvResponse
		var err error
		defer close(result)
		response, err = client.DescribeExperimentEnv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeExperimentEnvRequest is the request struct for api DescribeExperimentEnv
type DescribeExperimentEnvRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"instanceId"`
	SceneId    string `position:"Path" name:"sceneId"`
}

// DescribeExperimentEnvResponse is the response struct for api DescribeExperimentEnv
type DescribeExperimentEnvResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateDescribeExperimentEnvRequest creates a request to invoke DescribeExperimentEnv API
func CreateDescribeExperimentEnvRequest() (request *DescribeExperimentEnvRequest) {
	request = &DescribeExperimentEnvRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "DescribeExperimentEnv", "/v2/openapi/instances/[instanceId]/scenes/[sceneId]/experiment-env", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeExperimentEnvResponse creates a response to parse from DescribeExperimentEnv response
func CreateDescribeExperimentEnvResponse() (response *DescribeExperimentEnvResponse) {
	response = &DescribeExperimentEnvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
