package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListItems invokes the airec.ListItems API synchronously
func (client *Client) ListItems(request *ListItemsRequest) (response *ListItemsResponse, err error) {
	response = CreateListItemsResponse()
	err = client.DoAction(request, response)
	return
}

// ListItemsWithChan invokes the airec.ListItems API asynchronously
func (client *Client) ListItemsWithChan(request *ListItemsRequest) (<-chan *ListItemsResponse, <-chan error) {
	responseChan := make(chan *ListItemsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListItems(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListItemsWithCallback invokes the airec.ListItems API asynchronously
func (client *Client) ListItemsWithCallback(request *ListItemsRequest, callback func(response *ListItemsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListItemsResponse
		var err error
		defer close(result)
		response, err = client.ListItems(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListItemsRequest is the request struct for api ListItems
type ListItemsRequest struct {
	*requests.RoaRequest
	InstanceId string           `position:"Path" name:"instanceId"`
	Size       requests.Integer `position:"Query" name:"size"`
	Page       requests.Integer `position:"Query" name:"page"`
}

// ListItemsResponse is the response struct for api ListItems
type ListItemsResponse struct {
	*responses.BaseResponse
	RequestId string            `json:"requestId" xml:"requestId"`
	Result    ResultInListItems `json:"result" xml:"result"`
}

// CreateListItemsRequest creates a request to invoke ListItems API
func CreateListItemsRequest() (request *ListItemsRequest) {
	request = &ListItemsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "ListItems", "/v2/openapi/instances/[instanceId]/items/actions/list", "airec", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListItemsResponse creates a response to parse from ListItems response
func CreateListItemsResponse() (response *ListItemsResponse) {
	response = &ListItemsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
