package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryReleaseMetric invokes the arms.QueryReleaseMetric API synchronously
func (client *Client) QueryReleaseMetric(request *QueryReleaseMetricRequest) (response *QueryReleaseMetricResponse, err error) {
	response = CreateQueryReleaseMetricResponse()
	err = client.DoAction(request, response)
	return
}

// QueryReleaseMetricWithChan invokes the arms.QueryReleaseMetric API asynchronously
func (client *Client) QueryReleaseMetricWithChan(request *QueryReleaseMetricRequest) (<-chan *QueryReleaseMetricResponse, <-chan error) {
	responseChan := make(chan *QueryReleaseMetricResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryReleaseMetric(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryReleaseMetricWithCallback invokes the arms.QueryReleaseMetric API asynchronously
func (client *Client) QueryReleaseMetricWithCallback(request *QueryReleaseMetricRequest, callback func(response *QueryReleaseMetricResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryReleaseMetricResponse
		var err error
		defer close(result)
		response, err = client.QueryReleaseMetric(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryReleaseMetricRequest is the request struct for api QueryReleaseMetric
type QueryReleaseMetricRequest struct {
	*requests.RpcRequest
	ChangeOrderId    string           `position:"Query" name:"ChangeOrderId"`
	MetricType       string           `position:"Query" name:"MetricType"`
	CreateTime       requests.Integer `position:"Query" name:"CreateTime"`
	Pid              string           `position:"Query" name:"Pid"`
	ProxyUserId      string           `position:"Query" name:"ProxyUserId"`
	ReleaseEndTime   requests.Integer `position:"Query" name:"ReleaseEndTime"`
	Service          string           `position:"Query" name:"Service"`
	ReleaseStartTime requests.Integer `position:"Query" name:"ReleaseStartTime"`
}

// QueryReleaseMetricResponse is the response struct for api QueryReleaseMetric
type QueryReleaseMetricResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateQueryReleaseMetricRequest creates a request to invoke QueryReleaseMetric API
func CreateQueryReleaseMetricRequest() (request *QueryReleaseMetricRequest) {
	request = &QueryReleaseMetricRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "QueryReleaseMetric", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryReleaseMetricResponse creates a response to parse from QueryReleaseMetric response
func CreateQueryReleaseMetricResponse() (response *QueryReleaseMetricResponse) {
	response = &QueryReleaseMetricResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
