package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Apply400ManagerIdentify invokes the cloudcallcenter.Apply400ManagerIdentify API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/apply400manageridentify.html
func (client *Client) Apply400ManagerIdentify(request *Apply400ManagerIdentifyRequest) (response *Apply400ManagerIdentifyResponse, err error) {
	response = CreateApply400ManagerIdentifyResponse()
	err = client.DoAction(request, response)
	return
}

// Apply400ManagerIdentifyWithChan invokes the cloudcallcenter.Apply400ManagerIdentify API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/apply400manageridentify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) Apply400ManagerIdentifyWithChan(request *Apply400ManagerIdentifyRequest) (<-chan *Apply400ManagerIdentifyResponse, <-chan error) {
	responseChan := make(chan *Apply400ManagerIdentifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Apply400ManagerIdentify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Apply400ManagerIdentifyWithCallback invokes the cloudcallcenter.Apply400ManagerIdentify API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/apply400manageridentify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) Apply400ManagerIdentifyWithCallback(request *Apply400ManagerIdentifyRequest, callback func(response *Apply400ManagerIdentifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Apply400ManagerIdentifyResponse
		var err error
		defer close(result)
		response, err = client.Apply400ManagerIdentify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Apply400ManagerIdentifyRequest is the request struct for api Apply400ManagerIdentify
type Apply400ManagerIdentifyRequest struct {
	*requests.RpcRequest
	WttorderId               string `position:"Query" name:"WttorderId"`
	ManagerCertExpDate       string `position:"Query" name:"ManagerCertExpDate"`
	ManagerMobilePhone       string `position:"Query" name:"ManagerMobilePhone"`
	Empowerment              string `position:"Query" name:"Empowerment"`
	Number                   string `position:"Query" name:"Number"`
	ManagerCertEffDate       string `position:"Query" name:"ManagerCertEffDate"`
	UnifiedstandardAgreement string `position:"Query" name:"UnifiedstandardAgreement"`
	SupplementaryMaterial    string `position:"Query" name:"SupplementaryMaterial"`
	ManagerName              string `position:"Query" name:"ManagerName"`
	ManagerCertPic           string `position:"Query" name:"ManagerCertPic"`
	CorpName                 string `position:"Query" name:"CorpName"`
	OldOrderId               string `position:"Query" name:"OldOrderId"`
	ManagerCertNumber        string `position:"Query" name:"ManagerCertNumber"`
	ManagerCertType          string `position:"Query" name:"ManagerCertType"`
}

// Apply400ManagerIdentifyResponse is the response struct for api Apply400ManagerIdentify
type Apply400ManagerIdentifyResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           string `json:"Data" xml:"Data"`
}

// CreateApply400ManagerIdentifyRequest creates a request to invoke Apply400ManagerIdentify API
func CreateApply400ManagerIdentifyRequest() (request *Apply400ManagerIdentifyRequest) {
	request = &Apply400ManagerIdentifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "Apply400ManagerIdentify", "", "")
	request.Method = requests.POST
	return
}

// CreateApply400ManagerIdentifyResponse creates a response to parse from Apply400ManagerIdentify response
func CreateApply400ManagerIdentifyResponse() (response *Apply400ManagerIdentifyResponse) {
	response = &Apply400ManagerIdentifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
