package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPredictiveJobGroupOverallStatus invokes the cloudcallcenter.ListPredictiveJobGroupOverallStatus API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listpredictivejobgroupoverallstatus.html
func (client *Client) ListPredictiveJobGroupOverallStatus(request *ListPredictiveJobGroupOverallStatusRequest) (response *ListPredictiveJobGroupOverallStatusResponse, err error) {
	response = CreateListPredictiveJobGroupOverallStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ListPredictiveJobGroupOverallStatusWithChan invokes the cloudcallcenter.ListPredictiveJobGroupOverallStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listpredictivejobgroupoverallstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPredictiveJobGroupOverallStatusWithChan(request *ListPredictiveJobGroupOverallStatusRequest) (<-chan *ListPredictiveJobGroupOverallStatusResponse, <-chan error) {
	responseChan := make(chan *ListPredictiveJobGroupOverallStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPredictiveJobGroupOverallStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPredictiveJobGroupOverallStatusWithCallback invokes the cloudcallcenter.ListPredictiveJobGroupOverallStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listpredictivejobgroupoverallstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPredictiveJobGroupOverallStatusWithCallback(request *ListPredictiveJobGroupOverallStatusRequest, callback func(response *ListPredictiveJobGroupOverallStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPredictiveJobGroupOverallStatusResponse
		var err error
		defer close(result)
		response, err = client.ListPredictiveJobGroupOverallStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPredictiveJobGroupOverallStatusRequest is the request struct for api ListPredictiveJobGroupOverallStatus
type ListPredictiveJobGroupOverallStatusRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ListPredictiveJobGroupOverallStatusResponse is the response struct for api ListPredictiveJobGroupOverallStatus
type ListPredictiveJobGroupOverallStatusResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	Code           string         `json:"Code" xml:"Code"`
	Message        string         `json:"Message" xml:"Message"`
	HttpStatusCode int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	OverallStatus  []KeyValuePair `json:"OverallStatus" xml:"OverallStatus"`
}

// CreateListPredictiveJobGroupOverallStatusRequest creates a request to invoke ListPredictiveJobGroupOverallStatus API
func CreateListPredictiveJobGroupOverallStatusRequest() (request *ListPredictiveJobGroupOverallStatusRequest) {
	request = &ListPredictiveJobGroupOverallStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListPredictiveJobGroupOverallStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateListPredictiveJobGroupOverallStatusResponse creates a response to parse from ListPredictiveJobGroupOverallStatus response
func CreateListPredictiveJobGroupOverallStatusResponse() (response *ListPredictiveJobGroupOverallStatusResponse) {
	response = &ListPredictiveJobGroupOverallStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
