package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVnRepeatingConfig invokes the cloudcallcenter.ModifyVnRepeatingConfig API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvnrepeatingconfig.html
func (client *Client) ModifyVnRepeatingConfig(request *ModifyVnRepeatingConfigRequest) (response *ModifyVnRepeatingConfigResponse, err error) {
	response = CreateModifyVnRepeatingConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVnRepeatingConfigWithChan invokes the cloudcallcenter.ModifyVnRepeatingConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvnrepeatingconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVnRepeatingConfigWithChan(request *ModifyVnRepeatingConfigRequest) (<-chan *ModifyVnRepeatingConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyVnRepeatingConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVnRepeatingConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVnRepeatingConfigWithCallback invokes the cloudcallcenter.ModifyVnRepeatingConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvnrepeatingconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVnRepeatingConfigWithCallback(request *ModifyVnRepeatingConfigRequest, callback func(response *ModifyVnRepeatingConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVnRepeatingConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyVnRepeatingConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVnRepeatingConfigRequest is the request struct for api ModifyVnRepeatingConfig
type ModifyVnRepeatingConfigRequest struct {
	*requests.RpcRequest
	Utterances *[]string `position:"Query" name:"Utterances"  type:"Repeated"`
	InstanceId string    `position:"Query" name:"InstanceId"`
}

// ModifyVnRepeatingConfigResponse is the response struct for api ModifyVnRepeatingConfig
type ModifyVnRepeatingConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVnRepeatingConfigRequest creates a request to invoke ModifyVnRepeatingConfig API
func CreateModifyVnRepeatingConfigRequest() (request *ModifyVnRepeatingConfigRequest) {
	request = &ModifyVnRepeatingConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ModifyVnRepeatingConfig", "", "")
	request.Method = requests.GET
	return
}

// CreateModifyVnRepeatingConfigResponse creates a response to parse from ModifyVnRepeatingConfig response
func CreateModifyVnRepeatingConfigResponse() (response *ModifyVnRepeatingConfigResponse) {
	response = &ModifyVnRepeatingConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
