package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutInstanceConfig invokes the cloudcallcenter.PutInstanceConfig API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/putinstanceconfig.html
func (client *Client) PutInstanceConfig(request *PutInstanceConfigRequest) (response *PutInstanceConfigResponse, err error) {
	response = CreatePutInstanceConfigResponse()
	err = client.DoAction(request, response)
	return
}

// PutInstanceConfigWithChan invokes the cloudcallcenter.PutInstanceConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/putinstanceconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PutInstanceConfigWithChan(request *PutInstanceConfigRequest) (<-chan *PutInstanceConfigResponse, <-chan error) {
	responseChan := make(chan *PutInstanceConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutInstanceConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutInstanceConfigWithCallback invokes the cloudcallcenter.PutInstanceConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/putinstanceconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PutInstanceConfigWithCallback(request *PutInstanceConfigRequest, callback func(response *PutInstanceConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutInstanceConfigResponse
		var err error
		defer close(result)
		response, err = client.PutInstanceConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutInstanceConfigRequest is the request struct for api PutInstanceConfig
type PutInstanceConfigRequest struct {
	*requests.RpcRequest
	InstanceId string    `position:"Query" name:"InstanceId"`
	Name       *[]string `position:"Query" name:"name"  type:"Repeated"`
	Value      *[]string `position:"Query" name:"value"  type:"Repeated"`
}

// PutInstanceConfigResponse is the response struct for api PutInstanceConfig
type PutInstanceConfigResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreatePutInstanceConfigRequest creates a request to invoke PutInstanceConfig API
func CreatePutInstanceConfigRequest() (request *PutInstanceConfigRequest) {
	request = &PutInstanceConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "PutInstanceConfig", "", "")
	request.Method = requests.POST
	return
}

// CreatePutInstanceConfigResponse creates a response to parse from PutInstanceConfig response
func CreatePutInstanceConfigResponse() (response *PutInstanceConfigResponse) {
	response = &PutInstanceConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
