package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBriefApConfig invokes the cloudwf.ListBriefApConfig API synchronously
// api document: https://help.aliyun.com/api/cloudwf/listbriefapconfig.html
func (client *Client) ListBriefApConfig(request *ListBriefApConfigRequest) (response *ListBriefApConfigResponse, err error) {
	response = CreateListBriefApConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ListBriefApConfigWithChan invokes the cloudwf.ListBriefApConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listbriefapconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListBriefApConfigWithChan(request *ListBriefApConfigRequest) (<-chan *ListBriefApConfigResponse, <-chan error) {
	responseChan := make(chan *ListBriefApConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBriefApConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBriefApConfigWithCallback invokes the cloudwf.ListBriefApConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listbriefapconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListBriefApConfigWithCallback(request *ListBriefApConfigRequest, callback func(response *ListBriefApConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBriefApConfigResponse
		var err error
		defer close(result)
		response, err = client.ListBriefApConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBriefApConfigRequest is the request struct for api ListBriefApConfig
type ListBriefApConfigRequest struct {
	*requests.RpcRequest
	SearchScan  requests.Integer `position:"Query" name:"SearchScan"`
	OrderCol    string           `position:"Query" name:"OrderCol"`
	SearchName  string           `position:"Query" name:"SearchName"`
	Length      requests.Integer `position:"Query" name:"Length"`
	SearchMac   string           `position:"Query" name:"SearchMac"`
	PageIndex   requests.Integer `position:"Query" name:"PageIndex"`
	OrderDir    string           `position:"Query" name:"OrderDir"`
	SearchModel string           `position:"Query" name:"SearchModel"`
}

// ListBriefApConfigResponse is the response struct for api ListBriefApConfig
type ListBriefApConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateListBriefApConfigRequest creates a request to invoke ListBriefApConfig API
func CreateListBriefApConfigRequest() (request *ListBriefApConfigRequest) {
	request = &ListBriefApConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ListBriefApConfig", "cloudwf", "openAPI")
	return
}

// CreateListBriefApConfigResponse creates a response to parse from ListBriefApConfig response
func CreateListBriefApConfigResponse() (response *ListBriefApConfigResponse) {
	response = &ListBriefApConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
