package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopGroupInfo invokes the cloudwf.ShopGroupInfo API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopgroupinfo.html
func (client *Client) ShopGroupInfo(request *ShopGroupInfoRequest) (response *ShopGroupInfoResponse, err error) {
	response = CreateShopGroupInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ShopGroupInfoWithChan invokes the cloudwf.ShopGroupInfo API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopgroupinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopGroupInfoWithChan(request *ShopGroupInfoRequest) (<-chan *ShopGroupInfoResponse, <-chan error) {
	responseChan := make(chan *ShopGroupInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopGroupInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopGroupInfoWithCallback invokes the cloudwf.ShopGroupInfo API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopgroupinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopGroupInfoWithCallback(request *ShopGroupInfoRequest, callback func(response *ShopGroupInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopGroupInfoResponse
		var err error
		defer close(result)
		response, err = client.ShopGroupInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopGroupInfoRequest is the request struct for api ShopGroupInfo
type ShopGroupInfoRequest struct {
	*requests.RpcRequest
	Gid requests.Integer `position:"Query" name:"Gid"`
}

// ShopGroupInfoResponse is the response struct for api ShopGroupInfo
type ShopGroupInfoResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopGroupInfoRequest creates a request to invoke ShopGroupInfo API
func CreateShopGroupInfoRequest() (request *ShopGroupInfoRequest) {
	request = &ShopGroupInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopGroupInfo", "cloudwf", "openAPI")
	return
}

// CreateShopGroupInfoResponse creates a response to parse from ShopGroupInfo response
func CreateShopGroupInfoResponse() (response *ShopGroupInfoResponse) {
	response = &ShopGroupInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
