package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRepositoryTag invokes the codeup.DeleteRepositoryTag API synchronously
func (client *Client) DeleteRepositoryTag(request *DeleteRepositoryTagRequest) (response *DeleteRepositoryTagResponse, err error) {
	response = CreateDeleteRepositoryTagResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRepositoryTagWithChan invokes the codeup.DeleteRepositoryTag API asynchronously
func (client *Client) DeleteRepositoryTagWithChan(request *DeleteRepositoryTagRequest) (<-chan *DeleteRepositoryTagResponse, <-chan error) {
	responseChan := make(chan *DeleteRepositoryTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRepositoryTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRepositoryTagWithCallback invokes the codeup.DeleteRepositoryTag API asynchronously
func (client *Client) DeleteRepositoryTagWithCallback(request *DeleteRepositoryTagRequest, callback func(response *DeleteRepositoryTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRepositoryTagResponse
		var err error
		defer close(result)
		response, err = client.DeleteRepositoryTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRepositoryTagRequest is the request struct for api DeleteRepositoryTag
type DeleteRepositoryTagRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	TagName        string           `position:"Path" name:"TagName"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// DeleteRepositoryTagResponse is the response struct for api DeleteRepositoryTag
type DeleteRepositoryTagResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateDeleteRepositoryTagRequest creates a request to invoke DeleteRepositoryTag API
func CreateDeleteRepositoryTagRequest() (request *DeleteRepositoryTagRequest) {
	request = &DeleteRepositoryTagRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "DeleteRepositoryTag", "/api/v3/projects/[ProjectId]/repository/tags/[TagName]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteRepositoryTagResponse creates a response to parse from DeleteRepositoryTag response
func CreateDeleteRepositoryTagResponse() (response *DeleteRepositoryTagResponse) {
	response = &DeleteRepositoryTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
