package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGroupDetail invokes the codeup.GetGroupDetail API synchronously
func (client *Client) GetGroupDetail(request *GetGroupDetailRequest) (response *GetGroupDetailResponse, err error) {
	response = CreateGetGroupDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetGroupDetailWithChan invokes the codeup.GetGroupDetail API asynchronously
func (client *Client) GetGroupDetailWithChan(request *GetGroupDetailRequest) (<-chan *GetGroupDetailResponse, <-chan error) {
	responseChan := make(chan *GetGroupDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGroupDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGroupDetailWithCallback invokes the codeup.GetGroupDetail API asynchronously
func (client *Client) GetGroupDetailWithCallback(request *GetGroupDetailRequest, callback func(response *GetGroupDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGroupDetailResponse
		var err error
		defer close(result)
		response, err = client.GetGroupDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGroupDetailRequest is the request struct for api GetGroupDetail
type GetGroupDetailRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	SubUserId      string           `position:"Query" name:"SubUserId"`
	GroupId        requests.Integer `position:"Query" name:"GroupId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
}

// GetGroupDetailResponse is the response struct for api GetGroupDetail
type GetGroupDetailResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateGetGroupDetailRequest creates a request to invoke GetGroupDetail API
func CreateGetGroupDetailRequest() (request *GetGroupDetailRequest) {
	request = &GetGroupDetailRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "GetGroupDetail", "/api/v3/groups/detail", "", "")
	request.Method = requests.GET
	return
}

// CreateGetGroupDetailResponse creates a response to parse from GetGroupDetail response
func CreateGetGroupDetailResponse() (response *GetGroupDetailResponse) {
	response = &GetGroupDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
