package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceDetails invokes the ddoscoo.DescribeInstanceDetails API synchronously
func (client *Client) DescribeInstanceDetails(request *DescribeInstanceDetailsRequest) (response *DescribeInstanceDetailsResponse, err error) {
	response = CreateDescribeInstanceDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceDetailsWithChan invokes the ddoscoo.DescribeInstanceDetails API asynchronously
func (client *Client) DescribeInstanceDetailsWithChan(request *DescribeInstanceDetailsRequest) (<-chan *DescribeInstanceDetailsResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceDetailsWithCallback invokes the ddoscoo.DescribeInstanceDetails API asynchronously
func (client *Client) DescribeInstanceDetailsWithCallback(request *DescribeInstanceDetailsRequest, callback func(response *DescribeInstanceDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceDetailsResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceDetailsRequest is the request struct for api DescribeInstanceDetails
type DescribeInstanceDetailsRequest struct {
	*requests.RpcRequest
	SourceIp    string `position:"Query" name:"SourceIp"`
	InstanceIds string `position:"Query" name:"InstanceIds"`
}

// DescribeInstanceDetailsResponse is the response struct for api DescribeInstanceDetails
type DescribeInstanceDetailsResponse struct {
	*responses.BaseResponse
	RequestId       string           `json:"RequestId" xml:"RequestId"`
	InstanceDetails []InstanceDetail `json:"InstanceDetails" xml:"InstanceDetails"`
}

// CreateDescribeInstanceDetailsRequest creates a request to invoke DescribeInstanceDetails API
func CreateDescribeInstanceDetailsRequest() (request *DescribeInstanceDetailsRequest) {
	request = &DescribeInstanceDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DescribeInstanceDetails", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceDetailsResponse creates a response to parse from DescribeInstanceDetails response
func CreateDescribeInstanceDetailsResponse() (response *DescribeInstanceDetailsResponse) {
	response = &DescribeInstanceDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
