package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTableTopology invokes the dms_enterprise.GetTableTopology API synchronously
func (client *Client) GetTableTopology(request *GetTableTopologyRequest) (response *GetTableTopologyResponse, err error) {
	response = CreateGetTableTopologyResponse()
	err = client.DoAction(request, response)
	return
}

// GetTableTopologyWithChan invokes the dms_enterprise.GetTableTopology API asynchronously
func (client *Client) GetTableTopologyWithChan(request *GetTableTopologyRequest) (<-chan *GetTableTopologyResponse, <-chan error) {
	responseChan := make(chan *GetTableTopologyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTableTopology(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTableTopologyWithCallback invokes the dms_enterprise.GetTableTopology API asynchronously
func (client *Client) GetTableTopologyWithCallback(request *GetTableTopologyRequest, callback func(response *GetTableTopologyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTableTopologyResponse
		var err error
		defer close(result)
		response, err = client.GetTableTopology(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTableTopologyRequest is the request struct for api GetTableTopology
type GetTableTopologyRequest struct {
	*requests.RpcRequest
	TableGuid string           `position:"Query" name:"TableGuid"`
	Tid       requests.Integer `position:"Query" name:"Tid"`
}

// GetTableTopologyResponse is the response struct for api GetTableTopology
type GetTableTopologyResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	Success       bool          `json:"Success" xml:"Success"`
	ErrorMessage  string        `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode     string        `json:"ErrorCode" xml:"ErrorCode"`
	TableTopology TableTopology `json:"TableTopology" xml:"TableTopology"`
}

// CreateGetTableTopologyRequest creates a request to invoke GetTableTopology API
func CreateGetTableTopologyRequest() (request *GetTableTopologyRequest) {
	request = &GetTableTopologyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetTableTopology", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetTableTopologyResponse creates a response to parse from GetTableTopology response
func CreateGetTableTopologyResponse() (response *GetTableTopologyResponse) {
	response = &GetTableTopologyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
