package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SuspendSynchronizationJob invokes the dts.SuspendSynchronizationJob API synchronously
func (client *Client) SuspendSynchronizationJob(request *SuspendSynchronizationJobRequest) (response *SuspendSynchronizationJobResponse, err error) {
	response = CreateSuspendSynchronizationJobResponse()
	err = client.DoAction(request, response)
	return
}

// SuspendSynchronizationJobWithChan invokes the dts.SuspendSynchronizationJob API asynchronously
func (client *Client) SuspendSynchronizationJobWithChan(request *SuspendSynchronizationJobRequest) (<-chan *SuspendSynchronizationJobResponse, <-chan error) {
	responseChan := make(chan *SuspendSynchronizationJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SuspendSynchronizationJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SuspendSynchronizationJobWithCallback invokes the dts.SuspendSynchronizationJob API asynchronously
func (client *Client) SuspendSynchronizationJobWithCallback(request *SuspendSynchronizationJobRequest, callback func(response *SuspendSynchronizationJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SuspendSynchronizationJobResponse
		var err error
		defer close(result)
		response, err = client.SuspendSynchronizationJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SuspendSynchronizationJobRequest is the request struct for api SuspendSynchronizationJob
type SuspendSynchronizationJobRequest struct {
	*requests.RpcRequest
	OwnerId                  string `position:"Query" name:"OwnerId"`
	SynchronizationJobId     string `position:"Query" name:"SynchronizationJobId"`
	AccountId                string `position:"Query" name:"AccountId"`
	SynchronizationDirection string `position:"Query" name:"SynchronizationDirection"`
}

// SuspendSynchronizationJobResponse is the response struct for api SuspendSynchronizationJob
type SuspendSynchronizationJobResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	ErrCode    string `json:"ErrCode" xml:"ErrCode"`
	Success    string `json:"Success" xml:"Success"`
	ErrMessage string `json:"ErrMessage" xml:"ErrMessage"`
}

// CreateSuspendSynchronizationJobRequest creates a request to invoke SuspendSynchronizationJob API
func CreateSuspendSynchronizationJobRequest() (request *SuspendSynchronizationJobRequest) {
	request = &SuspendSynchronizationJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "SuspendSynchronizationJob", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSuspendSynchronizationJobResponse creates a response to parse from SuspendSynchronizationJob response
func CreateSuspendSynchronizationJobResponse() (response *SuspendSynchronizationJobResponse) {
	response = &SuspendSynchronizationJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
