package faas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLoadTaskStatus invokes the faas.DescribeLoadTaskStatus API synchronously
// api document: https://help.aliyun.com/api/faas/describeloadtaskstatus.html
func (client *Client) DescribeLoadTaskStatus(request *DescribeLoadTaskStatusRequest) (response *DescribeLoadTaskStatusResponse, err error) {
	response = CreateDescribeLoadTaskStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLoadTaskStatusWithChan invokes the faas.DescribeLoadTaskStatus API asynchronously
// api document: https://help.aliyun.com/api/faas/describeloadtaskstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLoadTaskStatusWithChan(request *DescribeLoadTaskStatusRequest) (<-chan *DescribeLoadTaskStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeLoadTaskStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLoadTaskStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLoadTaskStatusWithCallback invokes the faas.DescribeLoadTaskStatus API asynchronously
// api document: https://help.aliyun.com/api/faas/describeloadtaskstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLoadTaskStatusWithCallback(request *DescribeLoadTaskStatusRequest, callback func(response *DescribeLoadTaskStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLoadTaskStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeLoadTaskStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLoadTaskStatusRequest is the request struct for api DescribeLoadTaskStatus
type DescribeLoadTaskStatusRequest struct {
	*requests.RpcRequest
	InstanceId    string `position:"Query" name:"InstanceId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	RoleArn       string `position:"Query" name:"RoleArn"`
	FpgaUUID      string `position:"Query" name:"FpgaUUID"`
}

// DescribeLoadTaskStatusResponse is the response struct for api DescribeLoadTaskStatus
type DescribeLoadTaskStatusResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	FpgaUUID      string `json:"FpgaUUID" xml:"FpgaUUID"`
	ShellUUID     string `json:"shellUUID" xml:"shellUUID"`
	FpgaImageUUID string `json:"FpgaImageUUID" xml:"FpgaImageUUID"`
	InstanceId    string `json:"InstanceId" xml:"InstanceId"`
	CreateTime    string `json:"CreateTime" xml:"CreateTime"`
	TaskStatus    string `json:"TaskStatus" xml:"TaskStatus"`
	Encrypted     bool   `json:"Encrypted" xml:"Encrypted"`
}

// CreateDescribeLoadTaskStatusRequest creates a request to invoke DescribeLoadTaskStatus API
func CreateDescribeLoadTaskStatusRequest() (request *DescribeLoadTaskStatusRequest) {
	request = &DescribeLoadTaskStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("faas", "2017-08-24", "DescribeLoadTaskStatus", "faas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLoadTaskStatusResponse creates a response to parse from DescribeLoadTaskStatus response
func CreateDescribeLoadTaskStatusResponse() (response *DescribeLoadTaskStatusResponse) {
	response = &DescribeLoadTaskStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
