package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResizeColdStorageSize invokes the hbase.ResizeColdStorageSize API synchronously
func (client *Client) ResizeColdStorageSize(request *ResizeColdStorageSizeRequest) (response *ResizeColdStorageSizeResponse, err error) {
	response = CreateResizeColdStorageSizeResponse()
	err = client.DoAction(request, response)
	return
}

// ResizeColdStorageSizeWithChan invokes the hbase.ResizeColdStorageSize API asynchronously
func (client *Client) ResizeColdStorageSizeWithChan(request *ResizeColdStorageSizeRequest) (<-chan *ResizeColdStorageSizeResponse, <-chan error) {
	responseChan := make(chan *ResizeColdStorageSizeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResizeColdStorageSize(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResizeColdStorageSizeWithCallback invokes the hbase.ResizeColdStorageSize API asynchronously
func (client *Client) ResizeColdStorageSizeWithCallback(request *ResizeColdStorageSizeRequest, callback func(response *ResizeColdStorageSizeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResizeColdStorageSizeResponse
		var err error
		defer close(result)
		response, err = client.ResizeColdStorageSize(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResizeColdStorageSizeRequest is the request struct for api ResizeColdStorageSize
type ResizeColdStorageSizeRequest struct {
	*requests.RpcRequest
	ClusterId       string           `position:"Query" name:"ClusterId"`
	ColdStorageSize requests.Integer `position:"Query" name:"ColdStorageSize"`
}

// ResizeColdStorageSizeResponse is the response struct for api ResizeColdStorageSize
type ResizeColdStorageSizeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateResizeColdStorageSizeRequest creates a request to invoke ResizeColdStorageSize API
func CreateResizeColdStorageSizeRequest() (request *ResizeColdStorageSizeRequest) {
	request = &ResizeColdStorageSizeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "ResizeColdStorageSize", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateResizeColdStorageSizeResponse creates a response to parse from ResizeColdStorageSize response
func CreateResizeColdStorageSizeResponse() (response *ResizeColdStorageSizeResponse) {
	response = &ResizeColdStorageSizeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
