package linkface

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LinkFace invokes the linkface.LinkFace API synchronously
// api document: https://help.aliyun.com/api/linkface/linkface.html
func (client *Client) LinkFace(request *LinkFaceRequest) (response *LinkFaceResponse, err error) {
	response = CreateLinkFaceResponse()
	err = client.DoAction(request, response)
	return
}

// LinkFaceWithChan invokes the linkface.LinkFace API asynchronously
// api document: https://help.aliyun.com/api/linkface/linkface.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) LinkFaceWithChan(request *LinkFaceRequest) (<-chan *LinkFaceResponse, <-chan error) {
	responseChan := make(chan *LinkFaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LinkFace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LinkFaceWithCallback invokes the linkface.LinkFace API asynchronously
// api document: https://help.aliyun.com/api/linkface/linkface.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) LinkFaceWithCallback(request *LinkFaceRequest, callback func(response *LinkFaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LinkFaceResponse
		var err error
		defer close(result)
		response, err = client.LinkFace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LinkFaceRequest is the request struct for api LinkFace
type LinkFaceRequest struct {
	*requests.RpcRequest
	GroupId string `position:"Body" name:"GroupId"`
	UserId  string `position:"Body" name:"UserId"`
}

// LinkFaceResponse is the response struct for api LinkFace
type LinkFaceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateLinkFaceRequest creates a request to invoke LinkFace API
func CreateLinkFaceRequest() (request *LinkFaceRequest) {
	request = &LinkFaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkFace", "2018-07-20", "LinkFace", "", "")
	return
}

// CreateLinkFaceResponse creates a response to parse from LinkFace response
func CreateLinkFaceResponse() (response *LinkFaceResponse) {
	response = &LinkFaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
