package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListActivatedFeatures invokes the linkwan.ListActivatedFeatures API synchronously
func (client *Client) ListActivatedFeatures(request *ListActivatedFeaturesRequest) (response *ListActivatedFeaturesResponse, err error) {
	response = CreateListActivatedFeaturesResponse()
	err = client.DoAction(request, response)
	return
}

// ListActivatedFeaturesWithChan invokes the linkwan.ListActivatedFeatures API asynchronously
func (client *Client) ListActivatedFeaturesWithChan(request *ListActivatedFeaturesRequest) (<-chan *ListActivatedFeaturesResponse, <-chan error) {
	responseChan := make(chan *ListActivatedFeaturesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListActivatedFeatures(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListActivatedFeaturesWithCallback invokes the linkwan.ListActivatedFeatures API asynchronously
func (client *Client) ListActivatedFeaturesWithCallback(request *ListActivatedFeaturesRequest, callback func(response *ListActivatedFeaturesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListActivatedFeaturesResponse
		var err error
		defer close(result)
		response, err = client.ListActivatedFeatures(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListActivatedFeaturesRequest is the request struct for api ListActivatedFeatures
type ListActivatedFeaturesRequest struct {
	*requests.RpcRequest
	Environment string `position:"Query" name:"Environment"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// ListActivatedFeaturesResponse is the response struct for api ListActivatedFeatures
type ListActivatedFeaturesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Success   bool     `json:"Success" xml:"Success"`
	Data      []string `json:"Data" xml:"Data"`
}

// CreateListActivatedFeaturesRequest creates a request to invoke ListActivatedFeatures API
func CreateListActivatedFeaturesRequest() (request *ListActivatedFeaturesRequest) {
	request = &ListActivatedFeaturesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "ListActivatedFeatures", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListActivatedFeaturesResponse creates a response to parse from ListActivatedFeatures response
func CreateListActivatedFeaturesResponse() (response *ListActivatedFeaturesResponse) {
	response = &ListActivatedFeaturesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
