package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddPlaylistItems invokes the live.AddPlaylistItems API synchronously
func (client *Client) AddPlaylistItems(request *AddPlaylistItemsRequest) (response *AddPlaylistItemsResponse, err error) {
	response = CreateAddPlaylistItemsResponse()
	err = client.DoAction(request, response)
	return
}

// AddPlaylistItemsWithChan invokes the live.AddPlaylistItems API asynchronously
func (client *Client) AddPlaylistItemsWithChan(request *AddPlaylistItemsRequest) (<-chan *AddPlaylistItemsResponse, <-chan error) {
	responseChan := make(chan *AddPlaylistItemsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddPlaylistItems(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddPlaylistItemsWithCallback invokes the live.AddPlaylistItems API asynchronously
func (client *Client) AddPlaylistItemsWithCallback(request *AddPlaylistItemsRequest, callback func(response *AddPlaylistItemsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddPlaylistItemsResponse
		var err error
		defer close(result)
		response, err = client.AddPlaylistItems(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddPlaylistItemsRequest is the request struct for api AddPlaylistItems
type AddPlaylistItemsRequest struct {
	*requests.RpcRequest
	ProgramItems  string           `position:"Query" name:"ProgramItems"`
	ProgramId     string           `position:"Query" name:"ProgramId"`
	CasterId      string           `position:"Query" name:"CasterId"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	ProgramConfig string           `position:"Query" name:"ProgramConfig"`
}

// AddPlaylistItemsResponse is the response struct for api AddPlaylistItems
type AddPlaylistItemsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ProgramId string `json:"ProgramId" xml:"ProgramId"`
	Items     Items  `json:"Items" xml:"Items"`
}

// CreateAddPlaylistItemsRequest creates a request to invoke AddPlaylistItems API
func CreateAddPlaylistItemsRequest() (request *AddPlaylistItemsRequest) {
	request = &AddPlaylistItemsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddPlaylistItems", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddPlaylistItemsResponse creates a response to parse from AddPlaylistItems response
func CreateAddPlaylistItemsResponse() (response *AddPlaylistItemsResponse) {
	response = &AddPlaylistItemsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
