package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLicense invokes the market.DescribeLicense API synchronously
// api document: https://help.aliyun.com/api/market/describelicense.html
func (client *Client) DescribeLicense(request *DescribeLicenseRequest) (response *DescribeLicenseResponse, err error) {
	response = CreateDescribeLicenseResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLicenseWithChan invokes the market.DescribeLicense API asynchronously
// api document: https://help.aliyun.com/api/market/describelicense.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLicenseWithChan(request *DescribeLicenseRequest) (<-chan *DescribeLicenseResponse, <-chan error) {
	responseChan := make(chan *DescribeLicenseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLicense(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLicenseWithCallback invokes the market.DescribeLicense API asynchronously
// api document: https://help.aliyun.com/api/market/describelicense.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLicenseWithCallback(request *DescribeLicenseRequest, callback func(response *DescribeLicenseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLicenseResponse
		var err error
		defer close(result)
		response, err = client.DescribeLicense(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLicenseRequest is the request struct for api DescribeLicense
type DescribeLicenseRequest struct {
	*requests.RpcRequest
	LicenseCode string `position:"Query" name:"LicenseCode"`
}

// DescribeLicenseResponse is the response struct for api DescribeLicense
type DescribeLicenseResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	License   License `json:"License" xml:"License"`
}

// CreateDescribeLicenseRequest creates a request to invoke DescribeLicense API
func CreateDescribeLicenseRequest() (request *DescribeLicenseRequest) {
	request = &DescribeLicenseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "DescribeLicense", "yunmarket", "openAPI")
	return
}

// CreateDescribeLicenseResponse creates a response to parse from DescribeLicense response
func CreateDescribeLicenseResponse() (response *DescribeLicenseResponse) {
	response = &DescribeLicenseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
