package ocr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizePDF invokes the ocr.RecognizePDF API synchronously
func (client *Client) RecognizePDF(request *RecognizePDFRequest) (response *RecognizePDFResponse, err error) {
	response = CreateRecognizePDFResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizePDFWithChan invokes the ocr.RecognizePDF API asynchronously
func (client *Client) RecognizePDFWithChan(request *RecognizePDFRequest) (<-chan *RecognizePDFResponse, <-chan error) {
	responseChan := make(chan *RecognizePDFResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizePDF(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizePDFWithCallback invokes the ocr.RecognizePDF API asynchronously
func (client *Client) RecognizePDFWithCallback(request *RecognizePDFRequest, callback func(response *RecognizePDFResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizePDFResponse
		var err error
		defer close(result)
		response, err = client.RecognizePDF(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizePDFRequest is the request struct for api RecognizePDF
type RecognizePDFRequest struct {
	*requests.RpcRequest
	FileURL string `position:"Body" name:"FileURL"`
}

// RecognizePDFResponse is the response struct for api RecognizePDF
type RecognizePDFResponse struct {
	*responses.BaseResponse
	RequestId string             `json:"RequestId" xml:"RequestId"`
	Code      string             `json:"Code" xml:"Code"`
	Message   string             `json:"Message" xml:"Message"`
	Data      DataInRecognizePDF `json:"Data" xml:"Data"`
}

// CreateRecognizePDFRequest creates a request to invoke RecognizePDF API
func CreateRecognizePDFRequest() (request *RecognizePDFRequest) {
	request = &RecognizePDFRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ocr", "2019-12-30", "RecognizePDF", "ocr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizePDFResponse creates a response to parse from RecognizePDF response
func CreateRecognizePDFResponse() (response *RecognizePDFResponse) {
	response = &RecognizePDFResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
