package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVpcEndpointServiceUsers invokes the privatelink.ListVpcEndpointServiceUsers API synchronously
func (client *Client) ListVpcEndpointServiceUsers(request *ListVpcEndpointServiceUsersRequest) (response *ListVpcEndpointServiceUsersResponse, err error) {
	response = CreateListVpcEndpointServiceUsersResponse()
	err = client.DoAction(request, response)
	return
}

// ListVpcEndpointServiceUsersWithChan invokes the privatelink.ListVpcEndpointServiceUsers API asynchronously
func (client *Client) ListVpcEndpointServiceUsersWithChan(request *ListVpcEndpointServiceUsersRequest) (<-chan *ListVpcEndpointServiceUsersResponse, <-chan error) {
	responseChan := make(chan *ListVpcEndpointServiceUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVpcEndpointServiceUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVpcEndpointServiceUsersWithCallback invokes the privatelink.ListVpcEndpointServiceUsers API asynchronously
func (client *Client) ListVpcEndpointServiceUsersWithCallback(request *ListVpcEndpointServiceUsersRequest, callback func(response *ListVpcEndpointServiceUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVpcEndpointServiceUsersResponse
		var err error
		defer close(result)
		response, err = client.ListVpcEndpointServiceUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVpcEndpointServiceUsersRequest is the request struct for api ListVpcEndpointServiceUsers
type ListVpcEndpointServiceUsersRequest struct {
	*requests.RpcRequest
	UserId     requests.Integer `position:"Query" name:"UserId"`
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
	ServiceId  string           `position:"Query" name:"ServiceId"`
}

// ListVpcEndpointServiceUsersResponse is the response struct for api ListVpcEndpointServiceUsers
type ListVpcEndpointServiceUsersResponse struct {
	*responses.BaseResponse
	NextToken  string `json:"NextToken" xml:"NextToken"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	MaxResults string `json:"MaxResults" xml:"MaxResults"`
	Users      []User `json:"Users" xml:"Users"`
}

// CreateListVpcEndpointServiceUsersRequest creates a request to invoke ListVpcEndpointServiceUsers API
func CreateListVpcEndpointServiceUsersRequest() (request *ListVpcEndpointServiceUsersRequest) {
	request = &ListVpcEndpointServiceUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "ListVpcEndpointServiceUsers", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVpcEndpointServiceUsersResponse creates a response to parse from ListVpcEndpointServiceUsers response
func CreateListVpcEndpointServiceUsersResponse() (response *ListVpcEndpointServiceUsersResponse) {
	response = &ListVpcEndpointServiceUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
