package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEmbedToken invokes the quickbi_public.DeleteEmbedToken API synchronously
func (client *Client) DeleteEmbedToken(request *DeleteEmbedTokenRequest) (response *DeleteEmbedTokenResponse, err error) {
	response = CreateDeleteEmbedTokenResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEmbedTokenWithChan invokes the quickbi_public.DeleteEmbedToken API asynchronously
func (client *Client) DeleteEmbedTokenWithChan(request *DeleteEmbedTokenRequest) (<-chan *DeleteEmbedTokenResponse, <-chan error) {
	responseChan := make(chan *DeleteEmbedTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEmbedToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEmbedTokenWithCallback invokes the quickbi_public.DeleteEmbedToken API asynchronously
func (client *Client) DeleteEmbedTokenWithCallback(request *DeleteEmbedTokenRequest, callback func(response *DeleteEmbedTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEmbedTokenResponse
		var err error
		defer close(result)
		response, err = client.DeleteEmbedToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEmbedTokenRequest is the request struct for api DeleteEmbedToken
type DeleteEmbedTokenRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	Token       string `position:"Query" name:"Token"`
}

// DeleteEmbedTokenResponse is the response struct for api DeleteEmbedToken
type DeleteEmbedTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteEmbedTokenRequest creates a request to invoke DeleteEmbedToken API
func CreateDeleteEmbedTokenRequest() (request *DeleteEmbedTokenRequest) {
	request = &DeleteEmbedTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2021-03-25", "DeleteEmbedToken", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteEmbedTokenResponse creates a response to parse from DeleteEmbedToken response
func CreateDeleteEmbedTokenResponse() (response *DeleteEmbedTokenResponse) {
	response = &DeleteEmbedTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
