package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFieldStatistics invokes the sas.DescribeFieldStatistics API synchronously
func (client *Client) DescribeFieldStatistics(request *DescribeFieldStatisticsRequest) (response *DescribeFieldStatisticsResponse, err error) {
	response = CreateDescribeFieldStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFieldStatisticsWithChan invokes the sas.DescribeFieldStatistics API asynchronously
func (client *Client) DescribeFieldStatisticsWithChan(request *DescribeFieldStatisticsRequest) (<-chan *DescribeFieldStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeFieldStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFieldStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFieldStatisticsWithCallback invokes the sas.DescribeFieldStatistics API asynchronously
func (client *Client) DescribeFieldStatisticsWithCallback(request *DescribeFieldStatisticsRequest, callback func(response *DescribeFieldStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFieldStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeFieldStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFieldStatisticsRequest is the request struct for api DescribeFieldStatistics
type DescribeFieldStatisticsRequest struct {
	*requests.RpcRequest
	MachineTypes string `position:"Query" name:"MachineTypes"`
	SourceIp     string `position:"Query" name:"SourceIp"`
}

// DescribeFieldStatisticsResponse is the response struct for api DescribeFieldStatistics
type DescribeFieldStatisticsResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	GroupedFields GroupedFields `json:"GroupedFields" xml:"GroupedFields"`
}

// CreateDescribeFieldStatisticsRequest creates a request to invoke DescribeFieldStatistics API
func CreateDescribeFieldStatisticsRequest() (request *DescribeFieldStatisticsRequest) {
	request = &DescribeFieldStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeFieldStatistics", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeFieldStatisticsResponse creates a response to parse from DescribeFieldStatistics response
func CreateDescribeFieldStatisticsResponse() (response *DescribeFieldStatisticsResponse) {
	response = &DescribeFieldStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
